/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.ogroids;

import TCOTS.entity.TrollGossips;
import TCOTS.entity.goals.MeleeAttackGoal_Animated;
import TCOTS.entity.ogroids.ForestTrollEntity;
import TCOTS.entity.ogroids.OgroidMonster;
import TCOTS.entity.ogroids.RockTrollEntity;
import TCOTS.items.HerbalMixture;
import TCOTS.items.concoctions.WitcherAlcohol_Base;
import TCOTS.items.concoctions.WitcherPotions_Base;
import TCOTS.registry.TCOTS_Criteria;
import TCOTS.registry.TCOTS_Entities;
import TCOTS.registry.TCOTS_Items;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.EntitiesUtil;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1381;
import net.minecraft.class_14;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1542;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_173;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_181;
import net.minecraft.class_1812;
import net.minecraft.class_1828;
import net.minecraft.class_1829;
import net.minecraft.class_1839;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3763;
import net.minecraft.class_3988;
import net.minecraft.class_4051;
import net.minecraft.class_4094;
import net.minecraft.class_4151;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_6019;
import net.minecraft.class_7;
import net.minecraft.class_8046;
import net.minecraft.class_8103;
import net.minecraft.class_8567;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.RawAnimation;

public abstract class AbstractTrollEntity
extends OgroidMonster
implements GeoEntity,
class_5354,
class_8046,
class_4094 {
    private static final class_2940<Boolean> RABID = class_2945.method_12791(AbstractTrollEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> EATING_TIME = class_2945.method_12791(AbstractTrollEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2338> GUARDING_POS = class_2945.method_12791(AbstractTrollEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Integer> FOLLOWER_STATE = class_2945.method_12791(AbstractTrollEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> BLOCKING = class_2945.method_12791(AbstractTrollEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> TIME_BLOCKING = class_2945.method_12791(AbstractTrollEntity.class, (class_2941)class_2943.field_13327);
    public static final RawAnimation GIVE_ITEM = RawAnimation.begin().thenPlay("special.give");
    public static final RawAnimation BLOCK = RawAnimation.begin().thenPlayAndHold("special.block");
    public static final RawAnimation UNBLOCK = RawAnimation.begin().thenPlay("special.unblock");
    private int angerTime;
    @Nullable
    private UUID angryAt;
    private static final class_2382 ITEM_PICKUP_RANGE_EXPANDER = new class_2382(1, 1, 1);
    private long lastGossipDecayTime;
    protected int admiringTime = -1;
    @Nullable
    protected class_1657 lastPlayer;
    @Nullable
    protected UUID lastPlayerUuid;
    @Nullable
    protected UUID ownerUuid;
    public float eatingProgress;
    public float maxEatingDeviation;
    public float prevMaxEatingDeviation;
    public float prevEatingProgress;
    public float eatingSpeed = 1.0f;
    private final int TOTAL_ADMIRING_TIME = 60;
    private final int TOTAL_EATING_TIME = 40;

    public AbstractTrollEntity(class_1299<? extends AbstractTrollEntity> entityType, class_1937 world) {
        super((class_1299<? extends OgroidMonster>)entityType, world);
        this.method_5952(true);
        this.field_6194 = 8;
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RABID, (Object)Boolean.FALSE);
        builder.method_56912(EATING_TIME, (Object)-1);
        builder.method_56912(GUARDING_POS, (Object)class_2338.field_10980);
        builder.method_56912(FOLLOWER_STATE, (Object)0);
        builder.method_56912(BLOCKING, (Object)Boolean.FALSE);
        builder.method_56912(TIME_BLOCKING, (Object)0);
    }

    @NotNull
    protected class_2561 method_23315() {
        if (this.isRabid()) {
            return class_2561.method_43471((String)(this.method_5864().method_5882() + "_rabid"));
        }
        return super.method_23315();
    }

    public boolean method_18395(@NotNull class_1309 target) {
        if (!this.isRabid() && target instanceof class_3988) {
            return false;
        }
        if (!this.isRabid() && this.method_49107() instanceof class_3763) {
            return true;
        }
        if (!this.isRabid() && this.isWandering() && target instanceof class_3763) {
            return false;
        }
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            if (this.method_24921() == target) {
                if (this.getFriendship(player) >= this.getMinReputationToGoAgainstOwner()) {
                    return false;
                }
                this.setOwner(null);
                this.setFollowerState(0);
                player.method_7353((class_2561)class_2561.method_43469((String)"tcots_witcher.gui.troll_wandering", (Object[])new Object[]{this.method_5477()}), true);
                this.setGuardingPos(class_2338.field_10980);
                return true;
            }
        }
        if (target instanceof class_1657 && this.method_37908().method_8407() == class_1267.field_5801) {
            return false;
        }
        return target.method_33190();
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (!(this.method_37908().field_9236 || this.method_6510() || this.hasBarteringItem() || this.isRabid() || this.hasFoodOrAlcohol() || this.method_29507() != 0 || this.isTrollBlocking())) {
            if ((this.isFollowing() || this.isWaiting()) && this.method_24921() == player && player.method_5715()) {
                this.setOwner(null);
                this.setFollowerState(0);
                player.method_7353((class_2561)class_2561.method_43469((String)"tcots_witcher.gui.troll_wandering", (Object[])new Object[]{this.method_5477()}), true);
                this.setGuardingPos(class_2338.field_10980);
                return class_1269.field_5812;
            }
            if (itemStack.method_31574(this.getBarteringItem()) && this.getReputation(player) >= this.getMinReputationGiveBarterItem() && this.isWandering()) {
                this.method_6122(class_1268.field_5810, new class_1799((class_1935)this.getBarteringItem()));
                this.setLastPlayer(player);
                this.setAdmiringTime(0);
                itemStack.method_7934(1);
                this.method_5971();
                return class_1269.field_5812;
            }
            if (this.isEdible(itemStack)) {
                this.method_6122(class_1268.field_5810, itemStack.method_46651(1));
                this.setLastPlayer(player);
                this.setEatingTime(0);
                itemStack.method_7934(1);
                this.method_5971();
                return class_1269.field_5812;
            }
            if (this.isDrinkable(item)) {
                this.method_6122(class_1268.field_5810, itemStack.method_46651(1));
                this.setLastPlayer(player);
                this.setEatingTime(0);
                itemStack.method_7934(1);
                this.method_5971();
                return class_1269.field_5812;
            }
            if (hand != class_1268.field_5808) {
                return class_1269.field_5811;
            }
            if ((this.isWandering() && this.getFriendship(player) >= this.getMinFriendshipToBeFollower() && this.method_24921() == null && this.getOwnerUuid() == null || !this.isWandering() && this.method_24921() == player) && !player.method_5715()) {
                if (this.method_24921() == null) {
                    this.setOwner(player);
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        TCOTS_Criteria.GetTrollFollower().trigger(serverPlayer, (class_1314)this);
                    }
                }
                this.setFollowerState(this.isWandering() ? 1 : (this.isFollowing() ? 2 : 1));
                player.method_7353((class_2561)(this.isFollowing() ? class_2561.method_43469((String)"tcots_witcher.gui.troll_follows", (Object[])new Object[]{this.method_5477()}) : class_2561.method_43469((String)"tcots_witcher.gui.troll_waits", (Object[])new Object[]{this.method_5477()})), true);
                if (this.isWaiting()) {
                    this.setGuardingPos(this.method_23312());
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    protected void method_5958() {
        super.method_5958();
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
        if (this.isTrollBlocking()) {
            this.setTimeBlocking(this.getTimeBlocking() + 1);
        }
        if (this.isTrollBlocking() && this.getTimeBlocking() == this.maxTicksBlocking()) {
            this.setIsTrollBlocking(false);
            this.setTimeBlocking(0);
        }
    }

    protected int maxTicksBlocking() {
        return 80;
    }

    protected boolean shouldAngerAtPlayer(class_1309 entity) {
        if (this.isRabid()) {
            return true;
        }
        if (!this.method_18395(entity)) {
            return false;
        }
        if (entity.method_5864() == class_1299.field_6097 && this.method_29923(entity.method_37908())) {
            return true;
        }
        return entity.method_5667().equals(this.method_29508());
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    protected class_6019 getAngerTimeRange() {
        return class_4802.method_24505((int)20, (int)39);
    }

    public void method_29509() {
        this.method_29514(this.getAngerTimeRange().method_35008(this.field_5974));
    }

    public void setIsRabid(boolean isRabid) {
        this.field_6011.method_12778(RABID, (Object)isRabid);
    }

    public boolean isRabid() {
        return (Boolean)this.field_6011.method_12789(RABID);
    }

    public boolean method_20820(@NotNull class_1799 stack) {
        return this.canGather();
    }

    public boolean canGather() {
        return this.method_37908().method_8450().method_8355(class_1928.field_19388) && this.method_5936() && this.trollCanGather();
    }

    private boolean trollCanGather() {
        return !this.method_6510() && !this.method_6039() && !this.hasBarteringItem() && this.method_29507() == 0 && !this.hasFoodOrAlcohol() && this.method_5968() == null;
    }

    protected void method_5949(@NotNull class_1542 item) {
        this.method_29499(item);
        this.handleItemFromGround(item);
    }

    protected void handleItemFromGround(@NotNull class_1542 item) {
        boolean isBartering;
        boolean bl = isBartering = item.method_6983().method_7909() == this.getBarteringItem();
        if (isBartering && this.isWandering() || this.isEdible(item.method_6983()) || this.isDrinkable(item.method_6983().method_7909())) {
            class_1297 class_12972;
            this.method_6103((class_1297)item, 1);
            class_1799 itemStack = EntitiesUtil.getItemFromStack(item);
            this.method_6122(class_1268.field_5810, itemStack);
            if (item.method_24921() != null && (class_12972 = item.method_24921()) instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                this.setLastPlayer(player);
            }
            if (isBartering) {
                this.setAdmiringTime(0);
            } else {
                this.setEatingTime(0);
            }
            this.method_5971();
        }
    }

    @NotNull
    protected class_2382 method_42646() {
        return ITEM_PICKUP_RANGE_EXPANDER;
    }

    public abstract TrollGossips getGossip();

    protected abstract class_4151 getKillInteraction();

    protected abstract class_4151 getHurtInteraction(boolean var1);

    public abstract class_4151 getDefendingInteraction(boolean var1);

    protected abstract class_4151 getFeedInteraction(boolean var1);

    protected abstract class_4151 getAlcoholInteraction(boolean var1);

    protected abstract class_4151 getBarterInteraction(boolean var1);

    protected void decayGossip() {
        long l = this.method_37908().method_8510();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = l;
            return;
        }
        if (l < this.lastGossipDecayTime + 24000L) {
            return;
        }
        this.getGossip().decay();
        this.lastGossipDecayTime = l;
    }

    public void handleNearTrollsInteraction(class_4151 interaction, class_1657 player) {
        for (AbstractTrollEntity nearTroll : this.getNearTrolls()) {
            ((class_3218)this.method_37908()).method_19496(interaction, (class_1297)player, (class_4094)nearTroll);
        }
    }

    public void handleNearTrollsParticles(byte byteSent) {
        for (AbstractTrollEntity nearTroll : this.getNearTrolls()) {
            nearTroll.method_37908().method_8421((class_1297)nearTroll, byteSent);
        }
    }

    public List<AbstractTrollEntity> getNearTrolls() {
        return this.method_37908().method_8390(AbstractTrollEntity.class, this.method_5829().method_1009(10.0, 2.0, 10.0), troll -> troll.method_5864() == this.method_5864() && troll.method_6057((class_1297)this) && troll != this && !troll.isRabid());
    }

    public void method_6015(@Nullable class_1309 attacker) {
        if (!this.isRabid() && attacker != null && this.method_37908() instanceof class_3218 && attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            ((class_3218)this.method_37908()).method_19496(this.getHurtInteraction(false), (class_1297)attacker, (class_4094)this);
            this.handleNearTrollsInteraction(this.getHurtInteraction(true), player);
            if (this.method_5805() && attacker instanceof class_1657) {
                this.method_37908().method_8421((class_1297)this, (byte)13);
                this.handleNearTrollsParticles((byte)13);
            }
        }
        super.method_6015(attacker);
    }

    public void method_6078(@NotNull class_1282 damageSource) {
        class_1297 attacker = damageSource.method_5529();
        if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.method_24921() instanceof class_3222) {
            this.method_24921().method_43496(this.method_6066().method_5548());
        }
        if (!this.isRabid() && this.method_37908() instanceof class_3218 && attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            this.handleNearTrollsInteraction(this.getKillInteraction(), player);
            this.handleNearTrollsParticles((byte)13);
        }
        super.method_6078(damageSource);
    }

    public int getReputation(@NotNull class_1657 player) {
        return this.getGossip().getReputationFor(player.method_5667(), gossipType -> true);
    }

    public int getFriendship(@NotNull class_1657 player) {
        return this.getGossip().getFriendshipFor(player.method_5667(), gossipType -> true);
    }

    public void method_5711(byte status) {
        if (status == 12) {
            this.produceParticles((class_2394)class_2398.field_11201);
        } else if (status == 13) {
            this.produceParticles((class_2394)class_2398.field_11231);
        } else if (status == 14) {
            this.produceParticles((class_2394)class_2398.field_11211);
        } else if (status == 42) {
            this.produceParticles((class_2394)class_2398.field_11202);
        } else {
            super.method_5711(status);
        }
    }

    protected void produceParticles(class_2394 parameters) {
        for (int i = 0; i < 5; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406(parameters, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f);
        }
    }

    public void setAdmiringTime(int admiringTime) {
        this.admiringTime = admiringTime;
    }

    public int getAdmiringTime() {
        return this.admiringTime;
    }

    public void addAdmiringTime() {
        this.setAdmiringTime(this.getAdmiringTime() + 1);
    }

    protected void tickAdmiringItem() {
        if (this.getAdmiringTime() != -1 && this.getAdmiringTime() < 60 && this.method_29507() > 0) {
            this.setLastPlayer(null);
            this.dropBarteringLoot(this, this.getLastPlayer());
            this.setAdmiringTime(-1);
        }
        if (this.getAdmiringTime() < 60 && this.getAdmiringTime() != -1) {
            this.addAdmiringTime();
        } else if (this.getAdmiringTime() == 60) {
            this.dropBarteringLoot(this, this.getLastPlayer());
            this.setAdmiringTime(-1);
        }
    }

    public boolean hasBarteringItem() {
        return this.method_5998(class_1268.field_5810).method_7909() == this.getBarteringItem();
    }

    protected void dropBarteringLoot(AbstractTrollEntity troll, @Nullable class_1657 player) {
        if (player != null) {
            ((class_3218)this.method_37908()).method_19496(this.getBarterInteraction(false), (class_1297)player, (class_4094)this);
            this.handleNearTrollsInteraction(this.getBarterInteraction(true), player);
            this.method_37908().method_8421((class_1297)this, this.getFriendship(player) > this.getMinFriendshipToBeFollower() ? (byte)12 : 14);
            if (this.getReputation(player) >= this.getMinReputationToBarter()) {
                this.triggerAnim("GiveController", "give_item");
                for (class_1799 itemStack : this.getBarteredItems(this)) {
                    class_243 vec3d = new class_243((double)0.3f, (double)0.3f, (double)0.3f);
                    this.method_5702(class_2183.class_2184.field_9851, player.method_19538().method_1031(0.0, 1.0, 0.0));
                    this.give((class_1309)troll, itemStack, player.method_19538().method_1031(0.0, 1.0, 0.0), vec3d, 0.3f);
                }
                if (this.getReputation(player) >= 70 && this.method_59922().method_39332(0, 8) == 1) {
                    class_243 vec3d = new class_243((double)0.3f, (double)0.3f, (double)0.3f);
                    this.give((class_1309)troll, new class_1799((class_1935)TCOTS_Items.TROLL_MUTAGEN.get()), player.method_19538().method_1031(0.0, 1.0, 0.0), vec3d, 0.3f);
                }
            }
            this.method_6122(class_1268.field_5810, class_1799.field_8037);
            this.setLastPlayer(null);
            this.method_5783(TCOTS_Sounds.getSoundEvent("troll_bartering"), 1.0f, 1.0f);
        } else {
            this.method_6122(class_1268.field_5810, class_1799.field_8037);
        }
    }

    public void give(@NotNull class_1309 entity, class_1799 stack, @NotNull class_243 targetLocation, @NotNull class_243 velocityFactor, float yOffset) {
        double d = entity.method_23320() - (double)yOffset;
        class_1542 itemEntity = new class_1542(entity.method_37908(), entity.method_23317(), d, entity.method_23321(), stack);
        itemEntity.method_6981((class_1297)entity);
        class_243 vec3d = targetLocation.method_1020(entity.method_19538());
        vec3d = vec3d.method_1029().method_18805(velocityFactor.field_1352, velocityFactor.field_1351, velocityFactor.field_1350);
        itemEntity.method_18799(vec3d);
        itemEntity.method_6988();
        entity.method_37908().method_8649((class_1297)itemEntity);
    }

    protected List<class_1799> getBarteredItems(@NotNull AbstractTrollEntity troll) {
        if (troll.method_37908().method_8503() == null) {
            return Collections.emptyList();
        }
        class_52 lootTable = troll.method_37908().method_8503().method_58576().method_58295(this.getTrollLootTable());
        return lootTable.method_51878(new class_8567.class_8568((class_3218)troll.method_37908()).method_51874(class_181.field_1226, (Object)troll).method_51875(class_173.field_22403));
    }

    @Nullable
    public class_1657 getLastPlayer() {
        class_1657 entity;
        if (this.lastPlayer == null && this.lastPlayerUuid != null && this.method_37908() instanceof class_3218 && (entity = this.method_37908().method_18470(this.lastPlayerUuid)) != null) {
            this.lastPlayer = entity;
        }
        return this.lastPlayer;
    }

    public void setLastPlayer(@Nullable class_1657 lastPlayer) {
        this.lastPlayer = lastPlayer;
        this.lastPlayerUuid = lastPlayer == null ? null : lastPlayer.method_5667();
    }

    protected int getMinReputationToBarter() {
        return -30;
    }

    protected int getMinReputationGiveBarterItem() {
        return -75;
    }

    protected abstract class_5321<class_52> getTrollLootTable();

    protected abstract class_1792 getBarteringItem();

    protected int getMinReputationToGoAgainstOwner() {
        return 75;
    }

    public int getMinFriendshipToBeFollower() {
        return 150;
    }

    @Nullable
    public class_1297 method_24921() {
        UUID uUID = this.getOwnerUuid();
        if (uUID == null) {
            return null;
        }
        return this.method_37908().method_18470(uUID);
    }

    public void setOwner(@Nullable class_1657 owner) {
        this.ownerUuid = owner == null ? null : owner.method_5667();
    }

    @Nullable
    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public void setFollowerState(int followerState) {
        this.field_6011.method_12778(FOLLOWER_STATE, (Object)followerState);
        if (this.isFollowing() || this.isWaiting()) {
            this.method_5783(this.isWaiting() ? TCOTS_Sounds.getSoundEvent("troll_waiting") : TCOTS_Sounds.getSoundEvent("troll_follow"), 1.0f, 1.0f);
            Objects.requireNonNull(this.method_5996(class_5134.field_23724)).method_6192(this.method_5864() == TCOTS_Entities.RockTroll() ? 16.0 : (this.method_5864() == TCOTS_Entities.IceTroll() ? 12.0 : 4.0));
            Objects.requireNonNull(this.method_5996(class_5134.field_23725)).method_6192(this.method_5864() == TCOTS_Entities.RockTroll() ? 8.0 : (this.method_5864() == TCOTS_Entities.IceTroll() ? 6.0 : 1.0));
        } else {
            this.method_5783(TCOTS_Sounds.getSoundEvent("troll_dismiss"), 1.0f, 1.0f);
            Objects.requireNonNull(this.method_5996(class_5134.field_23724)).method_6192(this.method_5864() == TCOTS_Entities.RockTroll() ? 8.0 : (this.method_5864() == TCOTS_Entities.IceTroll() ? 6.0 : 4.0));
            Objects.requireNonNull(this.method_5996(class_5134.field_23725)).method_6192(this.method_5864() == TCOTS_Entities.RockTroll() ? 4.0 : (this.method_5864() == TCOTS_Entities.IceTroll() ? 2.0 : 1.0));
        }
    }

    public int getFollowerState() {
        return (Integer)this.field_6011.method_12789(FOLLOWER_STATE);
    }

    public boolean isWaiting() {
        return this.getFollowerState() == 2;
    }

    public boolean isFollowing() {
        return this.getFollowerState() == 1;
    }

    public boolean isWandering() {
        return this.getFollowerState() == 0;
    }

    public void setGuardingPos(class_2338 pos) {
        this.field_6011.method_12778(GUARDING_POS, (Object)pos);
    }

    public class_2338 getGuardingPos() {
        return (class_2338)this.field_6011.method_12789(GUARDING_POS);
    }

    public void setEatingTime(int eatingTime) {
        this.field_6011.method_12778(EATING_TIME, (Object)eatingTime);
    }

    public int getEatingTime() {
        return (Integer)this.field_6011.method_12789(EATING_TIME);
    }

    public void addEatingTime() {
        this.setEatingTime(this.getEatingTime() + 1);
    }

    public void method_6007() {
        super.method_6007();
        this.prevEatingProgress = this.eatingProgress;
        this.prevMaxEatingDeviation = this.maxEatingDeviation;
        if (this.hasFoodOrAlcohol()) {
            this.maxEatingDeviation += -0.3f;
        }
        this.maxEatingDeviation = class_3532.method_15363((float)this.maxEatingDeviation, (float)-0.05f, (float)0.05f);
        if (this.hasFoodOrAlcohol() && this.eatingSpeed < 1.0f) {
            this.eatingSpeed = 1.0f;
        }
        this.eatingSpeed *= 0.9f;
        this.eatingProgress += this.eatingSpeed * 1.5f;
    }

    protected void tickEatingItem() {
        if (this.getEatingTime() != -1 && this.getEatingTime() < 40 && this.method_29507() > 0) {
            this.setLastPlayer(null);
            this.handleEndsFeed(this.getLastPlayer(), this.method_5998(class_1268.field_5810));
            this.setEatingTime(-1);
        }
        if (this.getEatingTime() < 40 && this.getEatingTime() != -1) {
            class_1799 foodStack = this.method_5998(class_1268.field_5810);
            this.addEatingTime();
            if (foodStack.method_7976() == class_1839.field_8946 && this.getEatingTime() % 5 == 0) {
                this.method_5783(this.method_18807(foodStack), 0.5f, this.method_37908().field_9229.method_43057() * 0.1f + 0.9f);
            }
            if (foodStack.method_7976() == class_1839.field_8950 && this.getEatingTime() % 5 == 0) {
                this.spawnItemParticles(foodStack);
                this.method_5783(this.method_18869(foodStack), 0.5f + 0.5f * (float)this.field_5974.method_43048(2), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            }
        } else if (this.getEatingTime() == 40) {
            this.handleEndsFeed(this.getLastPlayer(), this.method_5998(class_1268.field_5810));
        }
    }

    private void handleEndsFeed(class_1657 player, class_1799 foodStack) {
        if (!this.method_37908().field_9236) {
            if (foodStack.method_7976() == class_1839.field_8946) {
                if (player != null) {
                    ((class_3218)this.method_37908()).method_19496(this.getAlcoholInteraction(false), (class_1297)player, (class_4094)this);
                    this.handleNearTrollsInteraction(this.getAlcoholInteraction(true), player);
                    this.method_5971();
                }
                class_1799 dropStack = foodStack.method_7909() == class_1802.field_20417 || foodStack.method_7909() instanceof class_1812 || foodStack.method_7909() instanceof HerbalMixture ? new class_1799((class_1935)class_1802.field_8469) : (foodStack.method_7909() == class_1802.field_8103 ? new class_1799((class_1935)class_1802.field_8550) : class_1799.field_8037);
                foodStack.method_7910(this.method_37908(), (class_1309)this);
                this.method_5775(dropStack);
            }
            if (foodStack.method_7976() == class_1839.field_8950) {
                if (player != null) {
                    ((class_3218)this.method_37908()).method_19496(this.getFeedInteraction(false), (class_1297)player, (class_4094)this);
                    this.handleNearTrollsInteraction(this.getFeedInteraction(true), player);
                    this.method_5971();
                }
                if (foodStack.method_57826(class_9334.field_50075)) {
                    this.method_6025(Objects.requireNonNull((class_4174)foodStack.method_57824(class_9334.field_50075)).comp_2491());
                }
                this.method_5775(foodStack.method_7909() == class_1802.field_8308 ? new class_1799((class_1935)class_1802.field_8428) : class_1799.field_8037);
            }
            this.method_37908().method_8421((class_1297)this, (byte)(player != null && this.getFriendship(player) > this.getMinFriendshipToBeFollower() ? 12 : 14));
            this.method_6122(class_1268.field_5810, class_1799.field_8037);
            this.setEatingTime(-1);
        }
    }

    protected void spawnItemParticles(class_1799 stack) {
        for (int i = 0; i < 5; ++i) {
            class_243 vec3dVelocity = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
            class_243 vec3dPos = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, (double)(-this.field_5974.method_43057()) * 0.01, 1.2 + ((double)this.field_5974.method_43057() - 0.5) * 0.1).method_1024(-this.field_6283 * ((float)Math.PI / 180)).method_1031(this.method_23317(), this.method_23318(), this.method_23321());
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, stack), vec3dPos.field_1352, vec3dPos.field_1351, vec3dPos.field_1350, vec3dVelocity.field_1352, vec3dVelocity.field_1351 + 0.05, vec3dVelocity.field_1350);
        }
    }

    protected boolean hasFoodOrAlcohol() {
        return this.isEdible(this.method_5998(class_1268.field_5810)) || this.isDrinkable(this.method_5998(class_1268.field_5810).method_7909());
    }

    protected boolean isEdible(class_1799 itemStack) {
        return itemStack.method_57826(class_9334.field_50075) && itemStack.method_31573(class_3489.field_49932) || itemStack.method_31574(class_1802.field_8308);
    }

    protected boolean isDrinkable(class_1792 item) {
        return item instanceof class_1812 && !(item instanceof class_1828) && !(item instanceof class_1803) && !(item instanceof WitcherPotions_Base) && !this.isWandering() || item == class_1802.field_20417 || item == class_1802.field_8103 || this.isAlcohol(item);
    }

    protected boolean isAlcohol(class_1792 item) {
        return item instanceof WitcherAlcohol_Base;
    }

    public void method_5773() {
        super.method_5773();
        this.decayGossip();
        this.tickAdmiringItem();
        this.tickEatingItem();
        if (!this.method_37908().field_9236 && !this.method_6510() && this.field_6012 % 600 == 0) {
            for (AbstractTrollEntity troll : this.getNearTrolls()) {
                this.getGossip().shareGossipsWith(this, troll);
            }
        }
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        this.method_29517(nbt);
        nbt.method_10566("Gossips", (class_2520)this.getGossip().serialize(class_2509.field_11560));
        nbt.method_10544("LastGossipDecay", this.lastGossipDecayTime);
        nbt.method_10556("IsRabid", this.isRabid());
        nbt.method_10569("AdmiringTime", this.admiringTime);
        nbt.method_10569("EatingTime", this.getEatingTime());
        if (this.lastPlayerUuid != null) {
            nbt.method_25927("LastPlayer", this.lastPlayerUuid);
        }
        if (this.ownerUuid != null) {
            nbt.method_25927("Owner", this.ownerUuid);
        }
        nbt.method_10569("FollowerState", this.getFollowerState());
        nbt.method_10569("GuardPosX", this.getGuardingPos().method_10263());
        nbt.method_10569("GuardPosY", this.getGuardingPos().method_10264());
        nbt.method_10569("GuardPosZ", this.getGuardingPos().method_10260());
        nbt.method_10556("Blocking", this.isTrollBlocking());
        nbt.method_10569("TimeBlocking", this.getTimeBlocking());
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        this.method_29512(this.method_37908(), nbt);
        class_2499 nbtList = nbt.method_10554("Gossips", 10);
        this.getGossip().deserialize(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbtList));
        this.lastGossipDecayTime = nbt.method_10537("LastGossipDecay");
        this.setIsRabid(nbt.method_10577("IsRabid"));
        this.admiringTime = nbt.method_10550("AdmiringTime");
        this.setEatingTime(nbt.method_10550("EatingTime"));
        if (nbt.method_25928("LastPlayer")) {
            this.lastPlayerUuid = nbt.method_25926("LastPlayer");
        }
        if (nbt.method_25928("Owner")) {
            this.ownerUuid = nbt.method_25926("Owner");
        }
        this.setFollowerState(nbt.method_10550("FollowerState"));
        int x = nbt.method_10550("GuardPosX");
        int y = nbt.method_10550("GuardPosY");
        int z = nbt.method_10550("GuardPosZ");
        this.setGuardingPos(new class_2338(x, y, z));
        this.setIsTrollBlocking(nbt.method_10577("Blocking"));
        this.setTimeBlocking(nbt.method_10550("TimeBlocking"));
    }

    public void setIsTrollBlocking(boolean isBlocking) {
        this.field_6011.method_12778(BLOCKING, (Object)isBlocking);
        if (!isBlocking) {
            this.triggerAnim("BlockController", "unblock");
        }
    }

    public boolean isTrollBlocking() {
        return (Boolean)this.field_6011.method_12789(BLOCKING);
    }

    public void setTimeBlocking(int timeBlocking) {
        this.field_6011.method_12778(TIME_BLOCKING, (Object)timeBlocking);
    }

    public int getTimeBlocking() {
        return (Integer)this.field_6011.method_12789(TIME_BLOCKING);
    }

    public boolean method_5679(@NotNull class_1282 damageSource) {
        return this.isTrollBlocking() && !damageSource.method_48789(class_8103.field_43116) && !damageSource.method_48789(class_8103.field_42241) && (!(damageSource.method_5526() instanceof class_1665) || ((class_1665)damageSource.method_5526()).method_7447() <= 0) && !(this instanceof ForestTrollEntity) || super.method_5679(damageSource);
    }

    public boolean method_5810() {
        return super.method_5810() && !this.isTrollBlocking() && !this.isWaiting();
    }

    public boolean method_30948() {
        return this.isTrollBlocking() && this.method_5805();
    }

    protected boolean method_23734() {
        return !this.method_5947();
    }

    @Override
    protected class_3414 getAttackSound() {
        return TCOTS_Sounds.getSoundEvent("troll_attack");
    }

    protected class_3414 method_5994() {
        return this.method_6510() ? TCOTS_Sounds.getSoundEvent("troll_furious") : (this.isRabid() ? TCOTS_Sounds.getSoundEvent("troll_idle") : TCOTS_Sounds.getSoundEvent("troll_grunt"));
    }

    @NotNull
    protected class_3414 method_6002() {
        return TCOTS_Sounds.getSoundEvent("troll_death");
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 source) {
        return TCOTS_Sounds.getSoundEvent("troll_hurt");
    }

    public int method_5970() {
        return 120;
    }

    protected static class ReturnToGuardPosition
    extends class_1352 {
        private final AbstractTrollEntity troll;
        private final double speed;

        public ReturnToGuardPosition(AbstractTrollEntity troll, double speed) {
            this.troll = troll;
            this.speed = speed;
        }

        public boolean method_6264() {
            return this.troll.isWaiting() && this.troll.method_5968() == null && !this.troll.isTrollBlocking() && this.troll.method_23312() != this.troll.getGuardingPos() && this.searchItemsList().isEmpty() && !this.troll.hasFoodOrAlcohol() && !this.troll.hasBarteringItem();
        }

        public void method_6269() {
            this.startMovingTo(this.troll.method_5942(), this.troll.getGuardingPos().method_10263(), this.troll.getGuardingPos().method_10264(), this.troll.getGuardingPos().method_10260(), this.speed);
        }

        public void method_6268() {
            this.startMovingTo(this.troll.method_5942(), this.troll.getGuardingPos().method_10263(), this.troll.getGuardingPos().method_10264(), this.troll.getGuardingPos().method_10260(), this.speed);
        }

        private List<class_1542> searchItemsList() {
            return this.troll.method_37908().method_8390(class_1542.class, this.troll.method_5829().method_1009(8.0, 2.0, 8.0), item -> !item.method_6977() && item.method_5805() && (item.method_6983().method_7909() == this.troll.getBarteringItem() && this.troll.isWandering() || this.troll.isEdible(item.method_6983()) || this.troll.isAlcohol(item.method_6983().method_7909())));
        }

        public void startMovingTo(class_1408 navigation, int x, int y, int z, double speed) {
            navigation.method_6334(navigation.method_6352((double)x, (double)y, (double)z, 0), speed);
        }
    }

    protected static class TrollFollowFriendGoal
    extends class_1352 {
        private final AbstractTrollEntity troll;
        private class_1309 owner;
        private final class_4538 world;
        private final double speed;
        private final class_1408 navigation;
        private int updateCountdownTicks;
        private final float maxDistance;
        private final float minDistance;
        private float oldWaterPathfindingPenalty;
        private final boolean leavesAllowed;

        public TrollFollowFriendGoal(AbstractTrollEntity troll, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
            this.troll = troll;
            this.world = troll.method_37908();
            this.speed = speed;
            this.navigation = troll.method_5942();
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.leavesAllowed = leavesAllowed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            if (!(troll.method_5942() instanceof class_1409) && !(troll.method_5942() instanceof class_1407)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean method_6264() {
            class_1309 livingEntity = (class_1309)this.troll.method_24921();
            if (livingEntity == null) {
                return false;
            }
            if (livingEntity.method_7325()) {
                return false;
            }
            if (this.cannotFollow()) {
                return false;
            }
            if (this.troll.method_5858((class_1297)livingEntity) < (double)(this.minDistance * this.minDistance)) {
                return false;
            }
            this.owner = livingEntity;
            return true;
        }

        public boolean method_6266() {
            if (this.navigation.method_6357()) {
                return false;
            }
            if (this.cannotFollow()) {
                return false;
            }
            return !(this.troll.method_5858((class_1297)this.owner) <= (double)(this.maxDistance * this.maxDistance));
        }

        private boolean cannotFollow() {
            return this.troll.isWaiting() || this.troll.method_5765() || this.troll.method_60953();
        }

        public void method_6269() {
            this.updateCountdownTicks = 0;
            this.oldWaterPathfindingPenalty = this.troll.method_5944(class_7.field_18);
            this.troll.method_5941(class_7.field_18, 0.0f);
        }

        public void method_6270() {
            this.owner = null;
            this.navigation.method_6340();
            this.troll.method_5941(class_7.field_18, this.oldWaterPathfindingPenalty);
        }

        public void method_6268() {
            this.troll.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.troll.method_5978());
            if (--this.updateCountdownTicks > 0) {
                return;
            }
            this.updateCountdownTicks = this.method_38847(10);
            if (this.troll.method_5858((class_1297)this.owner) >= 324.0) {
                this.tryTeleport();
            } else {
                this.navigation.method_6335((class_1297)this.owner, this.speed);
            }
        }

        private void tryTeleport() {
            class_2338 blockPos = this.owner.method_24515();
            for (int i = 0; i < 10; ++i) {
                int j = this.getRandomInt(-3, 3);
                int k = this.getRandomInt(-1, 1);
                int l = this.getRandomInt(-3, 3);
                boolean bl = this.tryTeleportTo(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l);
                if (!bl) continue;
                return;
            }
        }

        private boolean tryTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new class_2338(x, y, z))) {
                return false;
            }
            this.troll.method_5808((double)x + 0.5, y, (double)z + 0.5, this.troll.method_36454(), this.troll.method_36455());
            this.navigation.method_6340();
            return true;
        }

        private boolean canTeleportTo(class_2338 pos) {
            class_7 pathNodeType = class_14.method_57625((class_1308)this.troll, (class_2338)pos.method_25503());
            if (pathNodeType != class_7.field_12) {
                return false;
            }
            class_2680 blockState = this.world.method_8320(pos.method_10074());
            if (!this.leavesAllowed && blockState.method_26204() instanceof class_2397) {
                return false;
            }
            class_2338 blockPos = pos.method_10059((class_2382)this.troll.method_24515());
            return this.world.method_8587((class_1297)this.troll, this.troll.method_5829().method_996(blockPos));
        }

        private int getRandomInt(int min, int max) {
            return this.troll.method_59922().method_43048(max - min + 1) + min;
        }
    }

    protected static class GoForItemInGroundGoal
    extends class_1352 {
        private final AbstractTrollEntity troll;
        private final double speed;

        public GoForItemInGroundGoal(AbstractTrollEntity troll, double speed) {
            this.troll = troll;
            this.speed = speed;
        }

        public boolean method_6264() {
            List<class_1542> list = this.searchItemsList();
            return !list.isEmpty() && this.troll.canGather();
        }

        public boolean method_6266() {
            List<class_1542> list = this.searchItemsList();
            return !list.isEmpty() && this.troll.canGather();
        }

        public void method_6269() {
            List<class_1542> list = this.searchItemsList();
            if (!list.isEmpty() && this.troll.canGather()) {
                this.troll.method_5942().method_6335((class_1297)list.get(0), this.speed);
            }
        }

        public void method_6268() {
            List<class_1542> list = this.searchItemsList();
            if (!list.isEmpty() && this.troll.canGather()) {
                this.startMovingTo(this.troll.method_5942(), (class_1297)list.get(0), this.speed);
                this.troll.method_5988().method_6226((class_1297)list.get(0), 30.0f, 30.0f);
            }
        }

        public void startMovingTo(class_1408 navigation, class_1297 entity, double speed) {
            class_11 path = navigation.method_6349(entity, 0);
            if (path != null) {
                navigation.method_6334(path, speed);
            }
        }

        private List<class_1542> searchItemsList() {
            return this.troll.method_37908().method_8390(class_1542.class, this.troll.method_5829().method_1009(8.0, 2.0, 8.0), item -> !item.method_6977() && item.method_5805() && (item.method_6983().method_7909() == this.troll.getBarteringItem() && this.troll.isWandering() || this.troll.isEdible(item.method_6983()) || this.troll.isAlcohol(item.method_6983().method_7909())));
        }
    }

    protected static class LookAtItemInHand
    extends class_1352 {
        private final AbstractTrollEntity troll;

        public LookAtItemInHand(AbstractTrollEntity troll) {
            this.troll = troll;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return this.troll.hasBarteringItem() || this.troll.hasFoodOrAlcohol();
        }

        public void method_6269() {
            this.troll.method_5942().method_6340();
            super.method_6269();
        }
    }

    protected static class DefendFriendGoal
    extends class_1400<class_1309> {
        @Nullable
        private class_1309 offender;
        @Nullable
        private class_1309 friend;
        private int lastAttackedTime;
        private final AbstractTrollEntity troll;

        public DefendFriendGoal(AbstractTrollEntity troll, Class<class_1309> targetEntityClass, boolean checkVisibility, boolean checkCanNavigate, Predicate<class_1309> targetPredicate) {
            super((class_1308)troll, targetEntityClass, 10, checkVisibility, checkCanNavigate, targetPredicate);
            this.troll = troll;
        }

        public boolean method_6264() {
            if (this.field_6641 > 0 && this.field_6660.method_59922().method_43048(this.field_6641) != 0) {
                return false;
            }
            Iterator iterator = this.troll.method_37908().method_8390(class_1657.class, this.troll.method_5829().method_1009(10.0, 5.0, 10.0), player -> this.troll.getReputation((class_1657)player) > 100 || this.troll.getFriendship((class_1657)player) > 80).iterator();
            if (iterator.hasNext()) {
                class_1657 player2;
                class_1657 livingEntity = player2 = (class_1657)iterator.next();
                this.friend = livingEntity;
                this.offender = livingEntity.method_6065();
                return livingEntity.method_6117() != this.lastAttackedTime && this.method_6328(this.offender, this.field_6642);
            }
            return false;
        }

        public void method_6269() {
            this.method_24632(this.offender);
            this.field_6644 = this.offender;
            if (this.friend != null) {
                this.lastAttackedTime = this.friend.method_6117();
            }
            super.method_6269();
        }
    }

    protected static class TrollRevengeGoal
    extends class_1405 {
        private static final class_4051 VALID_AVOIDABLE_PREDICATE = class_4051.method_36625().method_36627().method_18424();
        private static final int BOX_VERTICAL_EXPANSION = 10;
        private boolean groupRevenge;
        private int lastAttackedTime;
        private final Class<?>[] noRevengeTypes;
        @Nullable
        private Class<?>[] noHelpTypes;

        public TrollRevengeGoal(class_1314 mob, Class<?> ... noRevengeTypes) {
            super((class_1308)mob, true);
            this.noRevengeTypes = noRevengeTypes;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            int i = this.field_6660.method_6117();
            class_1309 livingEntity = this.field_6660.method_6065();
            if (i == this.lastAttackedTime || livingEntity == null) {
                return false;
            }
            if (livingEntity.method_5864() == class_1299.field_6097 && this.field_6660.method_37908().method_8450().method_8355(class_1928.field_25402)) {
                return false;
            }
            for (Class<?> class_ : this.noRevengeTypes) {
                if (!class_.isAssignableFrom(livingEntity.getClass())) continue;
                return false;
            }
            return this.method_6328(livingEntity, VALID_AVOIDABLE_PREDICATE);
        }

        public TrollRevengeGoal setGroupRevenge(Class<?> ... noHelpTypes) {
            this.groupRevenge = true;
            this.noHelpTypes = noHelpTypes;
            return this;
        }

        public void method_6269() {
            this.field_6660.method_5980(this.field_6660.method_6065());
            this.field_6664 = this.field_6660.method_5968();
            this.lastAttackedTime = this.field_6660.method_6117();
            this.field_6657 = 300;
            if (this.groupRevenge) {
                this.callSameTypeForRevenge();
            }
            super.method_6269();
        }

        protected void callSameTypeForRevenge() {
            double d = this.method_6326();
            class_238 box = class_238.method_29968((class_243)this.field_6660.method_19538()).method_1009(d, 10.0, d);
            List list = this.field_6660.method_37908().method_8390(AbstractTrollEntity.class, box, troll -> this.field_6660.method_5864() == troll.method_5864());
            for (AbstractTrollEntity otherTroll : list) {
                AbstractTrollEntity troll2;
                Class<?>[] classArray;
                if (this.field_6660 == otherTroll || otherTroll.method_5968() != null || this.field_6660 instanceof class_1321 && ((class_1321)this.field_6660).method_35057() != otherTroll.method_24921() || otherTroll.method_5722((class_1297)this.field_6660.method_6065()) || otherTroll.isRabid() && (classArray = this.field_6660) instanceof AbstractTrollEntity && !(troll2 = (AbstractTrollEntity)classArray).isRabid() || (classArray = this.field_6660) instanceof AbstractTrollEntity && (troll2 = (AbstractTrollEntity)classArray).isRabid() && !otherTroll.isRabid()) continue;
                if (this.noHelpTypes != null) {
                    boolean bl = false;
                    classArray = this.noHelpTypes;
                    int n = classArray.length;
                    for (int i = 0; i < n; ++i) {
                        Class<?> class_ = classArray[i];
                        if (((Object)((Object)otherTroll)).getClass() != class_) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                }
                this.setMobEntityTarget((class_1308)otherTroll, this.field_6660.method_6065());
            }
        }

        protected void setMobEntityTarget(class_1308 mob, class_1309 target) {
            mob.method_5980(target);
        }
    }

    protected static class TrollTargetWithReputationGoal
    extends class_1405 {
        private final AbstractTrollEntity troll;
        @Nullable
        private class_1309 target;
        private final class_4051 targetPredicate = class_4051.method_36625().method_18418(64.0);

        public TrollTargetWithReputationGoal(AbstractTrollEntity troll) {
            super((class_1308)troll, false, true);
            this.troll = troll;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            class_238 box = this.troll.method_5829().method_1009(10.0, 8.0, 10.0);
            this.field_6664 = null;
            List listTrolls = this.troll.method_37908().method_18466(AbstractTrollEntity.class, this.targetPredicate, (class_1309)this.troll, box);
            List listPlayers = this.troll.method_37908().method_18464(this.targetPredicate, (class_1309)this.troll, box);
            listTrolls.add(this.troll);
            for (AbstractTrollEntity trollAround : listTrolls) {
                if (trollAround.isRabid()) continue;
                for (class_1657 playerEntity : listPlayers) {
                    int reputation = trollAround.getReputation(playerEntity);
                    if (reputation <= -75 && (playerEntity.method_6047().method_7909() instanceof class_1829 || playerEntity.method_6047().method_7909() instanceof class_1743)) {
                        this.field_6664 = playerEntity;
                    }
                    if (reputation > -100) continue;
                    this.field_6664 = playerEntity;
                }
            }
            if (this.field_6664 == null) {
                return false;
            }
            return !(this.field_6664 instanceof class_1657) || !this.field_6664.method_7325() && !((class_1657)this.field_6664).method_7337();
        }

        public void method_6269() {
            this.troll.method_5980(this.field_6664);
            super.method_6269();
        }
    }

    protected static class TrollUniversalAngerGoal<T extends AbstractTrollEntity>
    extends class_1352 {
        private static final int BOX_VERTICAL_EXPANSION = 10;
        private final T troll;
        private final boolean triggerOthers;
        private int lastAttackedTime;

        public TrollUniversalAngerGoal(T troll, boolean triggerOthers) {
            this.troll = troll;
            this.triggerOthers = triggerOthers;
        }

        public boolean method_6264() {
            return this.troll.method_37908().method_8450().method_8355(class_1928.field_25402) && this.canStartUniversalAnger();
        }

        private boolean canStartUniversalAnger() {
            return this.troll.method_6065() != null && this.troll.method_6065().method_5864() == class_1299.field_6097 && this.troll.method_6117() > this.lastAttackedTime;
        }

        public void method_6269() {
            this.lastAttackedTime = this.troll.method_6117();
            this.troll.method_29921();
            if (this.triggerOthers) {
                this.getOthersInRange().stream().filter(entity -> entity != this.troll).map(entity -> entity).forEach(class_5354::method_29921);
            }
        }

        private List<? extends AbstractTrollEntity> getOthersInRange() {
            double d = this.troll.method_45325(class_5134.field_23717);
            class_238 box = class_238.method_29968((class_243)this.troll.method_19538()).method_1009(d, 10.0, d);
            if (((AbstractTrollEntity)((Object)this.troll)).isRabid()) {
                return this.troll.method_37908().method_8390(AbstractTrollEntity.class, box, class_1301.field_6155.and(entity -> ((AbstractTrollEntity)((Object)entity)).isRabid()).and(entity -> entity.method_5864() == this.troll.method_5864()));
            }
            return this.troll.method_37908().method_8390(AbstractTrollEntity.class, box, class_1301.field_6155.and(entity -> entity.method_5864() == this.troll.method_5864()));
        }
    }

    protected static class LookAtPlayerWithWeaponGoal
    extends class_1361 {
        private final AbstractTrollEntity troll;

        public LookAtPlayerWithWeaponGoal(AbstractTrollEntity troll, Class<? extends class_1657> targetType, float range) {
            this(troll, targetType, range, 1.0f);
        }

        public LookAtPlayerWithWeaponGoal(AbstractTrollEntity troll, Class<? extends class_1657> targetType, float range, float chance) {
            this(troll, targetType, range, chance, false);
        }

        public LookAtPlayerWithWeaponGoal(AbstractTrollEntity troll, Class<? extends class_1657> targetType, float range, float chance, boolean lookForward) {
            super((class_1308)troll, targetType, range, chance, lookForward);
            this.troll = troll;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.troll.method_5968() != null) {
                this.field_6484 = this.troll.method_5968();
            }
            this.field_6484 = this.troll.method_37908().method_18463(class_4051.method_36626().method_18418((double)this.field_6482).method_18420(player -> this.troll.getReputation((class_1657)player) < 25 && (player.method_6047().method_7909() instanceof class_1829 || player.method_6047().method_7909() instanceof class_1743)), (class_1309)this.troll, this.troll.method_23317(), this.troll.method_23320(), this.troll.method_23321());
            return this.field_6484 != null && !this.troll.hasBarteringItem() && !this.troll.method_6039() && !this.troll.hasFoodOrAlcohol() && this.troll.isWandering();
        }
    }

    protected static class LookAtEntityGoal_Troll
    extends class_1361 {
        private final AbstractTrollEntity troll;

        public LookAtEntityGoal_Troll(AbstractTrollEntity mob, Class<? extends class_1309> targetType, float range) {
            super((class_1308)mob, targetType, range);
            this.troll = mob;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.troll.hasBarteringItem() && !this.troll.hasFoodOrAlcohol() && !this.troll.isTrollBlocking();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.troll.hasBarteringItem() && !this.troll.hasFoodOrAlcohol() && !this.troll.isTrollBlocking();
        }
    }

    protected static class LookAroundGoal_Troll
    extends class_1376 {
        private final AbstractTrollEntity troll;

        public LookAroundGoal_Troll(AbstractTrollEntity mob) {
            super((class_1308)mob);
            this.troll = mob;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.troll.hasBarteringItem() && !this.troll.hasFoodOrAlcohol() && !this.troll.isTrollBlocking();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.troll.hasBarteringItem() && !this.troll.hasFoodOrAlcohol() && !this.troll.isTrollBlocking();
        }
    }

    protected static class WanderAroundGoal_Troll
    extends class_1379 {
        private final AbstractTrollEntity troll;

        public WanderAroundGoal_Troll(AbstractTrollEntity mob, double speed, int chance) {
            super((class_1314)mob, speed, chance);
            this.troll = mob;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.troll.hasBarteringItem() && !this.troll.hasFoodOrAlcohol() && this.troll.isWandering() && !this.troll.isTrollBlocking();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.troll.hasBarteringItem() && !this.troll.hasFoodOrAlcohol() && this.troll.isWandering() && !this.troll.isTrollBlocking();
        }
    }

    protected static class ProjectileAttackGoal_RockTroll
    extends class_1381 {
        private final RockTrollEntity troll;
        private final float distanceForAttack;

        public ProjectileAttackGoal_RockTroll(RockTrollEntity mob, double mobSpeed, int intervalTicks, float maxShootRange, float distanceForAttack) {
            super((class_1603)mob, mobSpeed, intervalTicks, maxShootRange);
            this.troll = mob;
            this.distanceForAttack = distanceForAttack;
        }

        private boolean distanceCondition() {
            if (this.troll.method_5968() != null) {
                class_1309 target = this.troll.method_5968();
                double d = this.troll.method_5858((class_1297)target);
                return !(d < (double)this.distanceForAttack);
            }
            return true;
        }

        public boolean method_6264() {
            return super.method_6264() && this.distanceCondition() && !this.troll.isTrollBlocking();
        }

        public boolean method_6266() {
            return super.method_6266() && this.distanceCondition();
        }
    }

    protected static class MeleeAttackGoal_Troll
    extends MeleeAttackGoal_Animated {
        private final AbstractTrollEntity troll;

        public MeleeAttackGoal_Troll(AbstractTrollEntity mob, double speed, boolean pauseWhenMobIdle) {
            super((class_1314)mob, speed, pauseWhenMobIdle, 2);
            this.troll = mob;
        }

        @Override
        public boolean method_6264() {
            return super.method_6264() && !this.troll.isTrollBlocking();
        }

        @Override
        public boolean method_6266() {
            return super.method_6266() && !this.troll.isTrollBlocking();
        }
    }
}

