/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.ogroids;

import TCOTS.TCOTS_Tags;
import TCOTS.entity.goals.MeleeAttackGoal_Animated;
import TCOTS.entity.ogroids.OgroidMonster;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.EntitiesUtil;
import TCOTS.utils.GeoControllersUtil;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_3988;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CyclopsEntity
extends OgroidMonster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation JUMP = RawAnimation.begin().thenPlayAndHold("special.jumping");
    public static final RawAnimation LANDING = RawAnimation.begin().thenPlay("special.landing");
    protected static final class_2940<Boolean> FALLING = class_2945.method_12791(CyclopsEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Float> FALLING_DISTANCE = class_2945.method_12791(CyclopsEntity.class, (class_2941)class_2943.field_13320);
    private static final byte FALLING_PARTICLES = 42;
    public boolean cooldownBetweenJumps = false;
    private int jumpTicks;

    public CyclopsEntity(class_1299<? extends CyclopsEntity> entityType, class_1937 world) {
        super((class_1299<? extends OgroidMonster>)entityType, world);
        this.field_6194 = 10;
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FALLING, (Object)Boolean.FALSE);
        builder.method_56912(FALLING_DISTANCE, (Object)Float.valueOf(this.field_6017));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_47761, 1.5).method_26868(class_5134.field_23716, 45.0).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23719, (double)0.22f).method_26868(class_5134.field_23722, 2.0).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23718, (double)0.8f).method_26868(class_5134.field_23725, 2.0).method_26868(class_5134.field_23717, 35.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new CyclopsJumpAttack(this, 200, 100));
        this.field_6201.method_6277(2, (class_1352)new CyclopsMeleeAttackGoal((class_1314)this, 1.2, false));
        this.field_6201.method_6277(3, (class_1352)new class_1379((class_1314)this, 0.75, 20));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    protected float method_6106() {
        return 0.7f * this.method_23313() + this.method_37416();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "Idle/Walk", 5, GeoControllersUtil::idleWalkRunController));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "AttackController", 1, state -> PlayState.STOP).triggerableAnim("attack1", GeoControllersUtil.ATTACK1).triggerableAnim("attack2", GeoControllersUtil.ATTACK2));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "JumpController", 1, state -> {
            if (this.isFalling()) {
                state.setAnimation(JUMP);
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "LandingController", 1, state -> PlayState.STOP).triggerableAnim("landing", LANDING));
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("JumpCooldown", this.jumpTicks);
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        this.jumpTicks = nbt.method_10550("JumpCooldown");
    }

    public void method_5773() {
        super.method_5773();
        this.setFallingDistance(this.field_6017);
        this.tickJump();
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return super.method_23329(fallDistance, damageMultiplier) - 4;
    }

    public void method_6043() {
        this.method_5783(TCOTS_Sounds.getSoundEvent("cyclops_attack"), 1.0f, 1.0f);
        super.method_6043();
    }

    public void method_38785() {
        if (this.isFalling()) {
            this.setIsFalling(false);
            if (this.method_37908().method_8320(this.method_24515().method_10074()).method_26227().method_39360(class_3612.field_15906) && !this.method_37908().method_8320(this.method_24515()).method_26164(TCOTS_Tags.NEGATES_DEVOURER_JUMP) && !this.method_37908().method_8320(this.method_24515().method_10074()).method_26164(TCOTS_Tags.NEGATES_DEVOURER_JUMP)) {
                this.triggerAnim("LandingController", "landing");
                EntitiesUtil.pushAndDamageEntities((class_1308)this, 6.0f + this.field_6017 * 2.0f, (double)(3.0f + this.field_6017 * 0.5f), 3.0, 3.0, new Class[0]);
                this.method_5783(TCOTS_Sounds.getSoundEvent("medium_impact"), 1.0f, 1.0f);
                this.method_37908().method_8421((class_1297)this, (byte)42);
            }
        }
        super.method_38785();
    }

    public void method_5711(byte status) {
        if (status == 42) {
            EntitiesUtil.spawnImpactParticles((class_1297)this, (double)1.9975f + ((double)2.8f + this.getFallingDistance() * 0.5), this.getFallingDistance());
        } else {
            super.method_5711(status);
        }
    }

    private void tickJump() {
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        } else {
            this.cooldownBetweenJumps = false;
        }
    }

    public void setIsFalling(boolean isFalling) {
        this.field_6011.method_12778(FALLING, (Object)isFalling);
    }

    public boolean isFalling() {
        return (Boolean)this.field_6011.method_12789(FALLING);
    }

    public void setFallingDistance(float fallingDistance) {
        this.field_6011.method_12778(FALLING_DISTANCE, (Object)Float.valueOf(fallingDistance));
    }

    public double getFallingDistance() {
        return ((Float)this.field_6011.method_12789(FALLING_DISTANCE)).floatValue();
    }

    public boolean method_5679(@NotNull class_1282 damageSource) {
        return super.method_5679(damageSource) || this.isFalling();
    }

    @Nullable
    protected class_3414 method_5994() {
        return TCOTS_Sounds.getSoundEvent("cyclops_idle");
    }

    @Override
    protected class_3414 getAttackSound() {
        return TCOTS_Sounds.getSoundEvent("cyclops_attack");
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 source) {
        return TCOTS_Sounds.getSoundEvent("cyclops_hurt");
    }

    @Nullable
    protected class_3414 method_6002() {
        return TCOTS_Sounds.getSoundEvent("cyclops_death");
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static boolean canCyclopsSpawn(class_1299<? extends class_1308> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_2338 blockPos = pos.method_10074();
        int radiusToSearchCyclops = 80;
        return spawnReason == class_3730.field_16469 || world.method_8320(blockPos).method_26170((class_1922)world, blockPos, type) && pos.method_10264() < world.method_8615() - 20 && world.method_8390(CyclopsEntity.class, new class_238((double)(pos.method_10263() - radiusToSearchCyclops), (double)(pos.method_10264() - radiusToSearchCyclops), (double)(pos.method_10260() - radiusToSearchCyclops), (double)(pos.method_10263() + radiusToSearchCyclops), (double)(pos.method_10264() + radiusToSearchCyclops), (double)(pos.method_10260() + radiusToSearchCyclops)), cyclopsEntity -> true).isEmpty();
    }

    private static class CyclopsJumpAttack
    extends class_1352 {
        private final CyclopsEntity cyclops;
        private final int minJumpCooldown;
        private final int maxJumpCooldown;

        public CyclopsJumpAttack(CyclopsEntity cyclops, int minJumpCooldown, int maxExtraRandomCooldown) {
            this.cyclops = cyclops;
            this.minJumpCooldown = minJumpCooldown;
            this.maxJumpCooldown = maxExtraRandomCooldown;
        }

        public boolean method_6264() {
            class_1309 target = this.cyclops.method_5968();
            if (target != null) {
                return !this.cyclops.cooldownBetweenJumps && this.cyclops.method_6510() && !this.cyclops.method_52535() && !this.cyclops.method_5765() && !this.cyclops.method_37908().method_8320(this.cyclops.method_24515()).method_27852(class_2246.field_21211) && !this.cyclops.method_37908().method_8320(this.cyclops.method_24515()).method_27852(class_2246.field_10343) && this.cyclops.method_5739((class_1297)target) < 6.0f && this.cyclops.method_5739((class_1297)target) > 2.0f;
            }
            return false;
        }

        public void method_6268() {
            class_1309 target = this.cyclops.method_5968();
            if (target != null) {
                this.jumpAttack();
            }
        }

        private void jumpAttack() {
            this.cyclops.method_6043();
            this.cyclops.setIsFalling(true);
            this.cyclops.cooldownBetweenJumps = true;
            this.cyclops.jumpTicks = this.minJumpCooldown + this.cyclops.field_5974.method_39332(0, this.maxJumpCooldown);
        }
    }

    private static class CyclopsMeleeAttackGoal
    extends MeleeAttackGoal_Animated {
        private final CyclopsEntity cyclops;

        public CyclopsMeleeAttackGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle, 2);
            this.cyclops = (CyclopsEntity)mob;
        }

        @Override
        public boolean method_6264() {
            return super.method_6264() && !this.cyclops.isFalling();
        }

        @Override
        public boolean method_6266() {
            return super.method_6266() && !this.cyclops.isFalling();
        }
    }
}

