/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.ogroids;

import TCOTS.TCOTS_Tags;
import TCOTS.entity.goals.MeleeAttackGoal_Animated;
import TCOTS.entity.goals.ReturnToNestGoal;
import TCOTS.entity.interfaces.GuardNestMob;
import TCOTS.entity.misc.AnchorProjectileEntity;
import TCOTS.entity.ogroids.OgroidMonster;
import TCOTS.registry.TCOTS_Blocks;
import TCOTS.registry.TCOTS_Effects;
import TCOTS.registry.TCOTS_Items;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.EntitiesUtil;
import TCOTS.utils.GeoControllersUtil;
import TCOTS.utils.MiscUtil;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_1528;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_3988;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5698;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_5716;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_8514;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IceGiantEntity
extends OgroidMonster
implements GeoEntity,
class_8514,
GuardNestMob {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final class_2940<Boolean> CHARGING = class_2945.method_12791(IceGiantEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2338> ANCHOR_POS = class_2945.method_12791(IceGiantEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(IceGiantEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> WAKING_UP = class_2945.method_12791(IceGiantEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2338> NEST_POS = class_2945.method_12791(IceGiantEntity.class, (class_2941)class_2943.field_13324);
    protected static final class_2940<Boolean> FALLING = class_2945.method_12791(IceGiantEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Float> FALLING_DISTANCE = class_2945.method_12791(IceGiantEntity.class, (class_2941)class_2943.field_13320);
    public static final RawAnimation WAKE_UP = RawAnimation.begin().thenPlayAndHold("sleeping.wake_up");
    public static final RawAnimation GO_TO_SLEEP = RawAnimation.begin().thenPlay("sleeping.go_to_sleep").thenLoop("sleeping.idle");
    public static final RawAnimation BIG_ATTACK = RawAnimation.begin().thenPlay("attack.big_swing");
    public static final RawAnimation ANCHOR_LAUNCH = RawAnimation.begin().thenPlay("attack.anchor_launch");
    public static final RawAnimation JUMP = RawAnimation.begin().thenPlayAndHold("special.jumping");
    public static final RawAnimation LANDING = RawAnimation.begin().thenPlay("special.landing");
    private final class_3213 bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795).method_5406(true);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final float healthToReachSecondPhase = this.method_6063() * 0.6f;
    private class_8514.class_8515 vibrationListenerData;
    private final class_8514.class_5719 vibrationCallback;
    private final class_5715<class_8514.class_8516> gameEventHandler;
    boolean listenToSound = false;
    int chargeCooldownTimer;
    boolean chargeCooldown = false;
    private int canSleepTimer;
    private boolean sleepCooldown;
    int anchorLaunchCooldownTimer;
    boolean anchorLaunchCooldown = false;
    private int retrieveAnchorTimer = 0;
    private static final class_1322 BLIZZARD_STRENGTH_BOOST = new class_1322(class_2960.method_60655((String)"tcots_witcher", (String)"giant_blizzard_strength_boost"), 4.0, class_1322.class_1323.field_6328);
    private static final class_1322 BLIZZARD_SPEED_BOOST = new class_1322(class_2960.method_60655((String)"tcots_witcher", (String)"giant_blizzard_speed_boost"), (double)0.1f, class_1322.class_1323.field_6330);
    private static final byte FALLING_PARTICLES = 42;
    public boolean cooldownBetweenJumps = false;
    private int jumpTicks;

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 world, @NotNull class_1266 difficulty, @NotNull class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (spawnReason != class_3730.field_16459 && spawnReason != class_3730.field_16465) {
            this.setNestPos(this.method_24515());
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public IceGiantEntity(class_1299<? extends OgroidMonster> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 25;
        this.vibrationCallback = new VibrationCallback(this);
        this.vibrationListenerData = new class_8514.class_8515();
        this.gameEventHandler = new class_5715((class_5714)new class_8514.class_8516((class_8514)this));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_47761, 1.5).method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23722, 3.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23725, 4.0).method_26868(class_5134.field_23718, (double)0.8f).method_26868(class_5134.field_23717, 40.0);
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CHARGING, (Object)Boolean.FALSE);
        builder.method_56912(SLEEPING, (Object)Boolean.FALSE);
        builder.method_56912(WAKING_UP, (Object)Boolean.FALSE);
        builder.method_56912(ANCHOR_POS, (Object)class_2338.field_10980);
        builder.method_56912(FALLING, (Object)Boolean.FALSE);
        builder.method_56912(FALLING_DISTANCE, (Object)Float.valueOf(this.field_6017));
        builder.method_56912(NEST_POS, (Object)class_2338.field_10980);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new WakeUpGoal(this, MiscUtil.getTimeInTicks(120)));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new GoForAnchor(this, 1.4));
        this.field_6201.method_6277(3, (class_1352)new GoToSleepGoal(this));
        this.field_6201.method_6277(4, (class_1352)new IceGiantJumpAttack(this, MiscUtil.getTimeInTicks(20), MiscUtil.getTimeInTicks(10)));
        this.field_6201.method_6277(5, (class_1352)new MeleeAttackGoal_IceGiant(this, 1.2, false, 1.4, MiscUtil.getTimeInTicks(12), MiscUtil.getTimeInTicks(120)));
        this.field_6201.method_6277(6, (class_1352)new ReturnToNestGoal((class_1314)this, 0.75, 400.0));
        this.field_6201.method_6277(7, (class_1352)new WanderAroundGoal_Giant(this, 0.75, 20));
        this.field_6201.method_6277(8, (class_1352)new LookAroundGoal_Giant(this));
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    @Override
    public class_2338 getNestPos() {
        return (class_2338)this.field_6011.method_12789(NEST_POS);
    }

    @Override
    public void setNestPos(class_2338 pos) {
        this.field_6011.method_12778(NEST_POS, (Object)pos);
    }

    @Override
    public boolean canHaveNest() {
        return true;
    }

    @Override
    public void setCanHaveNest(boolean canHaveNest) {
    }

    @Override
    public boolean getExtraReasonToNotGoToNest() {
        return !(this.isFalling() || this.isGiantSleeping() || this.getAnchorPos() != class_2338.field_10980 && this.method_6032() < this.healthToReachSecondPhase && !this.hasAnchor());
    }

    public void method_42147(@NotNull BiConsumer<class_5715<?>, class_3218> callback) {
        class_1937 world = this.method_37908();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            callback.accept(this.gameEventHandler, serverWorld);
        }
    }

    @NotNull
    public class_8514.class_8515 method_51298() {
        return this.vibrationListenerData;
    }

    @NotNull
    public class_8514.class_5719 method_51299() {
        return this.vibrationCallback;
    }

    private boolean hasAnchor() {
        if (TCOTS_Items.GIANT_ANCHOR == null) {
            return false;
        }
        return this.method_6047().method_31574((class_1792)TCOTS_Items.GIANT_ANCHOR.get());
    }

    private void launchAnchor() {
        if (this.hasAnchor()) {
            class_1799 stack = this.method_6047();
            AnchorProjectileEntity anchorProjectile = new AnchorProjectileEntity((class_1309)this, this.method_37908());
            anchorProjectile.setDamage(12.0);
            anchorProjectile.setEnchanted(stack.method_7958());
            anchorProjectile.method_24919((class_1297)this, this.method_36455(), this.method_36454(), 0.0f, 0.4f, 1.0f);
            this.triggerAnim("AttackController", "anchor_launch");
            this.method_37908().method_8649((class_1297)anchorProjectile);
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), TCOTS_Sounds.getSoundEvent("anchor_throw"), this.method_5634(), 1.0f, 1.0f);
            this.method_5783(this.getAttackSound(), 1.0f, 1.0f);
            stack.method_57379(TCOTS_Items.AnchorRetrieve(), (Object)true);
            this.anchorLaunchCooldownTimer = MiscUtil.getTimeInTicks(10);
            this.anchorLaunchCooldown = true;
            this.retrieveAnchorTimer = 0;
        }
    }

    private void retrieveAnchor() {
        AnchorProjectileEntity anchorProjectile = (AnchorProjectileEntity)((Object)this.theConjunctionOfTheSpheres$getAnchor());
        if (anchorProjectile != null && this.retrieveAnchorTimer == 30) {
            anchorProjectile.pickupType = class_1665.class_1666.field_7593;
            anchorProjectile.dealtDamage = true;
            anchorProjectile.method_33574(this.method_24515().method_46558());
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), TCOTS_Sounds.getSoundEvent("anchor_chain"), this.method_5634(), 1.0f, 1.0f);
            anchorProjectile.method_31472();
            class_1799 stack = this.method_6047();
            stack.method_57381(TCOTS_Items.AnchorRetrieve());
        }
    }

    public void setIsCharging(boolean isCharging) {
        this.field_6011.method_12778(CHARGING, (Object)isCharging);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(CHARGING);
    }

    public void setIsGiantSleeping(boolean isSleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)isSleeping);
    }

    public boolean isGiantSleeping() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setIsGiantWakingUp(boolean isSleeping) {
        this.field_6011.method_12778(WAKING_UP, (Object)isSleeping);
    }

    public boolean isGiantWakingUp() {
        return (Boolean)this.field_6011.method_12789(WAKING_UP);
    }

    public void setAnchorPos(class_2338 anchorPos) {
        this.field_6011.method_12778(ANCHOR_POS, (Object)anchorPos);
    }

    public class_2338 getAnchorPos() {
        return (class_2338)this.field_6011.method_12789(ANCHOR_POS);
    }

    public void setSleepCooldown(boolean cannotSleep) {
        this.sleepCooldown = cannotSleep;
    }

    public boolean getSleepCooldown() {
        return this.sleepCooldown;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "Idle/Walk", 5, state -> {
            if (!this.isGiantSleeping() && !this.isGiantWakingUp()) {
                return GeoControllersUtil.idleWalkRunController(state);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "AttackController", 1, state -> PlayState.STOP).triggerableAnim("attack1", GeoControllersUtil.ATTACK1).triggerableAnim("attack2", GeoControllersUtil.ATTACK2).triggerableAnim("big_attack", BIG_ATTACK).triggerableAnim("anchor_launch", ANCHOR_LAUNCH));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "SleepingController", 1, state -> {
            if (this.isGiantSleeping()) {
                state.setAnimation(GO_TO_SLEEP);
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "WakingUpController", 1, state -> {
            if (this.isGiantWakingUp()) {
                state.setAnimation(WAKE_UP);
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }).setParticleKeyframeHandler(event -> {
            class_2680 blockState = this.method_25936();
            if (blockState.method_26217() != class_2464.field_11455) {
                for (int i = 0; i < 32; ++i) {
                    class_243 vec3dVelocity = new class_243((double)this.field_5974.method_43057() * 0.3, 0.0, (double)this.field_5974.method_43057() * 0.3).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
                    class_243 vec3dPos = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.6, (double)(-this.field_5974.method_43057()) * 0.01, 1.6 + ((double)this.field_5974.method_43057() - 0.5) * 0.6).method_1024(-this.field_6283 * ((float)Math.PI / 180)).method_1031(this.method_23317(), this.method_23318(), this.method_23321());
                    this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), vec3dPos.field_1352, vec3dPos.field_1351, vec3dPos.field_1350, vec3dVelocity.field_1352, vec3dVelocity.field_1351 + 0.1, vec3dVelocity.field_1350);
                }
            }
        }).setSoundKeyframeHandler(event -> this.method_5783(TCOTS_Sounds.getSoundEvent("big_impact"), 1.0f, 1.0f)));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "JumpController", 1, state -> {
            if (this.isFalling()) {
                state.setAnimation(JUMP);
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "LandingController", 1, state -> PlayState.STOP).triggerableAnim("landing", LANDING));
    }

    private void tickCharge() {
        if (this.chargeCooldownTimer > 0) {
            --this.chargeCooldownTimer;
        } else if (this.chargeCooldown) {
            this.chargeCooldown = false;
        }
        if (this.isCharging()) {
            EntitiesUtil.spawnGroundParticles((class_1314)this);
        }
    }

    private void tickSleep() {
        if (this.canSleepTimer > 0) {
            --this.canSleepTimer;
        } else if (this.getSleepCooldown()) {
            this.setSleepCooldown(false);
        }
    }

    private void tickAnchorLaunch() {
        if (this.anchorLaunchCooldownTimer > 0) {
            --this.anchorLaunchCooldownTimer;
        } else if (this.anchorLaunchCooldown) {
            this.anchorLaunchCooldown = false;
        }
    }

    @NotNull
    public class_243 method_30951(float delta) {
        double d = 1.3 * (this.method_6068() == class_1306.field_6183 ? -1.0 : 1.0);
        float f = class_3532.method_16439((float)(delta * 0.5f), (float)this.method_36455(), (float)this.field_6004) * ((float)Math.PI / 180);
        float g = class_3532.method_16439((float)delta, (float)this.field_6220, (float)this.field_6283) * ((float)Math.PI / 180);
        if (this.method_6128() || this.method_6123()) {
            float k;
            class_243 vec3d = this.method_5828(delta);
            class_243 vec3d2 = this.method_18798();
            double e = vec3d2.method_37268();
            double h = vec3d.method_37268();
            if (e > 0.0 && h > 0.0) {
                double i = (vec3d2.field_1352 * vec3d.field_1352 + vec3d2.field_1350 * vec3d.field_1350) / Math.sqrt(e * h);
                double j = vec3d2.field_1352 * vec3d.field_1350 - vec3d2.field_1350 * vec3d.field_1352;
                k = (float)(Math.signum(j) * Math.acos(i));
            } else {
                k = 0.0f;
            }
            return this.method_30950(delta).method_1019(new class_243(d, -0.11, 0.85).method_31033(-k).method_1037(-f).method_1024(-g));
        }
        if (this.method_20232()) {
            return this.method_30950(delta).method_1019(new class_243(d, 0.2, -0.15).method_1037(-f).method_1024(-g));
        }
        double l = this.method_5829().method_17940() - 2.6;
        double e = this.method_18276() ? -0.2 : 0.07;
        return this.method_30950(delta).method_1019(new class_243(d, l, e).method_1024(-g));
    }

    @NotNull
    protected class_238 method_33332() {
        if (this.isGiantSleeping()) {
            return this.sleepingBox();
        }
        return super.method_33332();
    }

    @NotNull
    protected class_4048 method_55694(@NotNull class_4050 pose) {
        return this.isGiantSleeping() ? this.method_5864().method_18386().method_55685(1.6f) : super.method_55694(pose);
    }

    private class_238 sleepingBox() {
        return new class_238(this.method_23317() - 1.8, this.method_23318() + 2.6, this.method_23321() - 1.5, this.method_23317() + 1.8, this.method_23318(), this.method_23321() + 1.5);
    }

    public void method_5674(@NotNull class_2940<?> data) {
        super.method_5674(data);
        if (this.isGiantSleeping() || !this.isGiantSleeping()) {
            this.method_5857(this.method_33332());
            this.method_18382();
        }
    }

    private void tickFindAnchor() {
        if (this.getAnchorPos() == class_2338.field_10980 && !this.hasAnchor()) {
            Optional<class_2338> optional = this.findAnchor((class_1314)this);
            optional.ifPresent(this::setAnchorPos);
        }
        if (this.hasAnchor() || this.getAnchorPos() != class_2338.field_10980 && this.method_5707(this.getAnchorPos().method_46558()) > 250.0) {
            this.setAnchorPos(class_2338.field_10980);
        }
    }

    private Optional<class_2338> findAnchor(class_1314 entity) {
        double searchDistance = 20.0;
        Predicate<class_2338> predicate = pos -> entity.method_37908().method_8320(pos).method_27852(TCOTS_Blocks.GiantAnchor());
        class_2338 blockPos = entity.method_24515();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int i = 0;
        while ((double)i <= searchDistance) {
            int j = 0;
            while ((double)j < searchDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        mutable.method_25504((class_2382)blockPos, k, i - 1, l);
                        if (blockPos.method_19771((class_2382)mutable, searchDistance) && predicate.test((class_2338)mutable)) {
                            return Optional.of(mutable);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return Optional.empty();
    }

    private void retrieveAnchorTimer() {
        if (this.hasAnchor() && this.theConjunctionOfTheSpheres$getAnchor() != null && this.retrieveAnchorTimer < 30) {
            this.method_5942().method_6340();
            ++this.retrieveAnchorTimer;
        }
        this.retrieveAnchor();
    }

    public void method_5773() {
        super.method_5773();
        this.tickCharge();
        this.tickSleep();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_8514.class_8517.method_51406((class_1937)serverWorld, (class_8514.class_8515)this.vibrationListenerData, (class_8514.class_5719)this.vibrationCallback);
        }
        this.setFallingDistance(this.field_6017);
        this.tickJump();
        this.tickFindAnchor();
        this.tickAnchorLaunch();
        if (this.isSnowing()) {
            this.spawnSnowflakesAround();
        }
    }

    protected void method_5958() {
        super.method_5958();
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        if (this.isCharging()) {
            EntitiesUtil.pushAndDamageEntities((class_1308)this, 12.0f, 1.3, 1.2, 1.6, IceGiantEntity.class);
        }
        if (this.isGiantWakingUp() && this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            int i = class_3532.method_15357((double)this.method_23318());
            int j = class_3532.method_15357((double)this.method_23317());
            int k = class_3532.method_15357((double)this.method_23321());
            for (int l = -1; l <= 1; ++l) {
                for (int m = -1; m <= 1; ++m) {
                    for (int n = 0; n <= 4; ++n) {
                        int o = j + l;
                        int p = i + n;
                        int q = k + m;
                        class_2338 blockPos = new class_2338(o, p, q);
                        class_2680 blockState = this.method_37908().method_8320(blockPos);
                        if (!class_1528.method_6883((class_2680)blockState)) continue;
                        this.method_37908().method_8651(blockPos, true, (class_1297)this);
                    }
                }
            }
        }
        this.retrieveAnchorTimer();
        if (this.isSnowing()) {
            class_1324 entityAttributeInstance_speed;
            class_1324 entityAttributeInstance_attack = this.method_5996(class_5134.field_23721);
            if (entityAttributeInstance_attack != null) {
                entityAttributeInstance_attack.method_6200(BLIZZARD_STRENGTH_BOOST.comp_2447());
                entityAttributeInstance_attack.method_26835(BLIZZARD_STRENGTH_BOOST);
            }
            if ((entityAttributeInstance_speed = this.method_5996(class_5134.field_23719)) != null) {
                entityAttributeInstance_speed.method_6200(BLIZZARD_SPEED_BOOST.comp_2447());
                entityAttributeInstance_speed.method_26835(BLIZZARD_SPEED_BOOST);
            }
        } else {
            class_1324 entityAttributeInstance_speed;
            class_1324 entityAttributeInstance_attack = this.method_5996(class_5134.field_23721);
            if (entityAttributeInstance_attack != null) {
                entityAttributeInstance_attack.method_6200(BLIZZARD_STRENGTH_BOOST.comp_2447());
            }
            if ((entityAttributeInstance_speed = this.method_5996(class_5134.field_23719)) != null) {
                entityAttributeInstance_speed.method_6200(BLIZZARD_SPEED_BOOST.comp_2447());
            }
        }
    }

    private boolean isSnowing() {
        class_1959 biome = (class_1959)this.method_37908().method_23753(this.method_24515()).comp_349();
        return this.method_37908().method_8419() && biome.method_8696((class_4538)this.method_37908(), this.method_24515());
    }

    protected void spawnSnowflakesAround() {
        if (this.field_6012 % 6 == 0) {
            for (int i = 0; i < 8; ++i) {
                double d = this.method_23317() + (double)class_3532.method_32750((class_5819)this.method_59922(), (float)-1.0f, (float)1.0f);
                double e = this.method_23320() - 0.5 + (double)class_3532.method_32750((class_5819)this.method_59922(), (float)-1.0f, (float)1.0f);
                double f = this.method_23321() + (double)class_3532.method_32750((class_5819)this.method_59922(), (float)-1.0f, (float)1.0f);
                this.method_37908().method_8406((class_2394)class_2398.field_28013, d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Charging", this.isCharging());
        nbt.method_10569("ChargingCooldown", this.chargeCooldownTimer);
        nbt.method_10556("Sleeping", this.isGiantSleeping());
        nbt.method_10569("CanSleepTimer", this.canSleepTimer);
        nbt.method_10556("SleepCooldown", this.getSleepCooldown());
        nbt.method_10569("AnchorPosX", this.getAnchorPos().method_10263());
        nbt.method_10569("AnchorPosY", this.getAnchorPos().method_10264());
        nbt.method_10569("AnchorPosZ", this.getAnchorPos().method_10260());
        class_8514.class_8515.field_44640.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.vibrationListenerData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(listenerData -> nbt.method_10566("listener", listenerData));
        nbt.method_10556("ListenToSound", this.listenToSound);
        nbt.method_10569("JumpCooldown", this.jumpTicks);
        nbt.method_10569("AnchorLaunchTimer", this.anchorLaunchCooldownTimer);
        nbt.method_10556("AnchorLaunchCooldown", this.anchorLaunchCooldown);
        this.writeNbtGuardNest(nbt);
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        this.setIsCharging(nbt.method_10577("Charging"));
        this.chargeCooldownTimer = nbt.method_10550("ChargingCooldown");
        this.setIsGiantSleeping(nbt.method_10577("Sleeping"));
        this.canSleepTimer = nbt.method_10550("CanSleepTimer");
        this.setSleepCooldown(nbt.method_10577("SleepCooldown"));
        int x = nbt.method_10550("AnchorPosX");
        int y = nbt.method_10550("AnchorPosY");
        int z = nbt.method_10550("AnchorPosZ");
        this.setAnchorPos(new class_2338(x, y, z));
        if (nbt.method_10573("listener", 10)) {
            class_8514.class_8515.field_44640.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(listenerData -> {
                this.vibrationListenerData = listenerData;
            });
        }
        this.listenToSound = nbt.method_10577("ListenToSound");
        this.jumpTicks = nbt.method_10550("JumpCooldown");
        this.anchorLaunchCooldownTimer = nbt.method_10550("AnchorLaunchTimer");
        this.anchorLaunchCooldown = nbt.method_10577("AnchorLaunchCooldown");
        this.readNbtGuardNest(nbt);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void method_5837(@NotNull class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(@NotNull class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    public boolean method_6049(class_1293 effect) {
        return effect.method_5579() != TCOTS_Effects.NorthernWindEffect() && super.method_6049(effect);
    }

    public boolean method_5810() {
        return super.method_5810() && !this.isCharging() && !this.isGiantSleeping();
    }

    public boolean method_5679(@NotNull class_1282 damageSource) {
        return super.method_5679(damageSource) || this.isGiantWakingUp() || this.isFalling();
    }

    protected float method_6036(class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42243)) {
            return amount;
        }
        if (source.method_48789(class_8103.field_42247)) {
            return amount * 0.2f;
        }
        return super.method_6036(source, amount);
    }

    protected void method_16077(@NotNull class_1282 damageSource, boolean causedByPlayer) {
        super.method_16077(damageSource, causedByPlayer);
        if (this.hasAnchor() && causedByPlayer && this.field_5974.method_39332(0, 10) == 0) {
            this.method_5706((class_1935)this.method_6047().method_7909());
        }
    }

    protected float method_6106() {
        return 0.7f * this.method_23313() + this.method_37416();
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return super.method_23329(fallDistance, damageMultiplier) - 4;
    }

    public void method_6043() {
        this.method_5783(TCOTS_Sounds.getSoundEvent("ice_giant_punch"), 1.0f, 1.0f);
        super.method_6043();
    }

    public void method_38785() {
        if (this.isFalling()) {
            this.setIsFalling(false);
            if (this.method_37908().method_8320(this.method_24515().method_10074()).method_26227().method_39360(class_3612.field_15906) && !this.method_37908().method_8320(this.method_24515()).method_26164(TCOTS_Tags.NEGATES_DEVOURER_JUMP) && !this.method_37908().method_8320(this.method_24515().method_10074()).method_26164(TCOTS_Tags.NEGATES_DEVOURER_JUMP)) {
                this.triggerAnim("LandingController", "landing");
                EntitiesUtil.pushAndDamageEntities((class_1308)this, 8.0f + this.field_6017 * 2.0f, (double)(4.0f + this.field_6017 * 0.5f), 3.0, 3.0, new Class[0]);
                this.method_5783(TCOTS_Sounds.getSoundEvent("big_impact"), 1.0f, 1.0f);
                this.method_37908().method_8421((class_1297)this, (byte)42);
            }
        }
        super.method_38785();
    }

    public void method_5711(byte status) {
        if (status == 42) {
            EntitiesUtil.spawnImpactParticles((class_1297)this, (double)1.9975f + (4.0 + this.getFallingDistance() * 0.5), this.getFallingDistance());
        } else {
            super.method_5711(status);
        }
    }

    private void tickJump() {
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        } else {
            this.cooldownBetweenJumps = false;
        }
    }

    public void setIsFalling(boolean isFalling) {
        this.field_6011.method_12778(FALLING, (Object)isFalling);
    }

    public boolean isFalling() {
        return (Boolean)this.field_6011.method_12789(FALLING);
    }

    public void setFallingDistance(float fallingDistance) {
        this.field_6011.method_12778(FALLING_DISTANCE, (Object)Float.valueOf(fallingDistance));
    }

    public double getFallingDistance() {
        return ((Float)this.field_6011.method_12789(FALLING_DISTANCE)).floatValue();
    }

    @Nullable
    protected class_3414 method_5994() {
        if (!this.isGiantWakingUp()) {
            if (this.isGiantSleeping()) {
                return TCOTS_Sounds.getSoundEvent("ice_giant_snore");
            }
            return TCOTS_Sounds.getSoundEvent("ice_giant_idle");
        }
        return null;
    }

    @Override
    protected class_3414 getAttackSound() {
        return TCOTS_Sounds.getSoundEvent("ice_giant_attack");
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 source) {
        return TCOTS_Sounds.getSoundEvent("ice_giant_hurt");
    }

    @Nullable
    protected class_3414 method_6002() {
        return TCOTS_Sounds.getSoundEvent("ice_giant_death");
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static class VibrationCallback
    implements class_8514.class_5719 {
        private static final int RANGE = 16;
        private final class_5716 positionSource;
        private final IceGiantEntity giant;

        VibrationCallback(IceGiantEntity giant) {
            this.giant = giant;
            this.positionSource = new class_5709((class_1297)giant, (float)giant.method_23318());
        }

        public int method_49797() {
            return 16;
        }

        @NotNull
        public class_5716 method_51300() {
            return this.positionSource;
        }

        @NotNull
        public class_6862<class_5712> method_42210() {
            return class_5698.field_38079;
        }

        public boolean method_32970(@NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_6880<class_5712> event, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull class_5712.class_7397 emitter) {
            if (this.giant.method_5987() || !this.giant.isGiantSleeping() || this.giant.method_29504() || this.giant.isGiantWakingUp()) {
                return false;
            }
            class_1297 entity = emitter.comp_713();
            return !(entity instanceof class_1309) || !(entity instanceof class_1588) && this.giant.method_18395((class_1309)entity);
        }

        public void method_32969(@NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_6880<class_5712> event, @Nullable class_1297 sourceEntity, @Nullable class_1297 entity, float distance) {
            if (this.giant.method_29504()) {
                return;
            }
            this.giant.listenToSound = true;
        }
    }

    private static class WakeUpGoal
    extends class_1352 {
        private final IceGiantEntity giant;
        private final int returnTicks;
        int AnimationTicks = 70;

        public WakeUpGoal(IceGiantEntity giant, int returnTicks) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
            this.giant = giant;
            this.returnTicks = returnTicks;
        }

        public boolean method_6264() {
            return this.giant.isGiantSleeping() && this.giant.listenToSound;
        }

        public boolean method_6266() {
            return this.giant.isGiantSleeping();
        }

        public void method_6269() {
            this.giant.method_5783(TCOTS_Sounds.getSoundEvent("ice_giant_wake_up"), 1.0f, 1.0f);
            this.AnimationTicks = 70;
            this.giant.setIsGiantWakingUp(true);
        }

        public void method_6268() {
            if (this.AnimationTicks > 0) {
                --this.AnimationTicks;
            } else {
                this.method_6270();
            }
        }

        public void method_6270() {
            this.giant.setIsGiantWakingUp(false);
            this.giant.canSleepTimer = this.returnTicks + this.giant.method_59922().method_39332(1, 501);
            this.giant.setIsGiantSleeping(false);
            this.giant.listenToSound = false;
            this.giant.setSleepCooldown(true);
        }

        public boolean method_38846() {
            return true;
        }
    }

    private static class GoForAnchor
    extends class_1352 {
        private final IceGiantEntity giant;
        private final double speed;

        public GoForAnchor(IceGiantEntity giant, double speed) {
            this.giant = giant;
            this.speed = speed;
        }

        public boolean method_6264() {
            return this.giant.getAnchorPos() != class_2338.field_10980 && this.giant.method_6032() < this.giant.healthToReachSecondPhase && !this.giant.hasAnchor();
        }

        public boolean method_6266() {
            return !this.giant.hasAnchor();
        }

        public void method_6269() {
            this.giant.triggerAnim("AttackController", "big_attack");
            this.giant.method_5783(TCOTS_Sounds.getSoundEvent("ice_giant_charge"), 1.0f, 1.0f);
            EntitiesUtil.pushAndDamageEntities((class_1308)this.giant, 2.0f, 2.0, 1.5, 4.0, new Class[0]);
            this.startMovingTo(this.giant.method_5942(), this.giant.getAnchorPos().method_10263(), this.giant.getAnchorPos().method_10264(), this.giant.getAnchorPos().method_10260(), this.speed);
        }

        public void method_6268() {
            this.startMovingTo(this.giant.method_5942(), this.giant.getAnchorPos().method_10263(), this.giant.getAnchorPos().method_10264(), this.giant.getAnchorPos().method_10260(), this.speed);
            if (this.giant.method_5707(this.giant.getAnchorPos().method_46558()) < 16.0) {
                this.giant.method_37908().method_22352(this.giant.getAnchorPos(), false);
                this.giant.method_6122(class_1268.field_5808, new class_1799((class_1935)TCOTS_Items.GIANT_ANCHOR.get()));
            }
        }

        public void startMovingTo(class_1408 navigation, int x, int y, int z, double speed) {
            navigation.method_6334(navigation.method_6352((double)x, (double)y, (double)z, 2), speed);
        }
    }

    private static class GoToSleepGoal
    extends class_1352 {
        private final IceGiantEntity giant;

        public GoToSleepGoal(IceGiantEntity giant) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
            this.giant = giant;
        }

        protected boolean isAtFavoredLocation() {
            class_2338 blockPos = class_2338.method_49637((double)this.giant.method_23317(), (double)this.giant.method_5829().field_1325, (double)this.giant.method_23321());
            return !this.giant.method_37908().method_8311(blockPos) && this.giant.method_6149(blockPos) >= 0.0f || this.giant.method_37908().method_23886();
        }

        public boolean method_6264() {
            Iterable iterable = this.giant.method_37908().method_20812((class_1297)this.giant, this.giant.sleepingBox());
            for (class_265 voxelShape : iterable) {
                if (voxelShape.method_1110()) continue;
                return false;
            }
            return !this.giant.method_6510() && this.isAtFavoredLocation() && !this.giant.getSleepCooldown() && !this.giant.isGiantWakingUp();
        }

        public void method_6269() {
            this.giant.method_5942().method_6340();
            this.giant.setIsGiantSleeping(true);
            this.method_6270();
        }

        public boolean method_38846() {
            return true;
        }
    }

    private static class IceGiantJumpAttack
    extends class_1352 {
        private final IceGiantEntity giant;
        private final int minJumpCooldown;
        private final int maxJumpCooldown;

        public IceGiantJumpAttack(IceGiantEntity giant, int minJumpCooldown, int maxExtraRandomCooldown) {
            this.giant = giant;
            this.minJumpCooldown = minJumpCooldown;
            this.maxJumpCooldown = maxExtraRandomCooldown;
        }

        public boolean method_6264() {
            class_1309 target = this.giant.method_5968();
            if (target != null) {
                return !this.giant.cooldownBetweenJumps && this.giant.method_6510() && !this.giant.method_52535() && !this.giant.method_5765() && !this.giant.method_37908().method_8320(this.giant.method_24515()).method_27852(class_2246.field_21211) && !this.giant.method_37908().method_8320(this.giant.method_24515()).method_27852(class_2246.field_10343) && this.giant.method_5739((class_1297)target) < 8.0f && !this.giant.hasAnchor();
            }
            return false;
        }

        public void method_6268() {
            class_1309 target = this.giant.method_5968();
            if (target != null) {
                this.jumpAttack();
            }
        }

        private void jumpAttack() {
            this.giant.method_6043();
            this.giant.setIsFalling(true);
            this.giant.cooldownBetweenJumps = true;
            this.giant.jumpTicks = this.minJumpCooldown + this.giant.field_5974.method_39332(0, this.maxJumpCooldown);
        }
    }

    private static class MeleeAttackGoal_IceGiant
    extends MeleeAttackGoal_Animated {
        private final IceGiantEntity giant;
        private final double speedMultiplierRunValue;
        private final int chargeCooldownTicks;
        private final int sleepCooldown;
        private class_11 pathCharge;
        private double toChargeX;
        private double toChargeY;
        private double toChargeZ;

        public MeleeAttackGoal_IceGiant(IceGiantEntity mob, double speed, boolean pauseWhenMobIdle, double speedMultiplier, int chargeCooldown, int sleepCooldown) {
            super((class_1314)mob, speed, pauseWhenMobIdle, 2);
            this.giant = mob;
            this.speedMultiplierRunValue = speedMultiplier;
            this.chargeCooldownTicks = chargeCooldown;
            this.sleepCooldown = sleepCooldown;
        }

        @Override
        public boolean method_6264() {
            return !(!super.method_6264() || this.giant.isGiantWakingUp() && this.giant.isGiantSleeping() || this.giant.isFalling() || this.giant.getAnchorPos() != class_2338.field_10980 && this.giant.method_6032() < this.giant.healthToReachSecondPhase && !this.giant.hasAnchor());
        }

        @Override
        public boolean method_6266() {
            return !(!super.method_6266() || this.giant.isGiantWakingUp() && this.giant.isGiantSleeping() || this.giant.isFalling() || this.giant.getAnchorPos() != class_2338.field_10980 && this.giant.method_6032() < this.giant.healthToReachSecondPhase && !this.giant.hasAnchor());
        }

        @Override
        public void method_6269() {
            super.method_6269();
            this.giant.chargeCooldownTimer = 40;
            this.giant.chargeCooldown = true;
            this.giant.canSleepTimer = this.sleepCooldown + this.giant.method_59922().method_39332(1, 501);
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.giant.setIsCharging(false);
        }

        @Override
        public void method_6268() {
            double threshold;
            class_1309 target = this.giant.method_5968();
            if (target == null) {
                return;
            }
            if (this.giant.method_37908().field_9236) {
                return;
            }
            if (!this.giant.isCharging() && this.giant.theConjunctionOfTheSpheres$getAnchor() == null) {
                this.giant.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
                this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
                if ((this.pauseWhenMobIdle || this.giant.method_5985().method_6369((class_1297)target)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || target.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.giant.method_59922().method_43057() < 0.05f)) {
                    this.targetX = target.method_23317();
                    this.targetY = target.method_23318();
                    this.targetZ = target.method_23321();
                    this.updateCountdownTicks = 4 + this.giant.method_59922().method_43048(7);
                    double d = this.giant.method_5858((class_1297)target);
                    if (d > 1024.0) {
                        this.updateCountdownTicks += 10;
                    } else if (d > 256.0) {
                        this.updateCountdownTicks += 5;
                    }
                    if (!this.giant.method_5942().method_6335((class_1297)target, this.speed)) {
                        this.updateCountdownTicks += 15;
                    }
                    this.updateCountdownTicks = this.method_38847(this.updateCountdownTicks);
                }
                this.cooldown = Math.max(this.cooldown - 1, 0);
                this.attack(target);
            }
            class_243 monsterPosition = this.giant.method_19538();
            class_243 monsterLookVec = this.giant.method_5631(0.0f, this.giant.method_5791());
            boolean isFacingTarget = false;
            class_243 targetPosition = target.method_19538();
            class_243 directionToTarget = targetPosition.method_1020(monsterPosition).method_1029();
            double dotProduct = monsterLookVec.method_1026(directionToTarget);
            if (dotProduct > (threshold = 0.95)) {
                isFacingTarget = true;
            }
            if (this.giant.method_5739((class_1297)target) > 1.0f && !this.giant.chargeCooldown && !this.giant.isCharging() && isFacingTarget && this.giant.theConjunctionOfTheSpheres$getAnchor() == null) {
                this.giant.method_5988().method_6230(this.targetX, this.targetY, this.targetZ, 30.0f, 30.0f);
                double chargeDistance = 20.0;
                class_243 movingDirection = monsterPosition.method_1019(monsterLookVec.method_18805(chargeDistance, 0.0, chargeDistance));
                this.toChargeX = movingDirection.field_1352;
                this.toChargeY = movingDirection.field_1351;
                this.toChargeZ = movingDirection.field_1350;
                this.pathCharge = this.giant.method_5942().method_6352(this.toChargeX, this.toChargeY, this.toChargeZ, 0);
                if (this.pathCharge == null) {
                    return;
                }
                this.giant.setIsCharging(true);
                this.giant.method_5988().method_6230(this.toChargeX, this.toChargeY, this.toChargeZ, 30.0f, 30.0f);
                this.giant.method_5783(TCOTS_Sounds.getSoundEvent("ice_giant_charge"), 1.0f, 1.0f);
            }
            if (this.giant.isCharging()) {
                this.giant.method_5988().method_6230(this.toChargeX, this.toChargeY, this.toChargeZ, 30.0f, 30.0f);
                this.giant.method_5942().method_6334(this.pathCharge, this.speed * this.speedMultiplierRunValue);
                if (this.giant.method_5649(this.toChargeX, this.toChargeY, this.toChargeZ) < 2.0 || this.giant.field_5976) {
                    this.giant.setIsCharging(false);
                    this.giant.chargeCooldownTimer = this.giant.hasAnchor() ? this.chargeCooldownTicks * 3 : this.chargeCooldownTicks;
                    this.giant.chargeCooldown = true;
                }
            }
            if (!this.giant.isCharging() && this.giant.method_5739((class_1297)target) < 10.0f && this.giant.hasAnchor() && !this.giant.anchorLaunchCooldown && isFacingTarget) {
                this.giant.method_5942().method_6340();
                this.giant.method_5988().method_20248(this.targetX, this.targetY + 8.0, this.targetZ);
                this.giant.launchAnchor();
            }
        }
    }

    private static class WanderAroundGoal_Giant
    extends class_1379 {
        private final IceGiantEntity giant;

        public WanderAroundGoal_Giant(IceGiantEntity mob, double speed, int chance) {
            super((class_1314)mob, speed, chance);
            this.giant = mob;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.giant.isGiantSleeping() && !this.giant.isGiantWakingUp();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.giant.isGiantSleeping() && !this.giant.isGiantWakingUp();
        }
    }

    private static class LookAroundGoal_Giant
    extends class_1376 {
        private final IceGiantEntity giant;

        public LookAroundGoal_Giant(IceGiantEntity mob) {
            super((class_1308)mob);
            this.giant = mob;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.giant.isGiantSleeping();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.giant.isGiantSleeping();
        }
    }
}

