/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.items.weapons;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_9278;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jetbrains.annotations.NotNull;

public class WitcherBaseCrossbow
extends class_1764 {
    private boolean charged = false;
    private boolean loaded = false;
    private static final class_1764.class_9693 DEFAULT_LOADING_SOUNDS = new class_1764.class_9693(Optional.of(class_3417.field_14765), Optional.of(class_3417.field_14860), Optional.of(class_3417.field_14626));

    public WitcherBaseCrossbow(class_1792.class_1793 settings) {
        super(settings);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, class_1657 user, @NotNull class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        class_9278 chargedProjectilesComponent = (class_9278)itemStack.method_57824(class_9334.field_49649);
        if (chargedProjectilesComponent != null && !chargedProjectilesComponent.method_57442()) {
            this.method_7777(world, (class_1309)user, hand, itemStack, this.getShootingPower(chargedProjectilesComponent), 1.0f, null);
            return class_1271.method_22428((Object)itemStack);
        }
        if (!user.method_18808(itemStack).method_7960()) {
            this.charged = false;
            this.loaded = false;
            user.method_6019(hand);
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    class_1764.class_9693 method_59976(class_1799 stack) {
        return class_1890.method_60165((class_1799)stack, (class_9331)class_9701.field_51653).orElse(DEFAULT_LOADING_SOUNDS);
    }

    public void method_7852(class_1937 world, @NotNull class_1309 user, @NotNull class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236) {
            class_1764.class_9693 loadingSounds = this.method_59976(stack);
            float f = (float)(stack.method_7935(user) - remainingUseTicks) / (float)WitcherBaseCrossbow.method_7775((class_1799)stack, (class_1309)user);
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
                loadingSounds.comp_2673().ifPresent(sound -> world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), (class_3414)sound.comp_349(), class_3419.field_15248, 0.5f, 1.0f));
            }
            if (f >= 0.5f && !this.loaded) {
                this.loaded = true;
                loadingSounds.comp_2674().ifPresent(sound -> world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), (class_3414)sound.comp_349(), class_3419.field_15248, 0.5f, 1.0f));
            }
        }
    }

    public void method_7840(@NotNull class_1799 stack, @NotNull class_1937 world, @NotNull class_1309 user, int remainingUseTicks) {
        int i = this.method_7881(stack, user) - remainingUseTicks;
        float f = this.getPowerForTime(i, stack, user);
        if (f >= 1.0f && !WitcherBaseCrossbow.method_7781((class_1799)stack) && WitcherBaseCrossbow.tryLoadProjectiles(user, stack)) {
            class_1764.class_9693 loadingSounds = this.method_59976(stack);
            loadingSounds.comp_2675().ifPresent(sound -> world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), (class_3414)sound.comp_349(), user.method_5634(), 1.0f, 1.0f / (world.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f));
        }
    }

    private static boolean tryLoadProjectiles(class_1309 shooter, class_1799 crossbow) {
        List list = WitcherBaseCrossbow.method_57390((class_1799)crossbow, (class_1799)shooter.method_18808(crossbow), (class_1309)shooter);
        if (!list.isEmpty()) {
            crossbow.method_57379(class_9334.field_49649, (Object)class_9278.method_57441((List)list));
            return true;
        }
        return false;
    }

    private float getPowerForTime(int useTicks, class_1799 stack, class_1309 user) {
        float f = (float)useTicks / (float)this.getCrossbowPullTime(stack, user);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int method_7881(@NotNull class_1799 stack, @NotNull class_1309 user) {
        return this.getCrossbowPullTime(stack, user) + 3;
    }

    protected float getShootingPower(class_9278 stack) {
        return stack.method_57438(class_1802.field_8639) ? 1.6f : 3.15f;
    }

    public int getCrossbowPullTime(class_1799 stack, class_1309 user) {
        float f = class_1890.method_60159((class_1799)stack, (class_1309)user, (float)1.25f);
        return class_3532.method_15375((float)(f * 20.0f));
    }
}

