/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.mixin;

import TCOTS.entity.misc.ScurverSpineEntity;
import TCOTS.entity.misc.bolts.WitcherBolt;
import TCOTS.items.weapons.BoltItem;
import TCOTS.items.weapons.WitcherBaseCrossbow;
import TCOTS.registry.TCOTS_Items;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1007;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_759;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class CrossbowMixins {

    @Mixin(value={class_1665.class})
    public static class PersistentProjectileEntityMixin {
        @Unique
        class_1665 THIS = (class_1665)this;

        @Redirect(method={"onHitEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setArrowCount(I)V"))
        private void redirectNoStuckArrows(class_1309 entity, int stuckArrowCount) {
            if (this.THIS instanceof WitcherBolt || this.THIS instanceof ScurverSpineEntity) {
                entity.method_6097(entity.method_6022());
            } else {
                entity.method_6097(entity.method_6022() + 1);
            }
        }
    }

    @Mixin(value={class_1764.class})
    public static class CrossbowItemMixin {
        @Unique
        private static final Predicate<class_1799> CROSSBOW_BOLTS = stack -> stack.method_31574((class_1792)TCOTS_Items.BASE_BOLT.get()) || stack.method_31574((class_1792)TCOTS_Items.BLUNT_BOLT.get()) || stack.method_31574((class_1792)TCOTS_Items.PRECISION_BOLT.get()) || stack.method_31574((class_1792)TCOTS_Items.EXPLODING_BOLT.get()) || stack.method_31574((class_1792)TCOTS_Items.BROADHEAD_BOLT.get());

        @Inject(method={"getChargeDuration"}, at={@At(value="HEAD")}, cancellable=true)
        private static void getPullTimeCorrectlyForAnimation(class_1799 stack, class_1309 user, CallbackInfoReturnable<Integer> cir) {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof WitcherBaseCrossbow) {
                WitcherBaseCrossbow crossbow = (WitcherBaseCrossbow)class_17922;
                cir.setReturnValue((Object)crossbow.getCrossbowPullTime(stack, user));
            }
        }

        @Inject(method={"getAllSupportedProjectiles()Ljava/util/function/Predicate;"}, at={@At(value="RETURN")}, cancellable=true)
        private void insertCrossbowProjectiles(CallbackInfoReturnable<Predicate<class_1799>> cir) {
            cir.setReturnValue(((Predicate)cir.getReturnValue()).or(CROSSBOW_BOLTS));
        }

        @Inject(method={"getSupportedHeldProjectiles()Ljava/util/function/Predicate;"}, at={@At(value="RETURN")}, cancellable=true)
        private void insertCrossbowHeldProjectiles(CallbackInfoReturnable<Predicate<class_1799>> cir) {
            cir.setReturnValue(((Predicate)cir.getReturnValue()).or(CROSSBOW_BOLTS));
        }

        @Inject(method={"createProjectile"}, at={@At(value="RETURN")}, cancellable=true)
        private void injectExtraPiercing(class_1937 world, class_1309 shooter, class_1799 weaponStack, class_1799 arrow, boolean critical, CallbackInfoReturnable<class_1676> cir) {
            BoltItem bolt;
            boolean precisionBolt;
            Object object = arrow.method_7909();
            boolean bl = precisionBolt = object instanceof BoltItem && Objects.equals((bolt = (BoltItem)((Object)object)).getId(), "precision_bolt");
            if (precisionBolt && (object = cir.getReturnValue()) instanceof class_1665) {
                class_1665 persistentProjectileEntity = (class_1665)object;
                persistentProjectileEntity.method_7451((byte)(persistentProjectileEntity.method_7447() + 2));
                cir.setReturnValue((Object)persistentProjectileEntity);
            }
        }
    }

    @Mixin(value={class_759.class})
    public static class HeldItemRendererMixin {
        @Inject(method={"selectionUsingItemWhileHoldingBowLike"}, at={@At(value="TAIL")}, cancellable=true)
        private static void injectKnightCrossbowHandRenderer(class_746 player, CallbackInfoReturnable<class_759.class_5773> cir) {
            class_1799 itemStack = player.method_6030();
            class_1268 hand = player.method_6058();
            if (itemStack.method_7909() instanceof WitcherBaseCrossbow) {
                cir.setReturnValue((Object)class_759.class_5773.method_33305((class_1268)hand));
            }
        }

        @Inject(method={"isChargedCrossbow"}, at={@At(value="TAIL")}, cancellable=true)
        private static void injectKnightCrossbowCharged(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
            cir.setReturnValue((Object)(stack.method_7909() instanceof WitcherBaseCrossbow && class_1764.method_7781((class_1799)stack) ? 1 : 0));
        }
    }

    @Mixin(value={class_1007.class})
    public static class PlayerEntityRendererMixin {
        @Inject(method={"getArmPose"}, at={@At(value="TAIL")}, cancellable=true)
        private static void injectKnightCrossbowPose(class_742 player, class_1268 hand, CallbackInfoReturnable<class_572.class_573> cir) {
            class_1799 itemStack = player.method_5998(hand);
            if (!player.field_6252 && itemStack.method_7909() instanceof WitcherBaseCrossbow && class_1764.method_7781((class_1799)itemStack)) {
                cir.setReturnValue((Object)class_572.class_573.field_3408);
            }
        }
    }
}

