/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.mixin;

import TCOTS.entity.misc.AnchorProjectileEntity;
import TCOTS.entity.ogroids.AbstractTrollEntity;
import TCOTS.interfaces.LivingEntityMixinInterface;
import TCOTS.items.components.MonsterOilComponent;
import TCOTS.items.concoctions.bombs.MoonDustBomb;
import TCOTS.items.concoctions.bombs.NorthernWindBomb;
import TCOTS.items.concoctions.bombs.SamumBomb;
import TCOTS.registry.TCOTS_Criteria;
import TCOTS.registry.TCOTS_DamageTypes;
import TCOTS.registry.TCOTS_Effects;
import TCOTS.registry.TCOTS_Items;
import TCOTS.registry.TCOTS_Particles;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.EntitiesUtil;
import TCOTS.utils.MiscUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1498;
import net.minecraft.class_1528;
import net.minecraft.class_1547;
import net.minecraft.class_1577;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_4094;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7260;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_8149;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements class_8149,
LivingEntityMixinInterface {
    @Unique
    class_1309 THIS = (class_1309)this;
    @Unique
    private static final class_2940<Integer> KILL_COUNT = class_2945.method_12791(LivingEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> KILL_COUNTDOWN = class_2945.method_12791(LivingEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Boolean> IS_FROZEN = class_2945.method_12791(LivingEntityMixin.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Boolean> SILVER_SPLINTERS = class_2945.method_12791(LivingEntityMixin.class, (class_2941)class_2943.field_13323);
    @Unique
    private boolean attackerHasGvalchir = false;
    @Unique
    private boolean passengerHasDecoction = false;
    @Unique
    private static final class_1322 PASSENGER_SPEED_BOOST = new class_1322(class_2960.method_60655((String)"tcots_witcher", (String)"passenger_speed_boost"), 0.5, class_1322.class_1323.field_6330);
    @Unique
    private static final class_1322 RAVEN_SPEED_BONUS = new class_1322(class_2960.method_60655((String)"tcots_witcher", (String)"raven_speed_boost"), (double)0.1f, class_1322.class_1323.field_6330);
    @Unique
    private static final class_1322 TUNDRA_ARMOR_BONUS = new class_1322(class_2960.method_60655((String)"tcots_witcher", (String)"tundra_armor_speed_boost"), (double)0.2f, class_1322.class_1323.field_6330);
    @Unique
    @Nullable
    public AnchorProjectileEntity anchorProjectile;
    @Unique
    private static final byte BLOOD_PARTICLES = 72;
    @Unique
    private static final byte BLACK_BLOOD_PARTICLES = 73;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract void method_5768();

    @Shadow
    public abstract boolean method_5643(@NotNull class_1282 var1, float var2);

    @Shadow
    public abstract float method_6063();

    @Shadow
    public abstract float method_6032();

    @Shadow
    @Nullable
    public abstract class_1309 method_6052();

    @Shadow
    @Nullable
    public abstract class_1309 method_6065();

    @ModifyVariable(method={"decreaseAirSupply"}, at=@At(value="STORE"))
    private double checkForKillerWhaleEffect(double d) {
        if (this.method_6059(TCOTS_Effects.KillerWhaleEffect())) {
            d = 2.0;
        }
        return d;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void injectKillCountDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(KILL_COUNT, (Object)0);
        builder.method_56912(KILL_COUNTDOWN, (Object)0);
    }

    @Override
    public int theConjunctionOfTheSpheres$getKillCount() {
        return (Integer)this.field_6011.method_12789(KILL_COUNT);
    }

    @Override
    public void theConjunctionOfTheSpheres$setKillCount(int killCount) {
        this.field_6011.method_12778(KILL_COUNT, (Object)killCount);
    }

    @Override
    public int theConjunctionOfTheSpheres$getKillCountdown() {
        return (Integer)this.field_6011.method_12789(KILL_COUNTDOWN);
    }

    @Override
    public void theConjunctionOfTheSpheres$setKillCountdown(int killCountdown) {
        this.field_6011.method_12778(KILL_COUNTDOWN, (Object)killCountdown);
    }

    @Override
    public void theConjunctionOfTheSpheres$incrementKillCount() {
        int count = this.theConjunctionOfTheSpheres$getKillCount();
        this.theConjunctionOfTheSpheres$setKillCount(count + 1);
    }

    @Inject(method={"setLastHurtMob"}, at={@At(value="HEAD")})
    private void injectCountdownAttack(CallbackInfo ci) {
        this.THIS.theConjunctionOfTheSpheres$setKillCountdown(300);
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    private void injectCountdown(CallbackInfo ci) {
        if (this.THIS.method_6059(TCOTS_Effects.GraveHagDecoctionEffect())) {
            int count = this.THIS.theConjunctionOfTheSpheres$getKillCountdown();
            if (this.THIS.theConjunctionOfTheSpheres$getKillCountdown() > 0) {
                this.THIS.theConjunctionOfTheSpheres$setKillCountdown(count - 1);
            } else if (this.THIS.theConjunctionOfTheSpheres$getKillCountdown() == 0) {
                this.THIS.theConjunctionOfTheSpheres$setKillCount(0);
            }
        } else {
            this.THIS.theConjunctionOfTheSpheres$setKillCountdown(0);
            this.THIS.theConjunctionOfTheSpheres$setKillCount(0);
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void injectKillCounter(class_1282 damageSource, CallbackInfo ci) {
        int killCount;
        class_1309 livingEntity = this.THIS.method_6124();
        if (livingEntity != null && livingEntity.method_6059(TCOTS_Effects.GraveHagDecoctionEffect()) && (killCount = livingEntity.theConjunctionOfTheSpheres$getKillCount()) < 20) {
            livingEntity.theConjunctionOfTheSpheres$incrementKillCount();
            livingEntity.theConjunctionOfTheSpheres$setKillCountdown(420);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectKillCountWriteNBT(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("KillCount", this.THIS.theConjunctionOfTheSpheres$getKillCount());
        nbt.method_10569("KillCountdown", this.THIS.theConjunctionOfTheSpheres$getKillCountdown());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectKillCountReadNBT(class_2487 nbt, CallbackInfo ci) {
        this.THIS.theConjunctionOfTheSpheres$setKillCount(nbt.method_10550("KillCount"));
        this.THIS.theConjunctionOfTheSpheres$setKillCountdown(nbt.method_10550("KillCountdown"));
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float injectFoggyResistance(float amount) {
        if (this.method_6059(TCOTS_Effects.FogletDecoctionEffect()) && this.method_37908() instanceof class_3218 && (this.method_37908().method_8419() || this.method_37908().method_8546())) {
            return amount / 2.0f;
        }
        return amount;
    }

    @Inject(method={"hurt"}, at={@At(value="TAIL")})
    private void injectBlackBloodDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_6059(TCOTS_Effects.BlackBloodEffect())) {
            class_1297 class_12972;
            float damageMultiplier;
            int amplifier = Objects.requireNonNull(this.method_6112(TCOTS_Effects.BlackBloodEffect())).method_5578();
            switch (amplifier) {
                case 0: {
                    float f = 0.15f;
                    break;
                }
                case 1: {
                    float f = 0.2f;
                    break;
                }
                default: {
                    float f = damageMultiplier = 0.3f;
                }
            }
            if (source.method_5529() != null && (class_12972 = source.method_5529()) instanceof class_1309) {
                class_1309 attackerBlack = (class_1309)class_12972;
                if (!(source.method_5526() instanceof class_1676) && !(source.method_5526() instanceof class_1665)) {
                    if (amount > 0.0f && (EntitiesUtil.isNecrophage(attackerBlack) || EntitiesUtil.isVampire(attackerBlack))) {
                        attackerBlack.method_5643(attackerBlack.method_48923().method_48831(), amount * damageMultiplier);
                    }
                    double d = this.method_23317() - attackerBlack.method_23317();
                    double e = this.method_23321() - attackerBlack.method_23321();
                    if (amplifier > 0) {
                        attackerBlack.method_6005((double)((float)amplifier * 0.5f), d, e);
                    }
                }
            }
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), TCOTS_Sounds.getSoundEvent("black_blood_hit"), this.method_5634(), 1.0f, 1.0f);
            this.method_37908().method_8421((class_1297)this.THIS, (byte)73);
        }
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    private void injectBlackBloodBleedingEffect(CallbackInfo ci) {
        List list;
        int amplifier;
        if (this.method_6059(TCOTS_Effects.BlackBloodEffect()) && (amplifier = Objects.requireNonNull(this.method_6112(TCOTS_Effects.BlackBloodEffect())).method_5578()) > 1 && !(list = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1009(5.0, 2.0, 5.0), livingEntity -> EntitiesUtil.isNecrophage(livingEntity) || EntitiesUtil.isVampire(livingEntity))).isEmpty()) {
            list.forEach(livingEntity -> {
                if (!livingEntity.method_6059(TCOTS_Effects.BleedingBlackBloodEffect())) {
                    livingEntity.method_6092(new class_1293(TCOTS_Effects.BleedingBlackBloodEffect(), 60, 0, true, false, false));
                }
            });
        }
    }

    @Inject(method={"hurt"}, at={@At(value="TAIL")})
    private void injectRemoveSamumOnHit(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (SamumBomb.checkSamumEffect(this.THIS)) {
            this.method_6016(TCOTS_Effects.SamumEffect());
        }
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectImmunityToStun(class_1293 effect, CallbackInfoReturnable<Boolean> cir) {
        if ((this.THIS instanceof class_7260 || this.THIS instanceof class_1577) && effect.method_5579() == TCOTS_Effects.SamumEffect()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean theConjunctionOfTheSpheres$isFrozen() {
        return (Boolean)this.field_6011.method_12789(IS_FROZEN);
    }

    @Unique
    public void setIsFrozen(boolean frozen) {
        this.field_6011.method_12778(IS_FROZEN, (Object)frozen);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void injectNorthernWindDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(IS_FROZEN, (Object)false);
    }

    @Inject(method={"hurt"}, at={@At(value="TAIL")})
    private void injectRemoveNorthernWindOnHit(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (NorthernWindBomb.checkEffect(this.THIS)) {
            this.method_5783(class_3417.field_15081, 1.0f, 1.0f);
            this.method_6016(TCOTS_Effects.NorthernWindEffect());
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float injectExtraDamageNorthernWind(float amount) {
        if (NorthernWindBomb.checkEffect(this.THIS)) {
            int amplifier = Objects.requireNonNull(this.method_6112(TCOTS_Effects.NorthernWindEffect())).method_5578();
            int randomN = this.field_5974.method_39332(0, 10);
            if (this.method_6063() <= 100.0f && amplifier > 1 && randomN == 0) {
                return this.method_6032();
            }
            if (amplifier > 1 && randomN == 0) {
                return amount + 20.0f;
            }
            return amount + (float)(1 + amplifier);
        }
        return amount;
    }

    @ModifyVariable(method={"knockback"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private double injectExtraKnockbackNorthernWind(double strength) {
        if (NorthernWindBomb.checkEffect(this.THIS)) {
            return strength * 1.8;
        }
        return strength;
    }

    @Inject(method={"isPushable"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectNorthernWindNoPushable(CallbackInfoReturnable<Boolean> cir) {
        if (NorthernWindBomb.checkEffect(this.THIS)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    private void injectIsFrozen(CallbackInfo ci) {
        if (!this.THIS.method_37908().field_9236) {
            this.setIsFrozen(NorthernWindBomb.checkEffect(this.THIS));
        }
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectImmunityToFreeze(class_1293 effect, CallbackInfoReturnable<Boolean> cir) {
        if (this.THIS.method_5864().method_20210(class_3483.field_29825) && effect.method_5579() == TCOTS_Effects.NorthernWindEffect()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean theConjunctionOfTheSpheres$hasSilverSplinters() {
        return (Boolean)this.field_6011.method_12789(SILVER_SPLINTERS);
    }

    @Unique
    public void setSilverSplinters(boolean frozen) {
        this.field_6011.method_12778(SILVER_SPLINTERS, (Object)frozen);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void injectMoonDustDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(SILVER_SPLINTERS, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectSilverSplintersWriteNBT(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10556("SilverSplinters", this.THIS.theConjunctionOfTheSpheres$hasSilverSplinters());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectSilverSplintersReadNBT(class_2487 nbt, CallbackInfo ci) {
        this.setSilverSplinters(nbt.method_10577("SilverSplinters"));
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    private void injectHasSilverSplinters(CallbackInfo ci) {
        int amplifier;
        if (!this.THIS.method_37908().field_9236 && MoonDustBomb.checkOnlyEffect(this.THIS) && (amplifier = Objects.requireNonNull(this.THIS.method_6112(TCOTS_Effects.MoonDustEffect())).method_5578()) > 1) {
            this.setSilverSplinters(true);
        }
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectImmunityToBleeding(class_1293 effect, CallbackInfoReturnable<Boolean> cir) {
        if ((this.THIS instanceof class_1547 || EntitiesUtil.isElementa(this.THIS) || this.THIS instanceof class_1528 || EntitiesUtil.isSpecter(this.THIS)) && (effect.method_5579() == TCOTS_Effects.Bleeding() || effect.method_5579() == TCOTS_Effects.BleedingBlackBloodEffect())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")})
    private void getAttackerGvalchirBoolean(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        class_1309 livingEntity;
        class_1297 class_12972 = source.method_5529();
        this.attackerHasGvalchir = class_12972 instanceof class_1309 ? (livingEntity = (class_1309)class_12972).method_6047().method_7909() == TCOTS_Items.GVALCHIR.get() && !(source.method_5526() instanceof class_1676) && !(source.method_5526() instanceof class_1665) && source.method_48793() != class_8111.field_42349 : false;
    }

    @ModifyArgs(method={"getDamageAfterArmorAbsorb"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterAbsorb(Lnet/minecraft/world/entity/LivingEntity;FLnet/minecraft/world/damagesource/DamageSource;FF)F"))
    private void injectArmorPenetration(Args args) {
        if (this.attackerHasGvalchir) {
            float armor = ((Float)args.get(3)).floatValue();
            float armorToughness = ((Float)args.get(4)).floatValue();
            args.set(3, (Object)Float.valueOf(armor * (1.0f - MiscUtil.gvalchir_penetration)));
            args.set(4, (Object)Float.valueOf(armorToughness * 0.5f));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void injectExtraNekkerWarriorSpeed(CallbackInfo ci) {
        class_1309 passenger;
        if (this.THIS.method_5782() && (passenger = this.THIS.method_5642()) instanceof class_1309) {
            class_1324 entityAttributeInstance;
            class_1309 livingPassenger = passenger;
            if (livingPassenger.method_6059(TCOTS_Effects.NekkerWarriorDecoctionEffect())) {
                this.passengerHasDecoction = true;
                class_1324 entityAttributeInstance2 = this.THIS.method_5996(class_5134.field_23719);
                if (entityAttributeInstance2 != null) {
                    entityAttributeInstance2.method_6200(PASSENGER_SPEED_BOOST.comp_2447());
                    entityAttributeInstance2.method_26835(PASSENGER_SPEED_BOOST);
                }
            } else if (this.passengerHasDecoction && (entityAttributeInstance = this.THIS.method_5996(class_5134.field_23719)) != null) {
                entityAttributeInstance.method_6200(PASSENGER_SPEED_BOOST.comp_2447());
                this.passengerHasDecoction = false;
            }
        }
    }

    @Inject(method={"die"}, at={@At(value="TAIL")})
    private void injectTrollTriggerDefending(class_1282 damageSource, CallbackInfo ci) {
        class_1309 class_13092;
        if (this.method_37908() instanceof class_3218 && (class_13092 = this.method_6052()) instanceof AbstractTrollEntity) {
            AbstractTrollEntity troll = (AbstractTrollEntity)class_13092;
            class_13092 = this.method_6065();
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                if (!this.method_37908().field_9236 && !troll.isRabid()) {
                    ((class_3218)this.method_37908()).method_19496(troll.getDefendingInteraction(false), (class_1297)player, (class_4094)troll);
                    troll.handleNearTrollsInteraction(troll.getDefendingInteraction(true), player);
                    troll.method_37908().method_8421((class_1297)troll, troll.getFriendship(player) > troll.getMinFriendshipToBeFollower() ? (byte)12 : 14);
                    troll.handleNearTrollsParticles((byte)14);
                }
            }
        }
    }

    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void GolemNotAttackFriendlyIceTroll(class_1309 target, CallbackInfoReturnable<Boolean> cir) {
        AbstractTrollEntity troll;
        if (this.THIS.method_5864() == class_1299.field_6147 && target instanceof AbstractTrollEntity && !(troll = (AbstractTrollEntity)target).isRabid()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"die"}, at={@At(value="TAIL")})
    private void injectTriggerAdvancement(class_1282 damageSource, CallbackInfo ci) {
        MonsterOilComponent monsterOil;
        class_1657 player;
        class_1309 class_13092;
        if (EntitiesUtil.isHumanoid(this.THIS) && (class_13092 = this.method_6065()) instanceof class_1657 && (player = (class_1657)class_13092).method_6047().method_57826(TCOTS_Items.MonsterOilComponent()) && player.method_6047().method_57824(TCOTS_Items.MonsterOilComponent()) != null && (monsterOil = (MonsterOilComponent)player.method_6047().method_57824(TCOTS_Items.MonsterOilComponent())) != null && monsterOil.groupId() == 11 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            TCOTS_Criteria.KillWithHanged().trigger(serverPlayer);
        }
    }

    @Shadow
    public abstract class_1799 method_6047();

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_6880<class_1291> var1);

    @Shadow
    public abstract boolean method_6016(class_6880<class_1291> var1);

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectArmorExtraMonsterResistance(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        class_1309 attacker;
        class_1309 attacker2;
        class_1297 class_12972;
        if (source.method_48789(class_8103.field_42245)) {
            cir.setReturnValue((Object)Float.valueOf(amount));
        }
        if (EntitiesUtil.isWearingRavensArmor(this.THIS) && source.method_5529() != null && (class_12972 = source.method_5529()) instanceof class_1309 && EntitiesUtil.isMonster(attacker2 = (class_1309)class_12972)) {
            cir.setReturnValue((Object)Float.valueOf(amount * 0.5f));
        } else if (EntitiesUtil.isWearingWarriorsLeatherArmor(this.THIS) && source.method_5529() != null && (class_12972 = source.method_5529()) instanceof class_1309 && EntitiesUtil.isMonster(attacker = (class_1309)class_12972)) {
            cir.setReturnValue((Object)Float.valueOf(amount * 0.75f));
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="TAIL")})
    private void injectRavensArmorSetBonus(CallbackInfo ci) {
        if (EntitiesUtil.isWearingRavensArmor(this.THIS)) {
            class_1324 entityAttributeInstance = this.THIS.method_5996(class_5134.field_23719);
            if (entityAttributeInstance != null) {
                entityAttributeInstance.method_6200(RAVEN_SPEED_BONUS.comp_2447());
                entityAttributeInstance.method_26835(RAVEN_SPEED_BONUS);
            }
        } else {
            class_1324 entityAttributeInstance = this.THIS.method_5996(class_5134.field_23719);
            if (entityAttributeInstance != null) {
                entityAttributeInstance.method_6200(RAVEN_SPEED_BONUS.comp_2447());
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void injectWintersBladeExtinguish(CallbackInfo ci) {
        if (this.THIS.method_5809() && (this.THIS.method_6047().method_31574((class_1792)TCOTS_Items.WINTERS_BLADE.get()) || this.THIS.method_6079().method_31574((class_1792)TCOTS_Items.WINTERS_BLADE.get()))) {
            this.THIS.method_5646();
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="TAIL")})
    private void injectSnowSpeed(CallbackInfo ci) {
        class_1309 class_13092 = this.THIS;
        if (class_13092 instanceof class_1498) {
            class_1498 horse = (class_1498)class_13092;
            if (horse.method_56676().method_31574((class_1792)TCOTS_Items.TUNDRA_HORSE_ARMOR.get()) && (this.isSteepingOrInside((class_1309)horse, class_2246.field_27879) || this.isSteepingOrInside((class_1309)horse, class_2246.field_10491) || this.isSteepingOrInside((class_1309)horse, class_2246.field_10477) || this.isSteepingOrInside((class_1309)horse, class_2246.field_10295) || this.isSteepingOrInside((class_1309)horse, class_2246.field_10384) || this.isSteepingOrInside((class_1309)horse, class_2246.field_10225) || this.isSteepingOrInside((class_1309)horse, class_2246.field_10110))) {
                entityAttributeInstance = this.THIS.method_5996(class_5134.field_23719);
                if (entityAttributeInstance != null) {
                    entityAttributeInstance.method_6200(TUNDRA_ARMOR_BONUS.comp_2447());
                    entityAttributeInstance.method_26835(TUNDRA_ARMOR_BONUS);
                }
            } else {
                entityAttributeInstance = this.THIS.method_5996(class_5134.field_23719);
                if (entityAttributeInstance != null) {
                    entityAttributeInstance.method_6200(TUNDRA_ARMOR_BONUS.comp_2447());
                }
            }
        }
    }

    @Unique
    private boolean isSteepingOrInside(class_1309 entity, class_2248 block) {
        return entity.method_25936().method_27852(block) || entity.method_37908().method_8320(entity.method_24515()).method_27852(block);
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectKnightHorseArmorResistance(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        class_1498 horse;
        class_1309 class_13092 = this.THIS;
        if (class_13092 instanceof class_1498 && (horse = (class_1498)class_13092).method_56676().method_31574((class_1792)TCOTS_Items.KNIGHT_ERRANTS_HORSE_ARMOR.get())) {
            if (source.method_48789(class_8103.field_42245)) {
                cir.setReturnValue((Object)Float.valueOf(amount));
            }
            if (source.method_48789(class_8103.field_42247)) {
                cir.setReturnValue((Object)Float.valueOf(amount * 0.6f));
            }
            if (source.method_48789(class_8103.field_42249)) {
                cir.setReturnValue((Object)Float.valueOf(amount * 0.8f));
            }
        }
    }

    public AnchorProjectileEntity theConjunctionOfTheSpheres$getAnchor() {
        return this.anchorProjectile;
    }

    @Override
    public void theConjunctionOfTheSpheres$setAnchor(Object anchor) {
        this.anchorProjectile = (AnchorProjectileEntity)((Object)anchor);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void injectDiscardAnchor(CallbackInfo ci) {
        if (!this.method_37908().field_9236 && this.theConjunctionOfTheSpheres$getAnchor() != null) {
            this.theConjunctionOfTheSpheres$getAnchor().method_7432(null);
        }
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="TAIL")})
    private void injectParticles(byte status, CallbackInfo ci) {
        if (status == 72) {
            this.spawnBloodParticles(this.THIS, TCOTS_Particles.FallingBloodParticle());
        }
        if (status == 73) {
            this.spawnBloodParticles(this.THIS, TCOTS_Particles.FallingBlackBloodParticle());
        }
    }

    @Inject(method={"hurt"}, at={@At(value="TAIL")})
    private void injectInDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_49708(TCOTS_DamageTypes.BLEEDING) && !this.method_6059(TCOTS_Effects.BlackBloodEffect())) {
            this.method_37908().method_8421((class_1297)this.THIS, this.THIS.method_6059(TCOTS_Effects.BleedingBlackBloodEffect()) ? (byte)73 : 72);
        }
    }

    @Unique
    protected void spawnBloodParticles(class_1309 entity, class_2400 particle) {
        for (int i = 0; i < 10; ++i) {
            double d = entity.method_23317() + (double)class_3532.method_32750((class_5819)entity.method_59922(), (float)((float)(-entity.method_5829().method_17939()) / 2.0f), (float)((float)entity.method_5829().method_17939() / 2.0f));
            double e = entity.method_23320() + (double)class_3532.method_32750((class_5819)entity.method_59922(), (float)-0.5f, (float)0.25f);
            double f = entity.method_23321() + (double)class_3532.method_32750((class_5819)entity.method_59922(), (float)((float)(-entity.method_5829().method_17941()) / 2.0f), (float)((float)entity.method_5829().method_17941() / 2.0f));
            entity.method_37908().method_8406((class_2394)particle, d, e, f, 0.0, 0.0, 0.0);
        }
    }
}

