/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.mixin;

import TCOTS.entity.TCOTS_EntityAttributes;
import TCOTS.interfaces.PlayerEntityMixinInterface;
import TCOTS.items.components.MonsterOilComponent;
import TCOTS.items.concoctions.EmptyWitcherPotionItem;
import TCOTS.items.concoctions.WitcherAlcohol_Base;
import TCOTS.items.concoctions.bombs.SamumBomb;
import TCOTS.registry.TCOTS_Criteria;
import TCOTS.registry.TCOTS_DamageTypes;
import TCOTS.registry.TCOTS_Effects;
import TCOTS.registry.TCOTS_Items;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.EntitiesUtil;
import TCOTS.utils.MiscUtil;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_5132;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements PlayerEntityMixinInterface {
    @Unique
    class_1657 THIS = (class_1657)this;
    @Final
    @Shadow
    class_1661 field_7514;
    @Unique
    private float oilDamageAdded = 0.0f;
    @Unique
    private static final class_2940<Integer> MUD_TICKS = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private int potionTimer;
    @Unique
    List<WitcherAlcohol_Base> list_alcohol = Arrays.asList((WitcherAlcohol_Base)((Object)TCOTS_Items.ALCOHEST.get()), (WitcherAlcohol_Base)((Object)TCOTS_Items.VILLAGE_HERBAL.get()), (WitcherAlcohol_Base)((Object)TCOTS_Items.CHERRY_CORDIAL.get()), (WitcherAlcohol_Base)((Object)TCOTS_Items.MANDRAKE_CORDIAL.get()), (WitcherAlcohol_Base)((Object)TCOTS_Items.ICY_SPIRIT.get()), (WitcherAlcohol_Base)((Object)TCOTS_Items.DWARVEN_SPIRIT.get()), (WitcherAlcohol_Base)((Object)TCOTS_Items.WHITE_GULL.get()));
    @Unique
    private static final class_2940<Integer> TOXICITY = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> DECOCTION_TOXICITY = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Boolean> HUD_ACTIVE = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Float> HUD_TRANSPARENCY = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13320);
    @Unique
    private static final class_2940<Boolean> EYES_ACTIVATE = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Vector3f> EYES_POSITION = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_42237);
    @Unique
    private static final class_2940<Integer> EYES_SEPARATION = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> EYES_SHAPE = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Boolean> TOXICITY_ACTIVATE = class_2945.method_12791(PlayerEntityMixin.class, (class_2941)class_2943.field_13323);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"createAttributes"}, at={@At(value="RETURN")}, cancellable=true)
    private static void injectToxicity(CallbackInfoReturnable<class_5132.class_5133> cir) {
        cir.setReturnValue((Object)((class_5132.class_5133)cir.getReturnValue()).method_26867(TCOTS_EntityAttributes.GENERIC_WITCHER_MAX_TOXICITY));
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    private void injectMonsterOil(class_1297 target, CallbackInfo ci) {
        if (target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            if (this.THIS.method_6047().method_57826(TCOTS_Items.MonsterOilComponent())) {
                MonsterOilComponent monsterOil = (MonsterOilComponent)this.THIS.method_6047().method_57824(TCOTS_Items.MonsterOilComponent());
                switch (Objects.requireNonNull(monsterOil).groupId()) {
                    case 0: {
                        if (!EntitiesUtil.isNecrophage(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 1: {
                        if (!EntitiesUtil.isOgroid(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 2: {
                        if (!EntitiesUtil.isSpecter(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 3: {
                        if (!EntitiesUtil.isVampire(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 4: {
                        if (!EntitiesUtil.isInsectoid(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 5: {
                        if (!EntitiesUtil.isBeast(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 6: {
                        if (!EntitiesUtil.isElementa(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 7: {
                        if (!EntitiesUtil.isCursedOne(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 8: {
                        if (!EntitiesUtil.isHybrid(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 9: {
                        if (!EntitiesUtil.isDraconid(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 10: {
                        if (!EntitiesUtil.isRelict(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                    case 11: {
                        if (!EntitiesUtil.isHumanoid(livingTarget)) break;
                        this.LevelOilAssigner(monsterOil);
                        break;
                    }
                }
                this.OilUsesManager(this.THIS, monsterOil);
            }
        }
    }

    @Unique
    private void LevelOilAssigner(MonsterOilComponent monsterOil) {
        switch (monsterOil.level()) {
            case 1: {
                this.oilDamageAdded = 2.0f;
                break;
            }
            case 2: {
                this.oilDamageAdded = 4.0f;
                break;
            }
            case 3: {
                this.oilDamageAdded = 6.0f;
                break;
            }
        }
    }

    @Unique
    private void OilUsesManager(class_1657 player, MonsterOilComponent monsterOil) {
        class_1799 weapon = player.method_6047();
        MonsterOilComponent newMonsterOil = MonsterOilComponent.decreaseUse(monsterOil);
        weapon.method_57379(TCOTS_Items.MonsterOilComponent(), (Object)newMonsterOil);
        if (newMonsterOil.uses() == 0) {
            weapon.method_57381(TCOTS_Items.MonsterOilComponent());
            player.method_37908().method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), TCOTS_Sounds.getSoundEvent("oil_ran_out"), player.method_5634(), 1.0f, 1.0f);
        }
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=1, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)))
    private float injectMonsterOilAttack(float value, @Local(argsOnly=true) class_1297 target) {
        return value + this.oilDamageAdded;
    }

    @Inject(method={"attack"}, at={@At(value="TAIL")})
    private void ResetMultiplier(class_1297 target, CallbackInfo ci) {
        this.oilDamageAdded = 0.0f;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=2)
    private boolean injectCriticalWithSamum(boolean value, @Local(argsOnly=true) class_1297 target) {
        class_1309 entity;
        if (target instanceof class_1309 && SamumBomb.checkSamumEffect(entity = (class_1309)target)) {
            class_1293 instance = entity.method_6112(TCOTS_Effects.SamumEffect());
            assert (instance != null);
            int amplifier = instance.method_5578();
            return value || amplifier > 1;
        }
        return value;
    }

    @ModifyConstant(method={"attack"}, constant={@Constant(floatValue=1.5f)})
    private float injectExtraCriticalWolf(float value) {
        if (this.method_6059(TCOTS_Effects.WolfEffect())) {
            int amplifier = Objects.requireNonNull(this.method_6112(TCOTS_Effects.WolfEffect())).method_5578();
            return value + (0.5f + (float)amplifier * 0.5f);
        }
        return value;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=1, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)))
    private float addExtraSwordDamageRook(float value) {
        if (this.method_6047().method_7909() instanceof class_1829 && this.method_6059(TCOTS_Effects.RookEffect())) {
            int amplifier = Objects.requireNonNull(this.method_6112(TCOTS_Effects.RookEffect())).method_5578();
            return value + (float)(2 + amplifier);
        }
        return value;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=1, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)))
    private float injectRavenBonusToDamage(float value, @Local(argsOnly=true) class_1297 target) {
        class_1309 livingTarget;
        return value + (EntitiesUtil.isWearingRavensArmor((class_1309)this.THIS) && target instanceof class_1309 && EntitiesUtil.isMonster(livingTarget = (class_1309)target) ? 2.0f : 0.0f);
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", ordinal=0))
    private float injectMoonBladeDamage(float value, @Local(argsOnly=true) class_1297 target) {
        class_1309 livingTarget;
        return value * (this.THIS.method_6047().method_7909() == TCOTS_Items.MOONBLADE.get() && target instanceof class_1309 && EntitiesUtil.isMonster(livingTarget = (class_1309)target) ? 1.0f + MiscUtil.moonblade_bonus : 1.0f);
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", ordinal=0))
    private float injectMoonBladeDamageSweep(float value, @Local(argsOnly=true) class_1297 target) {
        class_1309 livingTarget;
        return value * (this.THIS.method_6047().method_7909() == TCOTS_Items.MOONBLADE.get() && target instanceof class_1309 && EntitiesUtil.isMonster(livingTarget = (class_1309)target) ? 1.1f : 1.0f);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=1, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)))
    private float injectWintersBladeDamage(float value, @Local(argsOnly=true) class_1297 target) {
        class_1309 livingTarget;
        return value + (this.THIS.method_6047().method_7909() == TCOTS_Items.WINTERS_BLADE.get() && target instanceof class_1309 && (livingTarget = (class_1309)target).method_5864().method_20210(class_3483.field_29826) ? 2.0f : 0.0f);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void injectMudTicks(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(MUD_TICKS, (Object)0);
    }

    @Shadow
    public abstract void method_5783(@NotNull class_3414 var1, float var2, float var3);

    @Shadow
    @NotNull
    public abstract class_1306 method_6068();

    @Override
    public int theConjunctionOfTheSpheres$getMudInFace() {
        return (Integer)this.field_6011.method_12789(MUD_TICKS);
    }

    @Override
    public void theConjunctionOfTheSpheres$setMudInFace(int ticks) {
        this.field_6011.method_12778(MUD_TICKS, (Object)ticks);
    }

    @Override
    public float theConjunctionOfTheSpheres$getMudTransparency() {
        return (float)this.theConjunctionOfTheSpheres$getMudInFace() / 100.0f;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void injectInTickMud(CallbackInfo ci) {
        if (this.theConjunctionOfTheSpheres$getMudInFace() > 0 && this.method_5721()) {
            this.theConjunctionOfTheSpheres$setMudInFace(this.theConjunctionOfTheSpheres$getMudInFace() - 10);
        } else if (this.theConjunctionOfTheSpheres$getMudInFace() > 0) {
            this.theConjunctionOfTheSpheres$setMudInFace(this.theConjunctionOfTheSpheres$getMudInFace() - 1);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectReadNBTMud(class_2487 nbt, CallbackInfo ci) {
        this.theConjunctionOfTheSpheres$setMudInFace(nbt.method_10550("MudTicks"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectWriteNBTMud(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("MudTicks", this.theConjunctionOfTheSpheres$getMudInFace());
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="TAIL")})
    private void injectPotionRefilling(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        boolean refilled = false;
        block0: for (WitcherAlcohol_Base alcoholBase : this.list_alcohol) {
            if (this.field_7514.method_7395(alcoholBase.method_7854()) == -1 || refilled || this.potionTimer <= 90) continue;
            int loopP = EntitiesUtil.isWearingManticoreArmor((class_1309)this.THIS) ? alcoholBase.getRefillQuantity() + 2 : alcoholBase.getRefillQuantity();
            int slot = this.field_7514.method_7395(alcoholBase.method_7854());
            for (int i = 0; i < this.field_7514.method_5439(); ++i) {
                String refillItem;
                if (this.field_7514.method_5438(i).method_7909() instanceof EmptyWitcherPotionItem && this.field_7514.method_5438(i).method_57826(TCOTS_Items.RefillRecipe()) && (refillItem = (String)this.field_7514.method_5438(i).method_57824(TCOTS_Items.RefillRecipe())) != null) {
                    class_1792 PotionI = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)refillItem));
                    int countI = this.field_7514.method_5438(i).method_7947();
                    this.field_7514.method_5438(i).method_7934(this.field_7514.method_5438(i).method_7947());
                    this.field_7514.method_5447(i, new class_1799((class_1935)PotionI, countI));
                    refilled = true;
                    if (--loopP < 1) {
                        this.field_7514.method_5438(slot).method_7934(1);
                        class_1657 class_16572 = this.THIS;
                        if (class_16572 instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)class_16572;
                            TCOTS_Criteria.RefillConcoction().trigger(serverPlayer);
                        }
                        this.method_5783(TCOTS_Sounds.getSoundEvent("potion_refill"), 3.0f, 1.0f);
                        continue block0;
                    }
                }
                if (i != this.field_7514.method_5439() - 1 || !refilled) continue;
                this.field_7514.method_5438(slot).method_7934(1);
                class_1657 class_16573 = this.THIS;
                if (class_16573 instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)class_16573;
                    TCOTS_Criteria.RefillConcoction().trigger(serverPlayer);
                }
                this.method_5783(TCOTS_Sounds.getSoundEvent("potion_refill"), 3.0f, 1.0f);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void injectInTickSleepingPotion(CallbackInfo ci) {
        if (this.method_6113()) {
            if (this.potionTimer < 100) {
                ++this.potionTimer;
            }
        } else if (this.potionTimer != 0) {
            this.potionTimer = 0;
        }
    }

    @Inject(method={"eat"}, at={@At(value="TAIL")})
    private void injectMariborForestImprove(class_1937 world, class_1799 stack, class_4174 foodComponent, CallbackInfoReturnable<class_1799> cir) {
        class_1657 THIS = (class_1657)this;
        if (this.method_6059(TCOTS_Effects.MariborForestEffect())) {
            int amplifier = Objects.requireNonNull(this.method_6112(TCOTS_Effects.MariborForestEffect())).method_5578();
            if (stack.method_57826(class_9334.field_50075)) {
                assert (foodComponent != null);
                int foodQuantity = (int)((float)foodComponent.comp_2491() * (0.25f + 0.25f * (float)amplifier));
                float saturationQuantity = foodComponent.comp_2492() * (0.25f + 0.25f * (float)amplifier);
                if (foodQuantity < 1) {
                    foodQuantity = 1;
                }
                if ((double)saturationQuantity < 0.1) {
                    saturationQuantity = 0.1f;
                }
                THIS.method_7344().method_7585(foodQuantity, saturationQuantity);
            }
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void injectToxicityDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(TOXICITY, (Object)0);
        builder.method_56912(DECOCTION_TOXICITY, (Object)0);
        builder.method_56912(HUD_ACTIVE, (Object)false);
        builder.method_56912(HUD_TRANSPARENCY, (Object)Float.valueOf(0.0f));
    }

    @Override
    public int theConjunctionOfTheSpheres$getNormalToxicity() {
        return (Integer)this.field_6011.method_12789(TOXICITY);
    }

    @Override
    public void theConjunctionOfTheSpheres$setToxicity(int toxicity) {
        this.field_6011.method_12778(TOXICITY, (Object)toxicity);
    }

    @Override
    public int theConjunctionOfTheSpheres$getMaxToxicity() {
        return (int)this.THIS.method_45325(TCOTS_EntityAttributes.GENERIC_WITCHER_MAX_TOXICITY);
    }

    @Override
    public int theConjunctionOfTheSpheres$getDecoctionToxicity() {
        return (Integer)this.field_6011.method_12789(DECOCTION_TOXICITY);
    }

    @Override
    public void theConjunctionOfTheSpheres$setDecoctionToxicity(int DecoctionToxicity) {
        this.field_6011.method_12778(DECOCTION_TOXICITY, (Object)DecoctionToxicity);
    }

    @Override
    public void theConjunctionOfTheSpheres$addToxicity(int toxicity, boolean decoction) {
        if (decoction) {
            this.theConjunctionOfTheSpheres$setDecoctionToxicity(this.theConjunctionOfTheSpheres$getDecoctionToxicity() + toxicity);
        } else {
            this.theConjunctionOfTheSpheres$setToxicity(this.theConjunctionOfTheSpheres$getNormalToxicity() + toxicity);
        }
    }

    @Override
    public void theConjunctionOfTheSpheres$decreaseToxicity(int toxicity, boolean decoction) {
        if (decoction) {
            this.theConjunctionOfTheSpheres$setDecoctionToxicity(this.theConjunctionOfTheSpheres$getDecoctionToxicity() - toxicity);
        } else {
            this.theConjunctionOfTheSpheres$setToxicity(this.theConjunctionOfTheSpheres$getNormalToxicity() - toxicity);
        }
    }

    @Override
    public int theConjunctionOfTheSpheres$getAllToxicity() {
        return (Integer)this.field_6011.method_12789(DECOCTION_TOXICITY) + (Integer)this.field_6011.method_12789(TOXICITY);
    }

    @Override
    public boolean theConjunctionOfTheSpheres$toxicityOverThreshold() {
        float overdoseThreshold = (float)this.theConjunctionOfTheSpheres$getMaxToxicity() * 0.75f;
        return (float)this.theConjunctionOfTheSpheres$getAllToxicity() > overdoseThreshold;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectReadNBTToxicity(class_2487 nbt, CallbackInfo ci) {
        this.theConjunctionOfTheSpheres$setToxicity(nbt.method_10550("Toxicity"));
        this.theConjunctionOfTheSpheres$setDecoctionToxicity(nbt.method_10550("DecoctionToxicity"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectWriteNBTToxicity(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("Toxicity", this.theConjunctionOfTheSpheres$getNormalToxicity());
        nbt.method_10569("DecoctionToxicity", this.theConjunctionOfTheSpheres$getDecoctionToxicity());
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void injectInTickDecreaseToxicityIfOverMaximum(CallbackInfo ci) {
        if (this.theConjunctionOfTheSpheres$getAllToxicity() > this.theConjunctionOfTheSpheres$getMaxToxicity()) {
            this.THIS.theConjunctionOfTheSpheres$setToxicity(class_3532.method_15340((int)this.THIS.theConjunctionOfTheSpheres$getNormalToxicity(), (int)0, (int)(this.THIS.theConjunctionOfTheSpheres$getMaxToxicity() - this.THIS.theConjunctionOfTheSpheres$getDecoctionToxicity())));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void injectInTickDecreaseToxicity(CallbackInfo ci) {
        if (this.theConjunctionOfTheSpheres$getNormalToxicity() > 0 && this.field_6012 % 40 == 0) {
            this.theConjunctionOfTheSpheres$decreaseToxicity(1, false);
        }
        float dangerOverdoseThreshold = (float)this.theConjunctionOfTheSpheres$getMaxToxicity() * 0.9f;
        if (this.theConjunctionOfTheSpheres$toxicityOverThreshold()) {
            int damageableTicks = (int)(30.0f * ((float)this.theConjunctionOfTheSpheres$getMaxToxicity() / (float)this.theConjunctionOfTheSpheres$getAllToxicity()));
            if ((float)this.theConjunctionOfTheSpheres$getAllToxicity() > dangerOverdoseThreshold) {
                damageableTicks = (int)(10.0f * ((float)this.theConjunctionOfTheSpheres$getMaxToxicity() / (float)this.theConjunctionOfTheSpheres$getAllToxicity()));
            }
            if (this.field_6012 % damageableTicks == 0) {
                this.method_5643(TCOTS_DamageTypes.toxicityDamage(this.method_37908()), this.THIS.method_6063() * 0.05f);
            }
        }
    }

    @Override
    public boolean theConjunctionOfTheSpheres$getWitcherEyesActivated() {
        return (Boolean)this.field_6011.method_12789(EYES_ACTIVATE);
    }

    @Override
    public void theConjunctionOfTheSpheres$setWitcherEyesActivated(boolean activate) {
        this.field_6011.method_12778(EYES_ACTIVATE, (Object)activate);
    }

    @Override
    public boolean theConjunctionOfTheSpheres$getToxicityActivated() {
        return (Boolean)this.field_6011.method_12789(TOXICITY_ACTIVATE);
    }

    @Override
    public void theConjunctionOfTheSpheres$setToxicityActivated(boolean activate) {
        this.field_6011.method_12778(TOXICITY_ACTIVATE, (Object)activate);
    }

    @Override
    public Vector3f theConjunctionOfTheSpheres$getEyesPivot() {
        return (Vector3f)this.field_6011.method_12789(EYES_POSITION);
    }

    @Override
    public void theConjunctionOfTheSpheres$setEyesPivot(Vector3f vector3f) {
        this.field_6011.method_12778(EYES_POSITION, (Object)vector3f);
    }

    @Override
    public int theConjunctionOfTheSpheres$getEyeSeparation() {
        return (Integer)this.field_6011.method_12789(EYES_SEPARATION);
    }

    @Override
    public void theConjunctionOfTheSpheres$setEyeSeparation(int separation) {
        this.field_6011.method_12778(EYES_SEPARATION, (Object)separation);
    }

    @Override
    public int theConjunctionOfTheSpheres$getEyeShape() {
        return (Integer)this.field_6011.method_12789(EYES_SHAPE);
    }

    @Override
    public void theConjunctionOfTheSpheres$setEyeShape(int shape) {
        this.field_6011.method_12778(EYES_SHAPE, (Object)shape);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void injectWitcherEyesData(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(EYES_ACTIVATE, (Object)false);
        builder.method_56912(EYES_POSITION, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        builder.method_56912(EYES_SEPARATION, (Object)2);
        builder.method_56912(EYES_SHAPE, (Object)0);
        builder.method_56912(TOXICITY_ACTIVATE, (Object)false);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectReadNBTWitcherEyes(class_2487 nbt, CallbackInfo ci) {
        class_2487 nbtToxicity;
        class_2487 nbtEyes = PlayerEntityMixin.getSubNbt("WitcherEyes", nbt);
        if (nbtEyes != null) {
            this.theConjunctionOfTheSpheres$setWitcherEyesActivated(nbtEyes.method_10577("Activated"));
            this.theConjunctionOfTheSpheres$setEyesPivot(new Vector3f(nbtEyes.method_10583("EyesX"), nbtEyes.method_10583("EyesY"), 0.0f));
            this.theConjunctionOfTheSpheres$setEyeSeparation(nbtEyes.method_10550("EyesSeparation"));
            this.theConjunctionOfTheSpheres$setEyeShape(nbtEyes.method_10550("EyesShape"));
        }
        if ((nbtToxicity = PlayerEntityMixin.getSubNbt("ToxicityFace", nbt)) != null) {
            this.theConjunctionOfTheSpheres$setToxicityActivated(nbtToxicity.method_10577("Activated"));
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectWriteNBTWitcherEyes(class_2487 nbt, CallbackInfo ci) {
        class_2487 nbtEyes = new class_2487();
        nbtEyes.method_10556("Activated", this.theConjunctionOfTheSpheres$getWitcherEyesActivated());
        nbtEyes.method_10548("EyesX", this.theConjunctionOfTheSpheres$getEyesPivot().x);
        nbtEyes.method_10548("EyesY", this.theConjunctionOfTheSpheres$getEyesPivot().y);
        nbtEyes.method_10569("EyesSeparation", this.theConjunctionOfTheSpheres$getEyeSeparation());
        nbtEyes.method_10569("EyesShape", this.theConjunctionOfTheSpheres$getEyeShape());
        nbt.method_10566("WitcherEyes", (class_2520)nbtEyes);
        class_2487 nbtToxicity = new class_2487();
        nbtToxicity.method_10556("Activated", this.theConjunctionOfTheSpheres$getToxicityActivated());
        nbt.method_10566("ToxicityFace", (class_2520)nbtToxicity);
    }

    @Unique
    @Nullable
    private static class_2487 getSubNbt(String key, class_2487 compound) {
        if (compound == null || !compound.method_10573(key, 10)) {
            return null;
        }
        return compound.method_10562(key);
    }
}

