/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.screen.recipebook;

import TCOTS.recipes.AlchemyTableRecipe;
import TCOTS.recipes.AlchemyTableRecipeCategory;
import TCOTS.screen.AlchemyTableScreenHandler;
import TCOTS.screen.recipebook.AlchemyRecipeBookButtonPage;
import TCOTS.screen.recipebook.AlchemyRecipeResultButton;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3439;
import net.minecraft.class_361;
import net.minecraft.class_508;
import net.minecraft.class_8666;
import net.minecraft.class_8786;

public class AlchemyRecipeBookResults {
    private final List<AlchemyRecipeResultButton> resultButtons = Lists.newArrayListWithCapacity((int)5);
    private final List<class_8786<AlchemyTableRecipe>> listFittingRecipes = new ArrayList<class_8786<AlchemyTableRecipe>>();
    private final List<class_8786<AlchemyTableRecipe>> listRecipesPotions = new ArrayList<class_8786<AlchemyTableRecipe>>();
    private final List<class_8786<AlchemyTableRecipe>> listRecipesBombs = new ArrayList<class_8786<AlchemyTableRecipe>>();
    private final List<class_8786<AlchemyTableRecipe>> listRecipesDecoctions = new ArrayList<class_8786<AlchemyTableRecipe>>();
    private final List<class_8786<AlchemyTableRecipe>> listRecipesMisc = new ArrayList<class_8786<AlchemyTableRecipe>>();
    private final List<class_8786<AlchemyTableRecipe>> Active_listRecipes = new ArrayList<class_8786<AlchemyTableRecipe>>();
    private final class_1662 recipeFinder = new class_1662();
    private final class_508 alternatesWidget = new class_508();
    private class_310 client;
    private class_361 nextPageButton;
    public static final class_8666 TEXTURES_RIGHT_PAGE = new class_8666(class_2960.method_60655((String)"tcots_witcher", (String)"buttons/page_right"), class_2960.method_60655((String)"tcots_witcher", (String)"buttons/page_right_highlighted"));
    public static final class_8666 TEXTURES_LEFT_PAGE = new class_8666(class_2960.method_60655((String)"tcots_witcher", (String)"buttons/page_left"), class_2960.method_60655((String)"tcots_witcher", (String)"buttons/page_left_highlighted"));
    private class_361 prevPageButton;
    private int pageCount;
    public int currentPage;
    public class_2371<class_1799> PlayerInventoryItems;
    public List<class_1799> TotalInventoryItems = new ArrayList<class_1799>();
    public List<class_1799> AlchemyTableInventoryItems = new ArrayList<class_1799>();
    protected AlchemyTableScreenHandler craftingScreenHandler;
    private class_299 recipeBook;
    class_8786<AlchemyTableRecipe> recipe;

    public AlchemyRecipeBookResults() {
        for (int i = 0; i < 6; ++i) {
            this.resultButtons.add(new AlchemyRecipeResultButton());
        }
    }

    public void initialize(class_310 client, int parentI, int parentJ, AlchemyTableScreenHandler craftingScreenHandler) {
        this.client = client;
        this.craftingScreenHandler = craftingScreenHandler;
        assert (this.client.field_1724 != null);
        this.PlayerInventoryItems = this.client.field_1724.method_31548().field_7547;
        this.AlchemyTableInventoryItems = craftingScreenHandler.inputInventory.method_54454();
        this.TotalInventoryItems.addAll((Collection<class_1799>)this.PlayerInventoryItems);
        this.TotalInventoryItems.addAll(this.AlchemyTableInventoryItems);
        this.recipeFinder.method_7409();
        for (class_1799 stack : this.TotalInventoryItems) {
            this.recipeFinder.method_20478(stack, stack.method_7947());
        }
        for (int i = 0; i < this.resultButtons.size(); ++i) {
            this.resultButtons.get(i).method_48229(parentI + 14, parentJ + 26 + i * 23);
        }
        this.nextPageButton = new AlchemyRecipeBookButtonPage(parentI + 100, parentJ + 166, 18, 10, false);
        this.nextPageButton.method_1962(TEXTURES_RIGHT_PAGE);
        this.prevPageButton = new AlchemyRecipeBookButtonPage(parentI + 30, parentJ + 166, 18, 10, true);
        this.prevPageButton.method_1962(TEXTURES_LEFT_PAGE);
    }

    public void setResults(boolean resetCurrentPage, AlchemyTableRecipeCategory category) {
        if (resetCurrentPage) {
            this.currentPage = 0;
        }
        this.refreshResultButtons(category);
        this.resetPageCount(resetCurrentPage);
    }

    public void updateCanCraft() {
        assert (this.client.field_1724 != null);
        this.AlchemyTableInventoryItems = this.craftingScreenHandler.inputInventory.method_54454();
        this.PlayerInventoryItems = this.client.field_1724.method_31548().field_7547;
        this.TotalInventoryItems.clear();
        this.TotalInventoryItems.addAll((Collection<class_1799>)this.PlayerInventoryItems);
        this.TotalInventoryItems.addAll(this.AlchemyTableInventoryItems);
        this.recipeFinder.method_7409();
        for (class_1799 stack : this.TotalInventoryItems) {
            this.recipeFinder.method_20478(stack, stack.method_7947());
        }
        for (AlchemyRecipeResultButton button : this.resultButtons) {
            int ItemId;
            int i;
            button.setCraftable(false);
            if (button.getRecipe() == null) continue;
            if (this.recipeFinder.method_7402((class_1860)button.getRecipe(), null)) {
                for (i = 0; i < button.getRecipe().method_8117().size(); ++i) {
                    ItemId = class_1792.method_7880((class_1792)((class_1856)button.getRecipe().method_8117().get(i)).method_8105()[0].method_7909());
                    if (this.recipeFinder.field_7550.get(ItemId) >= button.getRecipe().getIngredientsCounts().get(i)) {
                        if (this.recipeFinder.field_7550.get(class_1792.method_7880((class_1792)button.getRecipe().getBaseItem().method_7909())) < 1) continue;
                        button.setCraftable(true);
                        continue;
                    }
                    button.setCraftable(false);
                    break;
                }
            } else {
                button.setCraftable(false);
            }
            button.setBaseNotPresent(this.recipeFinder.field_7550.get(class_1792.method_7880((class_1792)button.getRecipe().getBaseItem().method_7909())) >= button.getRecipe().getBaseItem().method_7947());
            button.textColorBase = this.recipeFinder.field_7550.get(class_1792.method_7880((class_1792)button.getRecipe().getBaseItem().method_7909())) >= button.getRecipe().getBaseItem().method_7947() ? 0xFFFFFF : 11812140;
            for (i = 0; i < button.getRecipe().method_8117().size(); ++i) {
                ItemId = class_1792.method_7880((class_1792)((class_1856)button.getRecipe().method_8117().get(i)).method_8105()[0].method_7909());
                button.setTextColor(i, this.recipeFinder.field_7550.get(ItemId) >= button.getRecipe().getIngredientsCounts().get(i));
            }
        }
    }

    private void resetPageCount(boolean resetCurrentPage) {
        this.pageCount = (int)Math.ceil((double)this.Active_listRecipes.size() / 6.0);
        if (this.pageCount <= this.currentPage || resetCurrentPage) {
            this.currentPage = 0;
        }
    }

    public void receiveRecipesList(List<class_8786<AlchemyTableRecipe>> listRecipes, class_299 recipeBook) {
        if (this.listFittingRecipes.isEmpty()) {
            this.recipeBook = recipeBook;
            this.listFittingRecipes.addAll(listRecipes);
            for (int i = 0; i < 6; ++i) {
                this.resultButtons.get(i).receiveTextRenderer(this.client.field_1772);
            }
            this.listFittingRecipes.forEach(recipe -> {
                if (((AlchemyTableRecipe)recipe.comp_1933()).getCategory() == AlchemyTableRecipeCategory.POTIONS) {
                    this.listRecipesPotions.add((class_8786<AlchemyTableRecipe>)recipe);
                }
                if (((AlchemyTableRecipe)recipe.comp_1933()).getCategory() == AlchemyTableRecipeCategory.DECOCTIONS) {
                    this.listRecipesDecoctions.add((class_8786<AlchemyTableRecipe>)recipe);
                }
                if (((AlchemyTableRecipe)recipe.comp_1933()).getCategory() == AlchemyTableRecipeCategory.BOMBS_OILS) {
                    this.listRecipesBombs.add((class_8786<AlchemyTableRecipe>)recipe);
                }
                if (((AlchemyTableRecipe)recipe.comp_1933()).getCategory() == AlchemyTableRecipeCategory.MISC) {
                    this.listRecipesMisc.add((class_8786<AlchemyTableRecipe>)recipe);
                }
            });
            this.Active_listRecipes.clear();
            this.Active_listRecipes.addAll(this.listRecipesPotions);
            this.Active_listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
            this.resetPageCount(false);
        }
    }

    public void draw(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
        if (this.pageCount > 1) {
            String string = this.currentPage + 1 + "/" + this.pageCount;
            int i = this.client.field_1772.method_1727(string);
            context.method_51433(this.client.field_1772, string, x - i / 2 + 73, y + 166, 0xFFFFFF, true);
        }
        for (AlchemyRecipeResultButton animatedResultButton : this.resultButtons) {
            animatedResultButton.method_25394(context, mouseX, mouseY, delta);
        }
        this.prevPageButton.method_25394(context, mouseX, mouseY, delta);
        this.nextPageButton.method_25394(context, mouseX, mouseY, delta);
        this.alternatesWidget.method_25394(context, mouseX, mouseY, delta);
    }

    protected void forEachButton(Consumer<class_339> consumer) {
        consumer.accept((class_339)this.nextPageButton);
        consumer.accept((class_339)this.prevPageButton);
        this.resultButtons.forEach(consumer);
    }

    public void refreshResultButtons(AlchemyTableRecipeCategory category) {
        this.resultButtons.forEach(button -> button.receiveRecipe(null, (class_3439)this.recipeBook));
        int b = 0;
        switch (category) {
            case POTIONS: {
                for (int j = 6 * this.currentPage; j < this.listRecipesPotions.size(); ++j) {
                    if (b == 6) {
                        this.Active_listRecipes.clear();
                        this.Active_listRecipes.addAll(this.listRecipesPotions);
                        this.Active_listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
                        break;
                    }
                    this.resultButtons.get(b).receiveRecipe(this.listRecipesPotions.get(j), (class_3439)this.recipeBook);
                    ++b;
                }
                this.Active_listRecipes.clear();
                this.Active_listRecipes.addAll(this.listRecipesPotions);
                this.Active_listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
                break;
            }
            case DECOCTIONS: {
                for (int j = 6 * this.currentPage; j < this.listRecipesDecoctions.size(); ++j) {
                    if (b == 6) {
                        this.Active_listRecipes.clear();
                        this.Active_listRecipes.addAll(this.listRecipesDecoctions);
                        this.Active_listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
                        break;
                    }
                    this.resultButtons.get(b).receiveRecipe(this.listRecipesDecoctions.get(j), (class_3439)this.recipeBook);
                    ++b;
                }
                this.Active_listRecipes.clear();
                this.Active_listRecipes.addAll(this.listRecipesDecoctions);
                this.Active_listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
                break;
            }
            case BOMBS_OILS: {
                for (int j = 6 * this.currentPage; j < this.listRecipesBombs.size(); ++j) {
                    if (b == 6) {
                        this.Active_listRecipes.clear();
                        this.Active_listRecipes.addAll(this.listRecipesBombs);
                        this.Active_listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
                        break;
                    }
                    this.resultButtons.get(b).receiveRecipe(this.listRecipesBombs.get(j), (class_3439)this.recipeBook);
                    ++b;
                }
                this.Active_listRecipes.clear();
                this.Active_listRecipes.addAll(this.listRecipesBombs);
                this.Active_listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
                break;
            }
            case MISC: {
                for (int j = 6 * this.currentPage; j < this.listRecipesMisc.size(); ++j) {
                    if (b == 6) {
                        this.Active_listRecipes.clear();
                        this.Active_listRecipes.addAll(this.listRecipesMisc);
                        this.Active_listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
                        break;
                    }
                    this.resultButtons.get(b).receiveRecipe(this.listRecipesMisc.get(j), (class_3439)this.recipeBook);
                    ++b;
                }
                this.Active_listRecipes.clear();
                this.Active_listRecipes.addAll(this.listRecipesMisc);
                this.Active_listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
            }
        }
        this.resetPageCount(false);
        this.hideShowPageButtons();
        this.updateCanCraft();
    }

    private void hideShowPageButtons() {
        this.nextPageButton.field_22764 = this.pageCount > 1 && this.currentPage < this.pageCount - 1;
        this.prevPageButton.field_22764 = this.pageCount > 1 && this.currentPage > 0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, AlchemyTableRecipeCategory category) {
        if (this.nextPageButton.method_25402(mouseX, mouseY, button)) {
            this.recipe = null;
            ++this.currentPage;
            this.refreshResultButtons(category);
            return true;
        }
        if (this.prevPageButton.method_25402(mouseX, mouseY, button)) {
            this.recipe = null;
            --this.currentPage;
            this.refreshResultButtons(category);
            return true;
        }
        for (AlchemyRecipeResultButton resultButton : this.resultButtons) {
            if (!resultButton.method_25402(mouseX, mouseY, button) || !resultButton.getCraftable() || resultButton.getRecipeEntry() == null) continue;
            this.recipe = resultButton.getRecipeEntry();
            return true;
        }
        return false;
    }

    public class_310 getClient() {
        return this.client;
    }
}

