/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.screen.recipebook;

import TCOTS.items.concoctions.WitcherAlcohol_Base;
import TCOTS.recipes.AlchemyTableRecipe;
import TCOTS.recipes.AlchemyTableRecipeCategory;
import TCOTS.registry.TCOTS_Items;
import TCOTS.screen.AlchemyTableScreenHandler;
import TCOTS.screen.recipebook.AlchemyRecipeBookResults;
import TCOTS.screen.recipebook.AlchemyRecipeGroupButton;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2952;
import net.minecraft.class_2960;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_314;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_515;
import net.minecraft.class_516;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyRecipeBookWidget
implements class_2952<class_1856>,
class_4068,
class_364,
class_6379,
class_515 {
    public static final class_2960 RECIPE_GUI_TEXTURE = class_2960.method_60655((String)"tcots_witcher", (String)"textures/gui/alchemy_recipe_book.png");
    private class_299 recipeBook;
    private final List<class_8786<AlchemyTableRecipe>> listRecipes = new ArrayList<class_8786<AlchemyTableRecipe>>();
    private boolean open = false;
    private boolean narrow;
    private int leftOffset;
    private final AlchemyRecipeBookResults recipesArea = new AlchemyRecipeBookResults();
    private final List<AlchemyRecipeGroupButton> tabButtons = Lists.newArrayList();
    @Nullable
    private AlchemyRecipeGroupButton currentTab;
    private int parentWidth;
    private int parentHeight;
    private boolean searching;
    protected class_310 client;
    private class_327 parenttextRenderer;
    private int cachedInvChangeCount;
    private int cachedInvBlockChangeCount;
    protected AlchemyTableScreenHandler craftingScreenHandler;

    public void update() {
        if (!this.isOpen()) {
            return;
        }
        assert (this.client.field_1724 != null);
        if (this.cachedInvChangeCount != this.client.field_1724.method_31548().method_7364()) {
            this.recipesArea.updateCanCraft();
            this.cachedInvChangeCount = this.client.field_1724.method_31548().method_7364();
        }
    }

    public void init(int height, int width, class_327 parenttextRenderer, class_310 client, AlchemyTableScreenHandler craftingScreenHandler) {
        this.narrow = width < 379;
        this.parentWidth = width;
        this.parentHeight = height;
        this.craftingScreenHandler = craftingScreenHandler;
        this.parenttextRenderer = parenttextRenderer;
        this.client = client;
        assert (this.client.field_1724 != null);
        this.cachedInvChangeCount = client.field_1724.method_31548().method_7364();
        assert (this.client.field_1724 != null);
        this.recipeBook = this.client.field_1724.method_3130();
        if (this.listRecipes.isEmpty()) {
            assert (this.client.field_1724 != null);
            List list = this.recipeBook.method_1396(class_314.field_25625);
            for (class_516 resultCollection : list) {
                class_1860 class_18602 = ((class_8786)resultCollection.method_2650().get(0)).comp_1933();
                if (!(class_18602 instanceof AlchemyTableRecipe)) continue;
                AlchemyTableRecipe recipe = (AlchemyTableRecipe)class_18602;
                this.listRecipes.add((class_8786<AlchemyTableRecipe>)((class_8786)resultCollection.method_2650().get(0)));
            }
        }
        if (this.open) {
            this.reset();
        }
    }

    public int findLeftEdge(int width, int backgroundWidth) {
        return this.isOpen() && !this.narrow ? 177 + (width - backgroundWidth - 200) / 2 : (width - backgroundWidth) / 2;
    }

    public void toggleOpen() {
        this.setOpen(!this.isOpen());
    }

    public boolean isOpen() {
        return this.open;
    }

    public void drawBackground(class_332 context, float delta, int mouseX, int mouseY) {
        this.leftOffset = this.narrow ? 0 : 86;
    }

    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.open) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        int i = (this.parentWidth - 147) / 2 - this.leftOffset;
        int j = (this.parentHeight - 189) / 2;
        int color = 3756070;
        switch (Objects.requireNonNull(this.currentTab).getCategory()) {
            case POTIONS: {
                context.method_51439(this.parenttextRenderer, (class_2561)class_2561.method_43471((String)"gui.recipe-book.category.potions"), i + 18, j + 15, color, false);
                break;
            }
            case DECOCTIONS: {
                context.method_51439(this.parenttextRenderer, (class_2561)class_2561.method_43471((String)"gui.recipe-book.category.decoctions"), i + 18, j + 15, color, false);
                break;
            }
            case BOMBS_OILS: {
                context.method_51439(this.parenttextRenderer, (class_2561)class_2561.method_43471((String)"gui.recipe-book.category.bombs_oils"), i + 18, j + 15, color, false);
                break;
            }
            case MISC: {
                context.method_51439(this.parenttextRenderer, (class_2561)class_2561.method_43471((String)"gui.recipe-book.category.misc"), i + 18, j + 15, color, false);
                break;
            }
        }
        for (AlchemyRecipeGroupButton recipeGroupButtonWidget : this.tabButtons) {
            recipeGroupButtonWidget.method_25394(context, mouseX, mouseY, delta);
        }
        context.method_51448().method_22909();
        this.renderRecipeBookBackground(context, this.parentWidth, this.parentHeight, i, j);
        this.recipesArea.draw(context, i, j, mouseX, mouseY, delta);
    }

    public void renderRecipeBookBackground(class_332 context, int width, int height, int i, int j) {
        if (this.open) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 0.0f);
            context.method_25290(RECIPE_GUI_TEXTURE, i, j, 1.0f, 1.0f, 147, 189, 256, 300);
            context.method_51448().method_22909();
        }
    }

    public void reset() {
        int i = (this.parentWidth - 147) / 2 - this.leftOffset;
        int j = (this.parentHeight - 189) / 2;
        if (this.tabButtons.isEmpty()) {
            this.tabButtons.add(0, new AlchemyRecipeGroupButton(((WitcherAlcohol_Base)((Object)TCOTS_Items.DWARVEN_SPIRIT.get())).method_7854(), AlchemyTableRecipeCategory.POTIONS));
            this.tabButtons.add(1, new AlchemyRecipeGroupButton(((class_1792)TCOTS_Items.GRAVE_HAG_DECOCTION.get()).method_7854(), AlchemyTableRecipeCategory.DECOCTIONS));
            this.tabButtons.add(2, new AlchemyRecipeGroupButton(((class_1792)TCOTS_Items.GRAPESHOT.get()).method_7854(), AlchemyTableRecipeCategory.BOMBS_OILS));
            this.tabButtons.add(3, new AlchemyRecipeGroupButton(((class_1792)TCOTS_Items.AETHER.get()).method_7854(), AlchemyTableRecipeCategory.MISC));
        }
        if (this.currentTab != null) {
            this.currentTab.method_1964(false);
        }
        this.currentTab = this.tabButtons.get(0);
        this.currentTab.method_1964(true);
        this.recipesArea.initialize(this.client, i, j, this.craftingScreenHandler);
        this.listRecipes.sort(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder())));
        this.recipesArea.receiveRecipesList(this.listRecipes, this.recipeBook);
        this.recipesArea.setResults(false, this.currentTab.getCategory());
        this.refreshTabButtons();
    }

    protected void setOpen(boolean opened) {
        if (opened) {
            this.reset();
        }
        this.open = opened;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isOpen() || Objects.requireNonNull(this.client.field_1724).method_7325()) {
            return false;
        }
        assert (this.currentTab != null);
        if (this.recipesArea.mouseClicked(mouseX, mouseY, button, this.currentTab.getCategory()) && this.recipesArea.recipe != null) {
            assert (this.client.field_1761 != null);
            this.client.field_1761.method_2912(this.client.field_1724.field_7512.field_7763, this.recipesArea.recipe, false);
        }
        if (this.tabButtons.get(0).method_25402(mouseX, mouseY, button)) {
            this.currentTab.method_1964(false);
            this.currentTab = this.tabButtons.get(0);
            this.currentTab.method_1964(true);
            this.recipesArea.setResults(true, this.currentTab.getCategory());
        }
        if (this.tabButtons.get(1).method_25402(mouseX, mouseY, button)) {
            this.currentTab.method_1964(false);
            this.currentTab = this.tabButtons.get(1);
            this.currentTab.method_1964(true);
            this.recipesArea.setResults(true, this.currentTab.getCategory());
        }
        if (this.tabButtons.get(2).method_25402(mouseX, mouseY, button)) {
            this.currentTab.method_1964(false);
            this.currentTab = this.tabButtons.get(2);
            this.currentTab.method_1964(true);
            this.recipesArea.setResults(true, this.currentTab.getCategory());
        }
        if (this.tabButtons.get(3).method_25402(mouseX, mouseY, button)) {
            this.currentTab.method_1964(false);
            this.currentTab = this.tabButtons.get(3);
            this.currentTab.method_1964(true);
            this.recipesArea.setResults(true, this.currentTab.getCategory());
        }
        for (AlchemyRecipeGroupButton recipeGroupButtonWidget : this.tabButtons) {
            if (!recipeGroupButtonWidget.method_25402(mouseX, mouseY, button)) continue;
            if (this.currentTab != recipeGroupButtonWidget) {
                if (this.currentTab != null) {
                    this.currentTab.method_1964(false);
                }
                this.currentTab = recipeGroupButtonWidget;
                this.currentTab.method_1964(true);
            }
            return true;
        }
        return false;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_6379.class_6380 method_37018() {
        return this.open ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 builder) {
        ArrayList list = Lists.newArrayList();
        this.recipesArea.forEachButton(button -> {
            if (button.method_37303()) {
                list.add(button);
            }
        });
        class_437.class_6390 selectedElementNarrationData = class_437.method_37061((List)list, null);
        if (selectedElementNarrationData != null) {
            selectedElementNarrationData.field_33825.method_37020(builder.method_37031());
        }
    }

    public void addItemToSlot(@NotNull class_1856 input, int slot, int amount, int gridX, int gridY) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.searching = false;
        if (!this.isOpen() || Objects.requireNonNull(this.client.field_1724).method_7325()) {
            return false;
        }
        if (keyCode == 256) {
            this.setOpen(false);
            return true;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        this.searching = false;
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    private void refreshTabButtons() {
        int i = (this.parentWidth - 147) / 2 - this.leftOffset - 32;
        int j = (this.parentHeight - 189) / 2 + 3;
        int l = 0;
        for (AlchemyRecipeGroupButton recipeGroupButtonWidget : this.tabButtons) {
            recipeGroupButtonWidget.method_48229(i, j + 14 + l++ * 28);
            recipeGroupButtonWidget.checkForNewRecipes(this.client);
        }
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searching) {
            return false;
        }
        if (!this.isOpen() || Objects.requireNonNull(this.client.field_1724).method_7325()) {
            return false;
        }
        return super.method_25400(chr, modifiers);
    }

    public void method_2646(@NotNull List<class_8786<?>> recipes) {
    }
}

