/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.utils;

import TCOTS.TCOTS_Main;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ChainDrawerUtil {
    private static final class_2960 TEXTURE = class_2960.method_60654((String)"textures/block/chain.png");

    public static void renderChain(class_1297 fromEntity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, class_1297 toEntity) {
        matrixStack.method_22903();
        double lerpBodyAngle = class_3532.method_16439((float)tickDelta, (float)fromEntity.field_5982, (float)fromEntity.method_43078()) * ((float)Math.PI / 180) + 1.5707964f;
        class_243 leashOffsetO = new class_243(0.0, 0.0, 0.0);
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffsetO.field_1350 + Math.sin(lerpBodyAngle) * leashOffsetO.field_1352;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffsetO.field_1350 - Math.cos(lerpBodyAngle) * leashOffsetO.field_1352;
        class_243 dstPos = toEntity.method_30951(tickDelta);
        class_243 leashOffset = ChainDrawerUtil.getLeashOffset(fromEntity);
        matrixStack.method_22904(xAngleOffset, leashOffset.field_1351, zAngleOffset);
        double lerpOriginX = class_3532.method_16436((double)tickDelta, (double)fromEntity.field_6014, (double)fromEntity.method_23317()) + xAngleOffset;
        double lerpOriginY = class_3532.method_16436((double)tickDelta, (double)fromEntity.field_6036, (double)fromEntity.method_23318()) + leashOffset.field_1351;
        double lerpOriginZ = class_3532.method_16436((double)tickDelta, (double)fromEntity.field_5969, (double)fromEntity.method_23321()) + zAngleOffset;
        float xDif = (float)(dstPos.field_1352 - lerpOriginX);
        float yDif = (float)(dstPos.field_1351 - lerpOriginY);
        float zDif = (float)(dstPos.field_1350 - lerpOriginZ);
        class_4588 buffer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)TEXTURE));
        class_2338 blockPosOfStart = class_2338.method_49638((class_2374)fromEntity.method_5836(tickDelta));
        class_2338 blockPosOfEnd = class_2338.method_49638((class_2374)toEntity.method_5836(tickDelta));
        int blockLightLevelOfStart = fromEntity.method_37908().method_8314(class_1944.field_9282, blockPosOfStart);
        int blockLightLevelOfEnd = toEntity.method_37908().method_8314(class_1944.field_9282, blockPosOfEnd);
        int skylightLevelOfStart = fromEntity.method_37908().method_8314(class_1944.field_9284, blockPosOfStart);
        int skylightLevelOfEnd = fromEntity.method_37908().method_8314(class_1944.field_9284, blockPosOfEnd);
        Vector3f chainVec = new Vector3f(xDif, yDif, zDif);
        float angleY = -((float)Math.atan2(chainVec.z(), chainVec.x()));
        matrixStack.method_22907(new Quaternionf().rotateXYZ(0.0f, angleY, 0.0f));
        ChainModel model = ChainRenderer.buildModel(chainVec);
        model.render(buffer, matrixStack, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        matrixStack.method_22909();
    }

    protected static class_243 getLeashOffset(class_1297 entity) {
        return new class_243(0.0, 0.0, 0.0);
    }

    public static class ChainRenderer {
        private static final float CHAIN_SCALE = 1.0f;
        private static final int MAX_SEGMENTS = 2048;
        private static final float quality = 4.0f;

        public static ChainModel buildModel(Vector3f chainVec) {
            float desiredSegmentLength = 0.25f;
            int initialCapacity = (int)(2.0f * chainVec.lengthSquared() / desiredSegmentLength);
            ChainModel.Builder builder = ChainModel.builder(initialCapacity);
            if (Float.isNaN(chainVec.x()) && Float.isNaN(chainVec.z())) {
                ChainRenderer.buildFaceVertical(builder, chainVec, 45.0f, UVRect.DEFAULT_SIDE_A);
                ChainRenderer.buildFaceVertical(builder, chainVec, -45.0f, UVRect.DEFAULT_SIDE_B);
            } else {
                ChainRenderer.buildFace(builder, chainVec, 45.0f, UVRect.DEFAULT_SIDE_A);
                ChainRenderer.buildFace(builder, chainVec, -45.0f, UVRect.DEFAULT_SIDE_B);
            }
            return builder.build();
        }

        public static void buildFaceVertical(ChainModel.Builder builder, Vector3f chainVec, float angle, UVRect uv) {
            chainVec.x = 0.0f;
            chainVec.z = 0.0f;
            float actualSegmentLength = 0.25f;
            float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
            Vector3f normal = new Vector3f((float)Math.cos(Math.toRadians(angle)), 0.0f, (float)Math.sin(Math.toRadians(angle)));
            normal.normalize(chainWidth);
            Vector3f vert00 = new Vector3f(-normal.x() / 2.0f, 0.0f, -normal.z() / 2.0f);
            Vector3f vert01 = new Vector3f((Vector3fc)vert00);
            Vector3f vert10 = new Vector3f(-normal.x() / 2.0f, 0.0f, -normal.z() / 2.0f);
            Vector3f vert11 = new Vector3f((Vector3fc)vert10);
            float uvv0 = 0.0f;
            float uvv1 = 0.0f;
            boolean lastIter = false;
            for (int segment = 0; segment < 2048; ++segment) {
                if (vert00.y() + actualSegmentLength >= chainVec.y()) {
                    lastIter = true;
                    actualSegmentLength = chainVec.y() - vert00.y();
                }
                vert10.add(0.0f, actualSegmentLength, 0.0f);
                vert11.add(0.0f, actualSegmentLength, 0.0f);
                builder.vertex(vert00).uv(uv.x0() / 16.0f, uvv0).next();
                builder.vertex(vert01).uv(uv.x1() / 16.0f, uvv0).next();
                builder.vertex(vert11).uv(uv.x1() / 16.0f, uvv1 += actualSegmentLength / 1.0f).next();
                builder.vertex(vert10).uv(uv.x0() / 16.0f, uvv1).next();
                if (lastIter) break;
                uvv0 = uvv1;
                vert00.set((Vector3fc)vert10);
                vert01.set((Vector3fc)vert11);
            }
        }

        public static void buildFace(ChainModel.Builder builder, Vector3f chainVec, float angle, UVRect uv) {
            float desiredSegmentLength = 0.25f;
            float distance = chainVec.length();
            float distanceXZ = (float)Math.sqrt(Math.fma(chainVec.x(), chainVec.x(), chainVec.z() * chainVec.z()));
            float wrongDistanceFactor = distance / distanceXZ;
            Vector3f vert00 = new Vector3f();
            Vector3f vert01 = new Vector3f();
            Vector3f vert11 = new Vector3f();
            Vector3f vert10 = new Vector3f();
            Vector3f normal = new Vector3f();
            Vector3f rotAxis = new Vector3f();
            float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
            float uvv1 = 0.0f;
            Vector3f point0 = new Vector3f();
            Vector3f point1 = new Vector3f();
            Quaternionf rotator = new Quaternionf();
            point0.set(0.0f, (float)ChainRenderer.drip2(0.0, distance, chainVec.y()), 0.0f);
            float gradient = (float)ChainRenderer.drip2prime(0.0, distance, chainVec.y());
            normal.set(-gradient, Math.abs(distanceXZ / distance), 0.0f);
            normal.normalize();
            float x = ChainRenderer.estimateDeltaX(desiredSegmentLength, gradient);
            gradient = (float)ChainRenderer.drip2prime(x * wrongDistanceFactor, distance, chainVec.y());
            float y = (float)ChainRenderer.drip2(x * wrongDistanceFactor, distance, chainVec.y());
            point1.set(x, y, 0.0f);
            rotAxis.set(point1.x() - point0.x(), point1.y() - point0.y(), point1.z() - point0.z());
            rotAxis.normalize();
            rotator.fromAxisAngleDeg((Vector3fc)rotAxis, angle);
            normal.rotate((Quaternionfc)rotator);
            normal.normalize(chainWidth);
            vert10.set(point0.x() - normal.x() / 2.0f, point0.y() - normal.y() / 2.0f, point0.z() - normal.z() / 2.0f);
            vert11.set((Vector3fc)vert10);
            vert11.add((Vector3fc)normal);
            float actualSegmentLength = point0.distance((Vector3fc)point1);
            boolean lastIter = false;
            for (int segment = 0; segment < 2048; ++segment) {
                rotAxis.set(point1.x() - point0.x(), point1.y() - point0.y(), point1.z() - point0.z());
                rotAxis.normalize();
                rotator = rotator.fromAxisAngleDeg((Vector3fc)rotAxis, angle);
                normal.set(-gradient, Math.abs(distanceXZ / distance), 0.0f);
                normal.normalize();
                normal.rotate((Quaternionfc)rotator);
                normal.normalize(chainWidth);
                vert00.set((Vector3fc)vert10);
                vert01.set((Vector3fc)vert11);
                vert10.set(point1.x() - normal.x() / 2.0f, point1.y() - normal.y() / 2.0f, point1.z() - normal.z() / 2.0f);
                vert11.set((Vector3fc)vert10);
                vert11.add((Vector3fc)normal);
                float uvv0 = uvv1;
                uvv1 = uvv0 + actualSegmentLength / 1.0f;
                builder.vertex(vert00).uv(uv.x0() / 16.0f, uvv0).next();
                builder.vertex(vert01).uv(uv.x1() / 16.0f, uvv0).next();
                builder.vertex(vert11).uv(uv.x1() / 16.0f, uvv1).next();
                builder.vertex(vert10).uv(uv.x0() / 16.0f, uvv1).next();
                if (lastIter) break;
                point0.set((Vector3fc)point1);
                x += ChainRenderer.estimateDeltaX(desiredSegmentLength, gradient);
                if (x >= distanceXZ) {
                    lastIter = true;
                    x = distanceXZ;
                }
                gradient = (float)ChainRenderer.drip2prime(x * wrongDistanceFactor, distance, chainVec.y());
                y = (float)ChainRenderer.drip2(x * wrongDistanceFactor, distance, chainVec.y());
                point1.set(x, y, 0.0f);
                actualSegmentLength = point0.distance((Vector3fc)point1);
            }
        }

        private static float estimateDeltaX(float s, float k) {
            return (float)((double)s / Math.sqrt(1.0f + k * k));
        }

        public static double drip2prime(double x, double d, double h) {
            double a = 7.0;
            double p1 = a * ChainRenderer.asinh(h / (2.0 * a) * (1.0 / Math.sinh(d / (2.0 * a))));
            return Math.sinh((2.0 * x + 2.0 * p1 - d) / (2.0 * a));
        }

        public static double drip2(double x, double d, double h) {
            double a = 20.0;
            double p1 = (a += d * 0.3) * ChainRenderer.asinh(h / (2.0 * a) * (1.0 / Math.sinh(d / (2.0 * a))));
            double p2 = -a * Math.cosh((2.0 * p1 - d) / (2.0 * a));
            return p2 + a * Math.cosh((2.0 * x + 2.0 * p1 - d) / (2.0 * a));
        }

        private static double asinh(double x) {
            return Math.log(x + Math.sqrt(x * x + 1.0));
        }
    }

    public record ChainModel(float[] vertices, float[] uvs) {
        public static Builder builder(int initialCapacity) {
            return new Builder(initialCapacity);
        }

        public void render(class_4588 vertexConsumer, class_4587 matrices, int bLight0, int bLight1, int sLight0, int sLight1) {
            Matrix4f modelMatrix = matrices.method_23760().method_23761();
            int count = this.vertices.length / 3;
            for (int i = 0; i < count; ++i) {
                float f = (float)i % ((float)count / 2.0f) / ((float)count / 2.0f);
                int blockLight = (int)class_3532.method_16439((float)f, (float)bLight0, (float)bLight1);
                int skyLight = (int)class_3532.method_16439((float)f, (float)sLight0, (float)sLight1);
                int light = class_765.method_23687((int)blockLight, (int)skyLight);
                vertexConsumer.method_22918(modelMatrix, this.vertices[i * 3], this.vertices[i * 3 + 1], this.vertices[i * 3 + 2]).method_1336(255, 255, 255, 255).method_22913(this.uvs[i * 2], this.uvs[i * 2 + 1]).method_22922(class_4608.field_21444).method_60803(light).method_22914(1.0f, 0.35f, 0.0f);
            }
        }

        public static class Builder {
            private final List<Float> vertices;
            private final List<Float> uvs;
            private int size;

            public Builder(int initialCapacity) {
                this.vertices = new ArrayList<Float>(initialCapacity * 3);
                this.uvs = new ArrayList<Float>(initialCapacity * 2);
            }

            public Builder vertex(Vector3f v) {
                this.vertices.add(Float.valueOf(v.x()));
                this.vertices.add(Float.valueOf(v.y()));
                this.vertices.add(Float.valueOf(v.z()));
                return this;
            }

            public Builder uv(float u, float v) {
                this.uvs.add(Float.valueOf(u));
                this.uvs.add(Float.valueOf(v));
                return this;
            }

            public void next() {
                ++this.size;
            }

            public ChainModel build() {
                if (this.vertices.size() != this.size * 3) {
                    TCOTS_Main.LOGGER.error("Wrong count of vertices");
                }
                if (this.uvs.size() != this.size * 2) {
                    TCOTS_Main.LOGGER.error("Wrong count of uvs");
                }
                return new ChainModel(this.toFloatArray(this.vertices), this.toFloatArray(this.uvs));
            }

            private float[] toFloatArray(List<Float> floats) {
                float[] array = new float[floats.size()];
                int i = 0;
                for (float f : floats) {
                    array[i++] = f;
                }
                return array;
            }
        }
    }

    public record UVRect(float x0, float x1) {
        public static final UVRect DEFAULT_SIDE_A = new UVRect(0.0f, 3.0f);
        public static final UVRect DEFAULT_SIDE_B = new UVRect(3.0f, 6.0f);
    }
}

