/*
 * Decompiled with CFR 0.152.
 */
package fabric.TCOTS.structurized.impl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import fabric.TCOTS.structurized.api.FabricStructurePool;
import fabric.TCOTS.structurized.api.StructurePoolAddCallback;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3782;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3816;
import net.minecraft.class_5321;
import net.minecraft.class_5469;
import net.minecraft.class_5497;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class FabricStructurePoolRegistry {
    private static final Multimap<String, Quintuple<String, String, class_5321<class_5497>, String, Integer>> structures_info = LinkedHashMultimap.create();
    private static final Map<String, String> structures_key_ref = new HashMap<String, String>();
    private static final Multimap<String, class_3545<String, class_6880<class_6796>>> feature_structures = LinkedHashMultimap.create();
    private static final Multimap<String, class_3782> list_structures = LinkedHashMultimap.create();
    public static class_7871<class_5497> registryEntryLookup;

    public static void registerSimple(class_2960 poolId, class_2960 structureId, int weight) {
        FabricStructurePoolRegistry.register(poolId, structureId, weight, (class_5321<class_5497>)class_5469.field_26688, class_3785.class_3786.field_16687, class_3816.field_24016);
    }

    public static void register(class_2960 poolId, class_2960 structureId, int weight, class_5321<class_5497> processor) {
        FabricStructurePoolRegistry.register(poolId, structureId, weight, processor, class_3785.class_3786.field_16687, class_3816.field_24016);
    }

    public static void register(class_2960 poolId, class_2960 structureId, int weight, class_5321<class_5497> processor, class_3785.class_3786 projection) {
        FabricStructurePoolRegistry.register(poolId, structureId, weight, processor, projection, class_3816.field_24016);
    }

    public static void register(class_2960 poolId, class_2960 structureId, int weight, class_5321<class_5497> processor, class_3785.class_3786 projection, class_3816<?> type) {
        String poolType = Objects.requireNonNull(class_7923.field_41162.method_10221(type)).toString();
        String projectionId = projection.method_16635();
        structures_info.put((Object)poolId.toString(), new Quintuple<String, String, class_5321<class_5497>, String, Integer>(structureId.toString(), poolType, processor, projectionId, weight));
        structures_key_ref.put(structureId.toString(), poolId.toString());
    }

    public static void registerFeature(class_2960 poolId, class_2960 structureId, int weight, class_3785.class_3786 projection, class_6880<class_6796> entry) {
        FabricStructurePoolRegistry.register(poolId, structureId, weight, (class_5321<class_5497>)class_5469.field_26688, projection, class_3816.field_16971);
        feature_structures.put((Object)poolId.toString(), (Object)new class_3545((Object)structureId.toString(), entry));
    }

    public static void registerList(class_2960 poolId, int weight, class_3782 listPoolElement) {
        FabricStructurePoolRegistry.register(poolId, class_2960.method_60654((String)"minecraft:air"), weight, (class_5321<class_5497>)class_5469.field_26688, class_3785.class_3786.field_16687, class_3816.field_16974);
        list_structures.put((Object)poolId.toString(), (Object)listPoolElement);
    }

    @Nullable
    public static Triple<String, String, String> getPoolStructureElementInfo(String id) {
        String poolId = structures_key_ref.get(id);
        for (Quintuple quint : structures_info.get((Object)poolId)) {
            if (!((String)quint.a).equals(id)) continue;
            return Triple.of((Object)((String)quint.b), (Object)((class_5321)quint.c).method_29177().toString(), (Object)((String)quint.d));
        }
        return null;
    }

    public static void processRegistry(FabricStructurePool structurePool) {
        String poolId = structurePool.getId().toString();
        for (String key : structures_info.keys()) {
            if (!Objects.equals(key, poolId)) continue;
            structures_info.get((Object)key).forEach(value -> FabricStructurePoolRegistry.addToPool(structurePool, value, key, registryEntryLookup));
        }
    }

    private static void addToPool(FabricStructurePool structurePool, Quintuple<String, String, class_5321<class_5497>, String, Integer> quint, String key, class_7871<class_5497> registryEntryLookup) {
        LinkedList<Object> spe = new LinkedList<Object>();
        class_3816 type = (class_3816)class_7923.field_41162.method_10223(class_2960.method_60654((String)((String)quint.b)));
        if (Objects.equals(type, class_3816.field_16973)) {
            class_6880.class_6883 entry = registryEntryLookup.method_46747((class_5321)quint.c);
            spe.add((class_3784)class_3784.method_30435((String)((String)quint.a), (class_6880)entry).apply(class_3785.class_3786.method_16638((String)((String)quint.d))));
        } else if (Objects.equals(type, class_3816.field_24016)) {
            class_6880.class_6883 entry = registryEntryLookup.method_46747((class_5321)quint.c);
            spe.add((class_3784)class_3784.method_30426((String)((String)quint.a), (class_6880)entry).apply(class_3785.class_3786.method_16638((String)((String)quint.d))));
        } else if (Objects.equals(type, class_3816.field_16974)) {
            spe.addAll(list_structures.get((Object)key));
        } else if (Objects.equals(type, class_3816.field_16971)) {
            LinkedList finalSpe = new LinkedList();
            feature_structures.get((Object)key).forEach(value -> {
                if (((String)value.method_15442()).equals(quint.a)) {
                    finalSpe.add((class_3784)class_3784.method_30421((class_6880)((class_6880)value.method_15441())).apply(class_3785.class_3786.method_16638((String)((String)quint.d))));
                }
            });
            spe.addAll(finalSpe);
        } else {
            spe.add((class_3784)class_3784.method_30438().apply(class_3785.class_3786.field_16687));
        }
        spe.forEach(value -> structurePool.addStructurePoolElement((class_3784)value, (Integer)quint.e));
    }

    static {
        StructurePoolAddCallback.EVENT.register(FabricStructurePoolRegistry::processRegistry);
    }

    private record Quintuple<A, B, C, D, E>(A a, B b, C c, D d, E e) {
    }
}

