/*
 * Decompiled with CFR 0.152.
 */
package com.github.frozenstream.maidfunctionextension.ai.brain.task;

import com.github.frozenstream.maidfunctionextension.MaidFunctionExtension;
import com.github.frozenstream.maidfunctionextension.Registry;
import com.github.frozenstream.maidfunctionextension.ai.memory.ItemMemory;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class MaidGiveOwnerItemTask
extends Behavior<EntityMaid> {
    private final float speedModifier;
    private final int stopDistance;

    public MaidGiveOwnerItemTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of(Registry.ITEM_GIVE.get(), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        LivingEntity owner = maid.getOwner();
        return this.ownerStateConditions(owner, maid);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        LivingEntity owner = maid.getOwner();
        if (maid.getSwimManager().isGoingToBreath() && this.ownerStateConditions(owner, maid) && this.maidStateConditions(maid) && maid.teleportToOwner(owner)) {
            maid.getNavigationManager().resetNavigation();
            maid.getSwimManager().setGoingToBreath(false);
            maid.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            maid.getBrain().eraseMemory((MemoryModuleType)InitEntities.TARGET_POS.get());
            this.doStop(worldIn, (LivingEntity)maid, gameTimeIn);
            return;
        }
        int startDistance = (int)maid.getRestrictRadius() - 2;
        int minTeleportDistance = startDistance + 4;
        if (this.ownerStateConditions(owner, maid) && this.maidStateConditions(maid)) {
            if (!maid.closerThan((Entity)owner, (double)minTeleportDistance)) {
                maid.teleportToOwner(owner);
                maid.getNavigationManager().resetNavigation();
            } else if (!this.ownerIsWalkTarget(maid, owner)) {
                BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)owner, (float)this.speedModifier, (int)this.stopDistance);
            } else if (maid.closerThan((Entity)owner, (double)(this.stopDistance + 1))) {
                this.giveItem(maid, owner);
                maid.getBrain().eraseMemory(Registry.ITEM_GIVE.get());
                maid.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
                maid.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
                this.doStop(worldIn, (LivingEntity)maid, gameTimeIn);
            }
        }
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    private boolean ownerStateConditions(@Nullable LivingEntity owner, EntityMaid maid) {
        return owner != null && !owner.isSpectator() && !owner.isDeadOrDying() && maid.level() == owner.level();
    }

    private boolean ownerIsWalkTarget(EntityMaid maid, LivingEntity owner) {
        return maid.getBrain().getMemory(MemoryModuleType.WALK_TARGET).map(target -> {
            PositionTracker patt0$temp = target.getTarget();
            if (patt0$temp instanceof EntityTracker) {
                EntityTracker tracker = (EntityTracker)patt0$temp;
                return tracker.getEntity().equals((Object)owner);
            }
            return false;
        }).orElse(false);
    }

    private void giveItem(EntityMaid maid, LivingEntity owner) {
        MaidFunctionExtension.LOGGER.info("[Task] Give item to owner");
        Optional itemMemory = maid.getBrain().getMemory(Registry.ITEM_GIVE.get());
        if (itemMemory.isEmpty()) {
            return;
        }
        String name = ((ItemMemory)itemMemory.get()).name();
        int count = ((ItemMemory)itemMemory.get()).count();
        RangedWrapper backpack = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpack.getSlots() && count != 0; ++i) {
            ItemStack stack = backpack.getStackInSlot(i);
            if (!this.getDisplayName(stack).equals(name)) continue;
            if (stack.getCount() < count) {
                count -= stack.getCount();
                BehaviorUtils.throwItem((LivingEntity)maid, (ItemStack)stack, (Vec3)owner.position());
                backpack.setStackInSlot(i, ItemStack.EMPTY);
                continue;
            }
            ItemStack newStack = stack.split(count);
            BehaviorUtils.throwItem((LivingEntity)maid, (ItemStack)newStack, (Vec3)owner.position());
            count = 0;
        }
    }

    private String getDisplayName(ItemStack stack) {
        String str = stack.getDisplayName().getString();
        return str.substring(1, str.length() - 1);
    }
}

