/*
 * Decompiled with CFR 0.152.
 */
package com.github.frozenstream.maidfunctionextension.implement;

import com.github.frozenstream.maidfunctionextension.MaidFunctionExtension;
import com.github.frozenstream.maidfunctionextension.Registry;
import com.github.frozenstream.maidfunctionextension.ai.memory.ItemMemory;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.IFunctionCall;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.response.ToolResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.IntegerParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.ObjectParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.Parameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.StringParameter;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class GiveOwnerItemFunction
implements IFunctionCall<Result> {
    private static final String FUNCTION_ID = "give_owner_item";
    private static final String FUNCTION_DESC = "Use this function when the maid needs to throw name to the owner.\nMaid will select items based on description and available quantity.\nMay refuse based on mood and conversation courtesy.\nOnly trust the inventory information provided in this description.\n";
    private static final String ITEM_NAME_PARAMETER_ID = "item_name";
    private static final String ITEM_NAME_PARAMETER_DESC = "item_name (string, required): the name name to throw.";
    private static final String ITEM_NUMBER_PARAMETER_ID = "item_number";
    private static final String ITEM_NUMBER_PARAMETER_DESC = "item_number (int, optional): the number of items to throw.";
    private static final String SUCCESS = "Successfully give %d %s";

    public String getId() {
        return FUNCTION_ID;
    }

    public String getDescription(EntityMaid maid) {
        StringBuilder InvDescription = new StringBuilder(" Current Inventory: ");
        RangedWrapper backpack = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpack.getSlots(); ++i) {
            ItemStack stack = backpack.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            InvDescription.append("%d %s, ".formatted(stack.getCount(), stack.getDisplayName().getString()));
        }
        return FUNCTION_DESC + String.valueOf(InvDescription);
    }

    public Parameter addParameters(ObjectParameter root, EntityMaid maid) {
        StringParameter itemId = StringParameter.create().setDescription(ITEM_NAME_PARAMETER_DESC);
        IntegerParameter itemNumber = IntegerParameter.create().setDescription(ITEM_NUMBER_PARAMETER_DESC).setDefaultValue("1").setMinimum(1);
        root.addProperties(ITEM_NAME_PARAMETER_ID, (Parameter)itemId, true).addProperties(ITEM_NUMBER_PARAMETER_ID, (Parameter)itemNumber, false);
        return root;
    }

    public Codec<Result> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf(ITEM_NAME_PARAMETER_ID).forGetter(Result::name), (App)Codec.INT.optionalFieldOf(ITEM_NUMBER_PARAMETER_ID, (Object)1).forGetter(Result::count)).apply((Applicative)instance, Result::new));
    }

    public ToolResponse onToolCall(Result result, EntityMaid maid) {
        if (maid.getOwner() == null) {
            return new ToolResponse("Maid doesn't have an owner");
        }
        if (!maid.canPathReach((Entity)maid.getOwner())) {
            return new ToolResponse("Maid can't reach owner");
        }
        String name = result.name;
        int count = result.count;
        MaidFunctionExtension.LOGGER.info("Give Owner Item Function: {}", (Object)name);
        maid.getBrain().setMemory(Registry.ITEM_GIVE.get(), (Object)new ItemMemory(name, count));
        return new ToolResponse(SUCCESS);
    }

    private String getDisplayName(ItemStack stack) {
        String str = stack.getDisplayName().getString();
        return str.substring(1, str.length() - 1);
    }

    public record Result(String name, int count) {
    }
}

