/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.block.entity;

import io.github.hikoma0000.advancementtrophies.block.TrophyCrateBlock;
import io.github.hikoma0000.advancementtrophies.init.ModBlockEntities;
import io.github.hikoma0000.advancementtrophies.init.ModItems;
import io.github.hikoma0000.advancementtrophies.inventory.TrophyCrateContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrophyCrateBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(27){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return ModItems.isTrophy(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            TrophyCrateBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level pLevel, BlockPos pPos, BlockState pState) {
            TrophyCrateBlockEntity.this.playSound(pState, SoundEvents.f_11725_);
            TrophyCrateBlockEntity.this.setOpen(pState, true);
        }

        protected void m_142289_(Level pLevel, BlockPos pPos, BlockState pState) {
            TrophyCrateBlockEntity.this.playSound(pState, SoundEvents.f_11724_);
            TrophyCrateBlockEntity.this.setOpen(pState, false);
        }

        protected void m_142148_(Level pLevel, BlockPos pPos, BlockState pState, int pCount, int pOpenCount) {
        }

        protected boolean m_142718_(Player pPlayer) {
            if (pPlayer.f_36096_ instanceof TrophyCrateContainer) {
                BlockEntity be = ((TrophyCrateContainer)pPlayer.f_36096_).getBlockEntity();
                return be == TrophyCrateBlockEntity.this;
            }
            return false;
        }
    };

    public TrophyCrateBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TROPHY_CRATE.get(), pPos, pBlockState);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.advancementtrophies.trophy_crate");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new TrophyCrateContainer(pContainerId, pPlayerInventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_187476_(ItemStack pStack) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pStack.m_41700_("BlockEntityTag", (Tag)compoundtag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void startOpen(Player pPlayer) {
        if (!this.m_58901_() && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.m_58901_() && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.m_58901_()) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void setOpen(BlockState pState, boolean pOpen) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)pState.m_61124_((Property)TrophyCrateBlock.OPEN, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    void playSound(BlockState pState, SoundEvent pSound) {
        this.f_58857_.m_5594_(null, this.f_58858_, pSound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public boolean m_7531_(int pId, int pType) {
        if (pId == 1) {
            return true;
        }
        return super.m_7531_(pId, pType);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, TrophyCrateBlockEntity pBlockEntity) {
        if (!pBlockEntity.m_58901_()) {
            pBlockEntity.openersCounter.m_155476_(pLevel, pPos, pState);
        }
    }
}

