/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.hikoma0000.advancementtrophies.block.TrophyBlock;
import io.github.hikoma0000.advancementtrophies.block.entity.TrophyBlockEntity;
import io.github.hikoma0000.advancementtrophies.client.util.RenderUtils;
import io.github.hikoma0000.advancementtrophies.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TrophyBlockEntityRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private static final float[] ICON_TRANSLATE = new float[]{0.0f, 1.2f, 0.0f};
    private static final float[] ICON_SCALE = new float[]{0.5f, 0.5f, 0.5f};
    private static final float[] LABEL_TRANSLATE = new float[]{0.0f, 0.1f, 0.2f};
    private static final float[] LABEL_SCALE = new float[]{0.01f, -0.01f, 0.01f};
    private static final float MAX_LABEL_WIDTH = 35.0f;
    private static final float CENTER_TRANSLATE = 0.5f;

    public TrophyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TrophyBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        CompoundTag nbt = pBlockEntity.getTrophyData();
        if (nbt == null || nbt.m_128456_()) {
            return;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 0.0, 0.5);
        BlockState blockState = pBlockEntity.m_58900_();
        if (nbt.m_128441_("icon")) {
            pPoseStack.m_85836_();
            BlockPos blockPos = pBlockEntity.m_58899_();
            Vec3 blockCenter = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
            float angle = RenderUtils.getCameraPositionYRotationBillboard(blockCenter, pPartialTick);
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-angle + 180.0f));
            this.renderIcon(pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, nbt);
            pPoseStack.m_85849_();
        }
        if (((Boolean)ClientConfig.SHOW_ACHIEVER_LABEL.get()).booleanValue() && nbt.m_128441_("achiever")) {
            pPoseStack.m_85836_();
            float rotation = -((Direction)blockState.m_61143_((Property)TrophyBlock.FACING)).m_122435_();
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
            pPoseStack.m_252880_(LABEL_TRANSLATE[0], LABEL_TRANSLATE[1], LABEL_TRANSLATE[2]);
            RenderUtils.renderLabel(pPoseStack, pBufferSource, pPackedLight, (Component)Component.m_237113_((String)nbt.m_128461_("achiever")), 35.0f, LABEL_SCALE);
            pPoseStack.m_85849_();
        }
        pPoseStack.m_85849_();
    }

    private void renderIcon(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, CompoundTag nbt) {
        ItemStack iconStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("icon"));
        if (iconStack.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = this.minecraft.m_91291_();
        poseStack.m_85836_();
        poseStack.m_252880_(ICON_TRANSLATE[0], ICON_TRANSLATE[1], ICON_TRANSLATE[2]);
        poseStack.m_85841_(ICON_SCALE[0], ICON_SCALE[1], ICON_SCALE[2]);
        itemRenderer.m_269128_(iconStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, (Level)this.minecraft.f_91073_, 0);
        poseStack.m_85849_();
    }
}

