/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.inventory;

import io.github.hikoma0000.advancementtrophies.init.ModContainers;
import io.github.hikoma0000.advancementtrophies.init.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class TrophyCrateItemContainer
extends AbstractContainerMenu {
    private final ItemStack crateStack;
    private final IItemHandler crateInventory;
    private final int lockedSlot;
    private final InteractionHand hand;

    public TrophyCrateItemContainer(int pContainerId, Inventory pPlayerInventory, FriendlyByteBuf extraData) {
        this(pContainerId, pPlayerInventory, (InteractionHand)extraData.m_130066_(InteractionHand.class));
    }

    private TrophyCrateItemContainer(int pContainerId, Inventory pPlayerInventory, InteractionHand hand) {
        this(pContainerId, pPlayerInventory, pPlayerInventory.f_35978_.m_21120_(hand), hand);
    }

    public TrophyCrateItemContainer(int pContainerId, Inventory pPlayerInventory, ItemStack crateStack, InteractionHand hand) {
        super((MenuType)ModContainers.TROPHY_CRATE_ITEM_CONTAINER.get(), pContainerId);
        this.crateStack = crateStack;
        this.crateInventory = this.getInventory(crateStack);
        this.hand = hand;
        this.addPlayerInventory(pPlayerInventory);
        this.addPlayerHotbar(pPlayerInventory);
        this.m_38897_(new Slot((Container)pPlayerInventory, 40, -1000, -1000));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_((Slot)new SlotItemHandler(this.crateInventory, j + i * 9, 8 + j * 18, 18 + i * 18){

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return ModItems.isTrophy(stack);
                    }
                });
            }
        }
        crateStack.m_41784_().m_128379_("open", true);
        int lockedPlayerSlot = pPlayerInventory.f_35977_;
        if (hand == InteractionHand.OFF_HAND) {
            lockedPlayerSlot = 40;
        }
        this.lockedSlot = this.findSlotMatching(pPlayerInventory, lockedPlayerSlot);
    }

    private int findSlotMatching(Inventory playerInv, int playerSlot) {
        for (int i = 0; i < this.f_38839_.size(); ++i) {
            Slot s = (Slot)this.f_38839_.get(i);
            if (s.f_40218_ != playerInv || s.getSlotIndex() != playerSlot) continue;
            return i;
        }
        return -1;
    }

    private IItemHandler getInventory(ItemStack stack) {
        CompoundTag nbt = stack.m_41698_("BlockEntityTag");
        ItemStackHandler handler = new ItemStackHandler(27);
        if (nbt.m_128441_("inventory")) {
            handler.deserializeNBT(nbt.m_128469_("inventory"));
        }
        return handler;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        if (this.crateStack.m_41782_()) {
            this.crateStack.m_41783_().m_128379_("open", false);
        }
        CompoundTag nbt = this.crateStack.m_41698_("BlockEntityTag");
        nbt.m_128365_("inventory", (Tag)((ItemStackHandler)this.crateInventory).serializeNBT());
        if (!pPlayer.m_9236_().m_5776_()) {
            pPlayer.m_9236_().m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11724_, SoundSource.PLAYERS, 0.5f, pPlayer.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        int PLAYER_INVENTORY_END = 36;
        int CRATE_INVENTORY_START = 37;
        int CRATE_INVENTORY_END = 64;
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 37, 64, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index >= 37 && index < 64) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        return copyOfSourceStack;
    }

    public void m_150399_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pSlotId == this.lockedSlot) {
            return;
        }
        super.m_150399_(pSlotId, pButton, pClickType, pPlayer);
    }

    public boolean m_6875_(Player pPlayer) {
        return ItemStack.m_41728_((ItemStack)this.crateStack, (ItemStack)pPlayer.m_21120_(this.hand));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

