/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.item;

import io.github.hikoma0000.advancementtrophies.client.util.TooltipUtils;
import io.github.hikoma0000.advancementtrophies.config.client.input.KeyBindings;
import io.github.hikoma0000.advancementtrophies.init.ModItems;
import io.github.hikoma0000.advancementtrophies.item.TrophyCrateItemMenuProvider;
import io.github.hikoma0000.advancementtrophies.util.TrophyRarity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TrophyCrateItem
extends BlockItem {
    public TrophyCrateItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (!pLevel.m_5776_()) {
            TrophyCrateItemMenuProvider menuProvider = new TrophyCrateItemMenuProvider(pPlayer.m_21120_(pHand), pHand);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)menuProvider, buf -> buf.m_130068_((Enum)pHand));
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11725_, SoundSource.PLAYERS, 0.5f, pLevel.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
        return InteractionResultHolder.m_19092_((Object)pPlayer.m_21120_(pHand), (boolean)pLevel.m_5776_());
    }

    public void m_142023_(ItemEntity pItemEntity) {
        ItemStack stack = pItemEntity.m_32055_();
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        if (nbt != null && nbt.m_128441_("inventory")) {
            ItemStackHandler handler = new ItemStackHandler(27);
            handler.deserializeNBT(nbt.m_128469_("inventory"));
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stackInSlot = handler.getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                pItemEntity.m_9236_().m_7967_((Entity)new ItemEntity(pItemEntity.m_9236_(), pItemEntity.m_20185_(), pItemEntity.m_20186_(), pItemEntity.m_20189_(), stackInSlot));
            }
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.advancementtrophies.trophy_crate.description").m_130940_(ChatFormatting.GRAY));
        if (KeyBindings.isDetailsKeyDown) {
            CompoundTag nbt = pStack.m_41737_("BlockEntityTag");
            if (nbt != null && nbt.m_128441_("inventory")) {
                ItemStackHandler handler = new ItemStackHandler(27);
                handler.deserializeNBT(nbt.m_128469_("inventory"));
                int iron = 0;
                int gold = 0;
                int diamond = 0;
                int netherite = 0;
                boolean hasItems = false;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stackInSlot = handler.getStackInSlot(i);
                    if (!stackInSlot.m_41619_()) {
                        hasItems = true;
                    }
                    if (stackInSlot.m_41720_() == ModItems.IRON_TROPHY.get()) {
                        ++iron;
                        continue;
                    }
                    if (stackInSlot.m_41720_() == ModItems.GOLD_TROPHY.get()) {
                        ++gold;
                        continue;
                    }
                    if (stackInSlot.m_41720_() == ModItems.DIAMOND_TROPHY.get()) {
                        ++diamond;
                        continue;
                    }
                    if (stackInSlot.m_41720_() != ModItems.NETHERITE_TROPHY.get()) continue;
                    ++netherite;
                }
                if (hasItems) {
                    pTooltipComponents.add((Component)Component.m_237113_((String)""));
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.advancementtrophies.trophy_crate.contents").m_130940_(ChatFormatting.GRAY));
                    if (iron > 0) {
                        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"rarity.advancementtrophies.iron")).m_130946_(": " + iron).m_130940_(TrophyRarity.IRON.getItemRarity().f_43022_));
                    }
                    if (gold > 0) {
                        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"rarity.advancementtrophies.gold")).m_130946_(": " + gold).m_130940_(TrophyRarity.GOLD.getItemRarity().f_43022_));
                    }
                    if (diamond > 0) {
                        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"rarity.advancementtrophies.diamond")).m_130946_(": " + diamond).m_130940_(TrophyRarity.DIAMOND.getItemRarity().f_43022_));
                    }
                    if (netherite > 0) {
                        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"rarity.advancementtrophies.netherite")).m_130946_(": " + netherite).m_130940_(TrophyRarity.NETHERITE.getItemRarity().f_43022_));
                    }
                }
            }
        } else {
            TooltipUtils.addHoldForDetailsTooltip(pTooltipComponents);
        }
    }

    public static ItemStack addItemToCrate(ItemStack crateStack, ItemStack trophyStack) {
        if (!(crateStack.m_41720_() instanceof TrophyCrateItem) || !ModItems.isTrophy(trophyStack)) {
            return trophyStack;
        }
        CompoundTag nbt = crateStack.m_41698_("BlockEntityTag");
        ItemStackHandler handler = new ItemStackHandler(27);
        if (nbt.m_128441_("inventory")) {
            handler.deserializeNBT(nbt.m_128469_("inventory"));
        }
        ItemStack remainder = trophyStack.m_41777_();
        for (int i = 0; i < handler.getSlots() && !remainder.m_41619_(); ++i) {
            remainder = handler.insertItem(i, remainder, false);
        }
        nbt.m_128365_("inventory", (Tag)handler.serializeNBT());
        return remainder;
    }
}

