/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import io.github.hikoma0000.advancementtrophies.block.entity.TrophyBlockEntity;
import io.github.hikoma0000.advancementtrophies.init.ModBlockEntities;
import io.github.hikoma0000.advancementtrophies.init.ModDataComponents;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrophyBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<TrophyBlock> CODEC = TrophyBlock.simpleCodec(TrophyBlock::new);
    private static final Map<Direction, VoxelShape> SHAPES;

    public TrophyBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockEntity blockentity;
        if (!pLevel.isClientSide && pPlayer.isCreative() && (blockentity = pLevel.getBlockEntity(pPos)) instanceof TrophyBlockEntity) {
            ItemStack itemstack = new ItemStack((ItemLike)this);
            itemstack.applyComponents(blockentity.collectComponents());
            if (itemstack.has(ModDataComponents.TROPHY_DATA.get())) {
                ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, itemstack);
                itementity.setDefaultPickUpDelay();
                pLevel.addFreshEntity((Entity)itementity);
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        ItemStack itemStack = super.getCloneItemStack(pLevel, pPos, pState);
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be != null) {
            itemStack.applyComponents(be.collectComponents());
        }
        return itemStack;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(pState.getValue((Property)FACING));
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction to) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = to.get2DDataValue() & 3;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is(FluidTags.WATER) && fluidstate.getAmount() == 8));
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ModBlockEntities.TROPHY.get().create(pPos, pState);
    }

    static {
        VoxelShape baseShape = Stream.of(Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)7.0, (double)3.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0), Block.box((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)3.0, (double)9.5), Block.box((double)0.51, (double)7.59, (double)7.0, (double)4.51, (double)9.09, (double)9.0), Block.box((double)0.38, (double)8.41, (double)7.0, (double)1.88, (double)13.41, (double)9.0), Block.box((double)1.88, (double)11.91, (double)7.0, (double)4.38, (double)13.41, (double)9.0), Block.box((double)11.51, (double)7.59, (double)7.0, (double)15.51, (double)9.09, (double)9.0), Block.box((double)14.15, (double)8.41, (double)7.0, (double)15.65, (double)13.41, (double)9.0), Block.box((double)11.65, (double)11.91, (double)7.0, (double)14.15, (double)13.41, (double)9.0), Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)14.0, (double)6.0), Block.box((double)10.0, (double)8.0, (double)6.0, (double)12.0, (double)14.0, (double)10.0), Block.box((double)4.0, (double)8.0, (double)10.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)4.0, (double)8.0, (double)6.0, (double)6.0, (double)14.0, (double)10.0)).reduce(Shapes::or).get();
        SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)baseShape, (Object)Direction.EAST, (Object)TrophyBlock.rotateShape(baseShape, Direction.EAST), (Object)Direction.SOUTH, (Object)TrophyBlock.rotateShape(baseShape, Direction.SOUTH), (Object)Direction.WEST, (Object)TrophyBlock.rotateShape(baseShape, Direction.WEST)));
    }
}

