/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.hikoma0000.advancementtrophies.block.TrophyBlock;
import io.github.hikoma0000.advancementtrophies.block.entity.TrophyBlockEntity;
import io.github.hikoma0000.advancementtrophies.client.util.RenderUtils;
import io.github.hikoma0000.advancementtrophies.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TrophyBlockEntityRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private final Minecraft minecraft = Minecraft.getInstance();
    private static final float[] ICON_TRANSLATE = new float[]{0.0f, 1.2f, 0.0f};
    private static final float[] ICON_SCALE = new float[]{0.5f, 0.5f, 0.5f};
    private static final float[] LABEL_TRANSLATE = new float[]{0.0f, 0.1f, 0.2f};
    private static final float[] LABEL_SCALE = new float[]{0.01f, -0.01f, 0.01f};
    private static final float MAX_LABEL_WIDTH = 35.0f;
    private static final float CENTER_TRANSLATE = 0.5f;

    public TrophyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TrophyBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        CompoundTag nbt = pBlockEntity.getTrophyData();
        if (nbt == null || nbt.isEmpty()) {
            return;
        }
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.0, 0.5);
        BlockState blockState = pBlockEntity.getBlockState();
        if (nbt.contains("icon")) {
            pPoseStack.pushPose();
            BlockPos blockPos = pBlockEntity.getBlockPos();
            Vec3 blockCenter = new Vec3((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5);
            float angle = RenderUtils.getCameraPositionYRotationBillboard(blockCenter, pPartialTick);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(-angle + 180.0f));
            this.renderIcon(pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, nbt);
            pPoseStack.popPose();
        }
        if (((Boolean)ClientConfig.SHOW_ACHIEVER_LABEL.get()).booleanValue() && nbt.contains("achiever")) {
            pPoseStack.pushPose();
            float rotation = -((Direction)blockState.getValue((Property)TrophyBlock.FACING)).toYRot();
            pPoseStack.mulPose(Axis.YP.rotationDegrees(rotation));
            pPoseStack.translate(LABEL_TRANSLATE[0], LABEL_TRANSLATE[1], LABEL_TRANSLATE[2]);
            RenderUtils.renderLabel(pPoseStack, pBufferSource, pPackedLight, (Component)Component.literal((String)nbt.getString("achiever")), 35.0f, LABEL_SCALE);
            pPoseStack.popPose();
        }
        pPoseStack.popPose();
    }

    private void renderIcon(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, CompoundTag nbt) {
        ItemStack iconStack = ItemStack.parse((HolderLookup.Provider)this.minecraft.level.registryAccess(), (Tag)nbt.getCompound("icon")).orElse(ItemStack.EMPTY);
        if (iconStack.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = this.minecraft.getItemRenderer();
        poseStack.pushPose();
        poseStack.translate(ICON_TRANSLATE[0], ICON_TRANSLATE[1], ICON_TRANSLATE[2]);
        poseStack.scale(ICON_SCALE[0], ICON_SCALE[1], ICON_SCALE[2]);
        itemRenderer.renderStatic(iconStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, (Level)this.minecraft.level, 0);
        poseStack.popPose();
    }
}

