/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.compat.carryon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.hikoma0000.advancementtrophies.block.TrophyBlock;
import io.github.hikoma0000.advancementtrophies.client.util.RenderUtils;
import io.github.hikoma0000.advancementtrophies.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import org.joml.Matrix4fc;
import tschipp.carryon.client.render.CarryRenderHelper;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;

public class CarryOnRenderer {
    private static final Minecraft MINECRAFT = Minecraft.getInstance();
    private static final float[] ICON_TRANSLATE = new float[]{0.0f, 0.75f, 0.0f};
    private static final float[] ICON_SCALE = new float[]{0.5f, 0.5f, 0.5f};
    private static final float[] LABEL_TRANSLATE = new float[]{0.0f, -0.4f, 0.2f};
    private static final float[] LABEL_SCALE = new float[]{0.01f, -0.01f, 0.01f};
    private static final float MAX_LABEL_WIDTH = 35.0f;

    public static void renderInWorld(PoseStack eventPoseStack, float partialTick) {
        if (CarryOnRenderer.MINECRAFT.level == null || CarryOnRenderer.MINECRAFT.player == null || CarryOnRenderer.MINECRAFT.cameraEntity == null) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = MINECRAFT.renderBuffers().bufferSource();
        for (Player player : CarryOnRenderer.MINECRAFT.level.players()) {
            CompoundTag trophyData;
            BlockState carriedBlockState;
            CarryOnData carryData;
            if (CarryOnRenderer.MINECRAFT.options.getCameraType().isFirstPerson() && player == CarryOnRenderer.MINECRAFT.player && !CarryOnRenderer.isFirstPersonModLoaded() || !(carryData = CarryOnDataManager.getCarryData((Player)player)).isCarrying(CarryOnData.CarryType.BLOCK) || !((carriedBlockState = carryData.getBlock()).getBlock() instanceof TrophyBlock) || (trophyData = carryData.getNbt().getCompound("tile").getCompound("TrophyData")).isEmpty()) continue;
            PoseStack matrix = new PoseStack();
            matrix.last().pose().mul((Matrix4fc)eventPoseStack.last().pose());
            CarryRenderHelper.applyBlockTransformations((Player)player, (float)partialTick, (PoseStack)matrix, (Block)carriedBlockState.getBlock());
            int packedLight = MINECRAFT.getEntityRenderDispatcher().getPackedLightCoords((Entity)player, partialTick);
            boolean isViewFromBack = player != CarryOnRenderer.MINECRAFT.player || CarryOnRenderer.MINECRAFT.options.getCameraType().isMirrored();
            matrix.pushPose();
            if (isViewFromBack) {
                matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            if (trophyData.contains("icon")) {
                matrix.pushPose();
                if (player == CarryOnRenderer.MINECRAFT.player) {
                    if (isViewFromBack) {
                        matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                } else {
                    Vec3 playerPos = player.getPosition(partialTick);
                    float angle = RenderUtils.getCameraPositionYRotationBillboard(playerPos, partialTick);
                    float playerBodyYaw = CarryRenderHelper.getExactBodyRotationDegrees((LivingEntity)player, (float)partialTick);
                    matrix.mulPose(Axis.YP.rotationDegrees(-angle - playerBodyYaw));
                }
                CarryOnRenderer.renderIcon(matrix, (MultiBufferSource)bufferSource, packedLight, trophyData);
                matrix.popPose();
            }
            if (((Boolean)ClientConfig.SHOW_ACHIEVER_LABEL.get()).booleanValue() && trophyData.contains("achiever")) {
                matrix.pushPose();
                matrix.translate(LABEL_TRANSLATE[0], LABEL_TRANSLATE[1], LABEL_TRANSLATE[2]);
                RenderUtils.renderLabel(matrix, (MultiBufferSource)bufferSource, packedLight, (Component)Component.literal((String)trophyData.getString("achiever")), 35.0f, LABEL_SCALE);
                matrix.popPose();
            }
            matrix.popPose();
        }
        bufferSource.endBatch();
    }

    private static void renderIcon(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, CompoundTag nbt) {
        ItemStack iconStack = ItemStack.parse((HolderLookup.Provider)CarryOnRenderer.MINECRAFT.level.registryAccess(), (Tag)nbt.getCompound("icon")).orElse(ItemStack.EMPTY);
        if (iconStack.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = MINECRAFT.getItemRenderer();
        poseStack.pushPose();
        poseStack.translate(ICON_TRANSLATE[0], ICON_TRANSLATE[1], ICON_TRANSLATE[2]);
        poseStack.scale(ICON_SCALE[0], ICON_SCALE[1], ICON_SCALE[2]);
        itemRenderer.renderStatic(iconStack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, (Level)CarryOnRenderer.MINECRAFT.level, 0);
        poseStack.popPose();
    }

    private static boolean isFirstPersonModLoaded() {
        return ModList.get().isLoaded("firstperson") || ModList.get().isLoaded("alien_first_person") || ModList.get().isLoaded("realcamera");
    }
}

