/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.event;

import io.github.hikoma0000.advancementtrophies.init.ModDataComponents;
import io.github.hikoma0000.advancementtrophies.init.ModItems;
import io.github.hikoma0000.advancementtrophies.item.TrophyCrateItem;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;

public class AdvancementEventHandler {
    private static final Map<AdvancementType, Supplier<Item>> FRAME_TYPE_TO_TROPHY = Map.of(AdvancementType.TASK, ModItems.IRON_TROPHY, AdvancementType.GOAL, ModItems.GOLD_TROPHY, AdvancementType.CHALLENGE, ModItems.DIAMOND_TROPHY);

    @SubscribeEvent
    public void onAdvancementGranted(AdvancementEvent.AdvancementEarnEvent event) {
        ItemStack inventoryStack;
        Supplier<Item> trophyItem;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AdvancementHolder advancementHolder = event.getAdvancement();
        Advancement advancement = advancementHolder.value();
        DisplayInfo display = advancement.display().orElse(null);
        if (display == null || !display.shouldAnnounceChat()) {
            return;
        }
        Supplier<Item> supplier = trophyItem = display.isHidden() ? ModItems.NETHERITE_TROPHY : FRAME_TYPE_TO_TROPHY.get(display.getType());
        if (trophyItem == null) {
            return;
        }
        ItemStack trophyStack = new ItemStack((ItemLike)trophyItem.get());
        CompoundTag nbt = new CompoundTag();
        nbt.putString("achiever", player2.getName().getString());
        CompoundTag dateTag = new CompoundTag();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        dateTag.putInt("year", cal.get(1));
        dateTag.putInt("month", cal.get(2) + 1);
        dateTag.putInt("day", cal.get(5));
        dateTag.putInt("hour", cal.get(11));
        dateTag.putInt("minute", cal.get(12));
        dateTag.putInt("second", cal.get(13));
        nbt.put("date", (Tag)dateTag);
        nbt.putString("advancement_id", advancementHolder.id().toString());
        RegistryAccess provider = player2.level().registryAccess();
        Component advancementTitleComponent = display.getTitle();
        ComponentContents componentContents = advancementTitleComponent.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            nbt.putString("advancement_title", contents.getKey());
        } else {
            nbt.putString("advancement_title_json", Component.Serializer.toJson((Component)advancementTitleComponent, (HolderLookup.Provider)provider));
        }
        nbt.putString("advancement_mod", advancementHolder.id().getNamespace());
        CompoundTag iconTag = (CompoundTag)display.getIcon().save((HolderLookup.Provider)provider);
        nbt.put("icon", (Tag)iconTag);
        trophyStack.set(ModDataComponents.TROPHY_DATA.get(), (Object)nbt);
        ItemStack trophyRemainder = trophyStack.copy();
        for (int i = 0; !(i >= player2.getInventory().getContainerSize() || (inventoryStack = player2.getInventory().getItem(i)).getItem() instanceof TrophyCrateItem && (trophyRemainder = TrophyCrateItem.addItemToCrate(inventoryStack, trophyRemainder)).isEmpty()); ++i) {
        }
        if (!trophyRemainder.isEmpty() && !player2.getInventory().add(trophyRemainder)) {
            player2.drop(trophyRemainder, false);
            player2.sendSystemMessage((Component)Component.translatableWithFallback((String)"message.advancementtrophies.inventory_full", (String)"Your inventory is full! The trophy has been dropped nearby."));
        }
    }
}

