/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.inventory;

import io.github.hikoma0000.advancementtrophies.block.entity.TrophyCrateBlockEntity;
import io.github.hikoma0000.advancementtrophies.init.ModBlocks;
import io.github.hikoma0000.advancementtrophies.init.ModContainers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class TrophyCrateContainer
extends AbstractContainerMenu {
    private final TrophyCrateBlockEntity blockEntity;
    private final Level level;

    public TrophyCrateContainer(int pContainerId, Inventory pPlayerInventory, FriendlyByteBuf extraData) {
        this(pContainerId, pPlayerInventory, pPlayerInventory.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public TrophyCrateContainer(int pContainerId, Inventory pPlayerInventory, BlockEntity blockEntity) {
        super(ModContainers.TROPHY_CRATE_CONTAINER.get(), pContainerId);
        this.blockEntity = (TrophyCrateBlockEntity)blockEntity;
        this.level = pPlayerInventory.player.level();
        TrophyCrateContainer.checkContainerSize((Container)this.blockEntity, (int)27);
        this.blockEntity.startOpen(pPlayerInventory.player);
        int containerRows = 3;
        int containerCols = 9;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.blockEntity, j + i * 9, 8 + j * 18, 18 + i * 18));
            }
        }
        this.addPlayerInventory(pPlayerInventory);
        this.addPlayerHotbar(pPlayerInventory);
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.blockEntity.stopOpen(pPlayer);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack sourceStack = slot.getItem();
            itemstack = sourceStack.copy();
            if (pIndex < 27 ? !this.moveItemStackTo(sourceStack, 27, this.slots.size(), true) : !this.moveItemStackTo(sourceStack, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (sourceStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return TrophyCrateContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)ModBlocks.TROPHY_CRATE.get());
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

