/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.inventory;

import io.github.hikoma0000.advancementtrophies.init.ModContainers;
import io.github.hikoma0000.advancementtrophies.init.ModDataComponents;
import io.github.hikoma0000.advancementtrophies.init.ModItems;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.NotNull;

public class TrophyCrateItemContainer
extends AbstractContainerMenu {
    private final ItemStack crateStack;
    private final Container crateInventory;
    private final int lockedSlot;
    private final InteractionHand hand;

    public TrophyCrateItemContainer(int pContainerId, Inventory pPlayerInventory, FriendlyByteBuf extraData) {
        this(pContainerId, pPlayerInventory, (InteractionHand)extraData.readEnum(InteractionHand.class));
    }

    private TrophyCrateItemContainer(int pContainerId, Inventory pPlayerInventory, InteractionHand hand) {
        this(pContainerId, pPlayerInventory, pPlayerInventory.player.getItemInHand(hand), hand);
    }

    public TrophyCrateItemContainer(int pContainerId, Inventory pPlayerInventory, ItemStack crateStack, InteractionHand hand) {
        super(ModContainers.TROPHY_CRATE_ITEM_CONTAINER.get(), pContainerId);
        int i;
        this.crateStack = crateStack;
        this.crateInventory = new SimpleContainer(27);
        ItemContainerContents contents = (ItemContainerContents)crateStack.get(DataComponents.CONTAINER);
        if (contents != null) {
            i = 0;
            for (ItemStack item : contents.stream().toList()) {
                if (i >= this.crateInventory.getContainerSize()) continue;
                this.crateInventory.setItem(i, item);
                ++i;
            }
        }
        this.hand = hand;
        this.addPlayerInventory(pPlayerInventory);
        this.addPlayerHotbar(pPlayerInventory);
        this.addSlot(new Slot((Container)pPlayerInventory, 40, -1000, -1000));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot(this, this.crateInventory, j + i * 9, 8 + j * 18, 18 + i * 18){

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        return ModItems.isTrophy(stack);
                    }
                });
            }
        }
        crateStack.set(ModDataComponents.OPEN.get(), (Object)true);
        int lockedPlayerSlot = pPlayerInventory.selected;
        if (hand == InteractionHand.OFF_HAND) {
            lockedPlayerSlot = 40;
        }
        this.lockedSlot = this.findSlotMatching(pPlayerInventory, lockedPlayerSlot);
    }

    private int findSlotMatching(Inventory playerInv, int playerSlot) {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot s = (Slot)this.slots.get(i);
            if (s.container != playerInv || s.getSlotIndex() != playerSlot) continue;
            return i;
        }
        return -1;
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.crateStack.set(ModDataComponents.OPEN.get(), (Object)false);
        NonNullList items = NonNullList.withSize((int)this.crateInventory.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.crateInventory.getContainerSize(); ++i) {
            items.set(i, (Object)this.crateInventory.getItem(i));
        }
        this.crateStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)items));
        if (!pPlayer.level().isClientSide()) {
            pPlayer.level().playSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.BARREL_CLOSE, SoundSource.PLAYERS, 0.5f, pPlayer.level().random.nextFloat() * 0.1f + 0.9f);
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        int PLAYER_INVENTORY_END = 36;
        int CRATE_INVENTORY_START = 37;
        int CRATE_INVENTORY_END = 64;
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 37, 64, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index >= 37 && index < 64) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        return copyOfSourceStack;
    }

    public void clicked(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pSlotId == this.lockedSlot) {
            return;
        }
        super.clicked(pSlotId, pButton, pClickType, pPlayer);
    }

    public boolean stillValid(Player pPlayer) {
        return ItemStack.matches((ItemStack)this.crateStack, (ItemStack)pPlayer.getItemInHand(this.hand));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

