/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.item;

import io.github.hikoma0000.advancementtrophies.client.util.TooltipUtils;
import io.github.hikoma0000.advancementtrophies.config.client.input.KeyBindings;
import io.github.hikoma0000.advancementtrophies.init.ModItems;
import io.github.hikoma0000.advancementtrophies.item.TrophyCrateItemMenuProvider;
import io.github.hikoma0000.advancementtrophies.util.TrophyRarity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TrophyCrateItem
extends BlockItem {
    public TrophyCrateItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (this.isLocked(itemstack) && !this.canOpen(itemstack, pPlayer)) {
            pPlayer.displayClientMessage((Component)Component.translatable((String)"container.isLocked", (Object[])new Object[]{itemstack.getHoverName()}), true);
            pPlayer.playSound(SoundEvents.CHEST_LOCKED, 1.0f, 1.0f);
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            TrophyCrateItemMenuProvider menuProvider = new TrophyCrateItemMenuProvider(itemstack, pHand);
            serverPlayer.openMenu((MenuProvider)menuProvider, buf -> buf.writeEnum((Enum)pHand));
            pPlayer.awardStat(Stats.OPEN_BARREL);
            pLevel.playSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.BARREL_OPEN, SoundSource.PLAYERS, 0.5f, pLevel.random.nextFloat() * 0.1f + 0.9f);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
    }

    private boolean isLocked(ItemStack pStack) {
        LockCode lock = (LockCode)pStack.get(DataComponents.LOCK);
        return lock != null && !lock.key().isEmpty();
    }

    private boolean canOpen(ItemStack pStack, Player pPlayer) {
        LockCode lock = (LockCode)pStack.getOrDefault(DataComponents.LOCK, (Object)LockCode.NO_LOCK);
        return lock.unlocksWith(pPlayer.getMainHandItem()) || lock.unlocksWith(pPlayer.getOffhandItem());
    }

    public void onDestroyed(ItemEntity pItemEntity) {
        ItemContainerContents contents = (ItemContainerContents)pItemEntity.getItem().get(DataComponents.CONTAINER);
        if (contents != null) {
            for (ItemStack stackInSlot : contents.stream().toList()) {
                if (stackInSlot.isEmpty()) continue;
                pItemEntity.level().addFreshEntity((Entity)new ItemEntity(pItemEntity.level(), pItemEntity.getX(), pItemEntity.getY(), pItemEntity.getZ(), stackInSlot));
            }
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.advancementtrophies.trophy_crate.description").withStyle(ChatFormatting.GRAY));
        if (KeyBindings.isDetailsKeyDown) {
            ItemContainerContents contents = (ItemContainerContents)pStack.get(DataComponents.CONTAINER);
            if (contents != null && !contents.stream().allMatch(ItemStack::isEmpty)) {
                pTooltipComponents.add((Component)Component.literal((String)""));
                pTooltipComponents.add((Component)Component.translatable((String)"tooltip.advancementtrophies.trophy_crate.contents").withStyle(ChatFormatting.GRAY));
                int iron = 0;
                int gold = 0;
                int diamond = 0;
                int netherite = 0;
                for (ItemStack stackInSlot : contents.stream().toList()) {
                    if (stackInSlot.is(ModItems.IRON_TROPHY.get())) {
                        ++iron;
                        continue;
                    }
                    if (stackInSlot.is(ModItems.GOLD_TROPHY.get())) {
                        ++gold;
                        continue;
                    }
                    if (stackInSlot.is(ModItems.DIAMOND_TROPHY.get())) {
                        ++diamond;
                        continue;
                    }
                    if (!stackInSlot.is(ModItems.NETHERITE_TROPHY.get())) continue;
                    ++netherite;
                }
                if (iron > 0) {
                    pTooltipComponents.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"rarity.advancementtrophies.iron")).append(": " + iron).withStyle(TrophyRarity.IRON.getStyleModifier()));
                }
                if (gold > 0) {
                    pTooltipComponents.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"rarity.advancementtrophies.gold")).append(": " + gold).withStyle(TrophyRarity.GOLD.getStyleModifier()));
                }
                if (diamond > 0) {
                    pTooltipComponents.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"rarity.advancementtrophies.diamond")).append(": " + diamond).withStyle(TrophyRarity.DIAMOND.getStyleModifier()));
                }
                if (netherite > 0) {
                    pTooltipComponents.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"rarity.advancementtrophies.netherite")).append(": " + netherite).withStyle(TrophyRarity.NETHERITE.getStyleModifier()));
                }
            }
        } else {
            TooltipUtils.addHoldForDetailsTooltip(pTooltipComponents);
        }
    }

    public static ItemStack addItemToCrate(ItemStack crateStack, ItemStack trophyStack) {
        if (!(crateStack.getItem() instanceof TrophyCrateItem) || !ModItems.isTrophy(trophyStack)) {
            return trophyStack;
        }
        ItemContainerContents contents = (ItemContainerContents)crateStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        NonNullList items = NonNullList.createWithCapacity((int)contents.getSlots());
        contents.copyInto(items);
        ItemStack remainder = trophyStack.copy();
        for (int i = 0; i < items.size() && !remainder.isEmpty(); ++i) {
            ItemStack current = (ItemStack)items.get(i);
            if (current.isEmpty()) {
                items.set(i, (Object)remainder.split(remainder.getMaxStackSize()));
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)remainder) || current.getCount() >= current.getMaxStackSize()) continue;
            int toAdd = Math.min(remainder.getCount(), current.getMaxStackSize() - current.getCount());
            current.grow(toAdd);
            remainder.shrink(toAdd);
        }
        crateStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)items));
        return remainder;
    }
}

