/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.item;

import io.github.hikoma0000.advancementtrophies.client.util.TooltipUtils;
import io.github.hikoma0000.advancementtrophies.config.ClientConfig;
import io.github.hikoma0000.advancementtrophies.config.client.input.KeyBindings;
import io.github.hikoma0000.advancementtrophies.init.ModDataComponents;
import io.github.hikoma0000.advancementtrophies.util.TrophyUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class TrophyItem
extends BlockItem {
    public TrophyItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
        CompoundTag nbt = (CompoundTag)pStack.get(ModDataComponents.TROPHY_DATA.get());
        if (nbt == null || nbt.isEmpty()) {
            pTooltipComponents.add((Component)Component.translatableWithFallback((String)"tooltip.advancementtrophies.empty", (String)"Unclaimed Trophy").withStyle(ChatFormatting.GRAY));
            return;
        }
        if (KeyBindings.isDetailsKeyDown) {
            HolderLookup.Provider provider;
            Component advancementTitle;
            if (nbt.contains("achiever", 8)) {
                pTooltipComponents.add((Component)Component.translatableWithFallback((String)"tooltip.advancementtrophies.achiever", (String)"Achiever: %s", (Object[])new Object[]{nbt.getString("achiever")}).withStyle(ChatFormatting.GRAY));
            }
            if (nbt.contains("date", 10)) {
                CompoundTag dateTag = nbt.getCompound("date");
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.set(dateTag.getInt("year"), dateTag.getInt("month") - 1, dateTag.getInt("day"), dateTag.getInt("hour"), dateTag.getInt("minute"), dateTag.getInt("second"));
                    SimpleDateFormat sdf = new SimpleDateFormat((String)ClientConfig.DATE_FORMAT.get());
                    String formattedDate = sdf.format(cal.getTime());
                    pTooltipComponents.add((Component)Component.translatableWithFallback((String)"tooltip.advancementtrophies.date.format", (String)"Date: %s", (Object[])new Object[]{formattedDate}).withStyle(ChatFormatting.GRAY));
                }
                catch (Exception e) {
                    pTooltipComponents.add((Component)Component.literal((String)"Date: Invalid Format").withStyle(ChatFormatting.RED));
                }
            }
            if ((advancementTitle = TrophyUtils.getAdvancementTitleFromNBT(nbt, provider = pContext != null ? pContext.registries() : null)) != null) {
                pTooltipComponents.add((Component)Component.literal((String)""));
                pTooltipComponents.add((Component)Component.translatableWithFallback((String)"tooltip.advancementtrophies.advancement", (String)"Advancement: %s", (Object[])new Object[]{advancementTitle}).withStyle(ChatFormatting.GOLD));
            }
            if (nbt.contains("advancement_mod", 8)) {
                pTooltipComponents.add((Component)Component.translatableWithFallback((String)"tooltip.advancementtrophies.mod", (String)"Mod: %s", (Object[])new Object[]{nbt.getString("advancement_mod")}).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
            }
        } else {
            TooltipUtils.addHoldForDetailsTooltip(pTooltipComponents);
        }
    }

    public Component getName(ItemStack pStack) {
        Component advancementTitle;
        CompoundTag nbt = (CompoundTag)pStack.get(ModDataComponents.TROPHY_DATA.get());
        if (nbt != null && (advancementTitle = TrophyUtils.getAdvancementTitleFromNBT(nbt, null)) != null) {
            return Component.translatableWithFallback((String)"item.advancementtrophies.trophy.named", (String)"Trophy of %s", (Object[])new Object[]{advancementTitle});
        }
        return super.getName(pStack);
    }
}

