/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.github.hikoma0000.advancementtrophies.block.entity.TrophyBlockEntity;
import io.github.hikoma0000.advancementtrophies.init.ModBlockEntities;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrophyBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final Map<Direction, VoxelShape> SHAPES;

    public TrophyBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof TrophyBlockEntity && !pLevel.f_46443_ && pPlayer.m_7500_()) {
            ItemStack itemstack = new ItemStack((ItemLike)this);
            blockentity.m_187476_(itemstack);
            if (itemstack.m_41782_()) {
                ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                pLevel.m_7967_((Entity)itementity);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        BlockEntity blockentity = (BlockEntity)pParams.m_287159_(LootContextParams.f_81462_);
        if (blockentity instanceof TrophyBlockEntity) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            blockentity.m_187476_(itemStack);
            return Collections.singletonList(itemStack);
        }
        return super.m_49635_(pState, pParams);
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        ItemStack itemStack = super.m_7397_(pLevel, pPos, pState);
        pLevel.m_141902_(pPos, (BlockEntityType)ModBlockEntities.TROPHY.get()).ifPresent(be -> be.m_187476_(itemStack));
        return itemStack;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(pState.m_61143_((Property)FACING));
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction to) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = to.m_122416_() & 3;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)ModBlockEntities.TROPHY.get()).m_155264_(pPos, pState);
    }

    static {
        VoxelShape baseShape = Stream.of(Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.m_49796_((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.m_49796_((double)7.0, (double)3.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0), Block.m_49796_((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)3.0, (double)9.5), Block.m_49796_((double)0.51, (double)7.59, (double)7.0, (double)4.51, (double)9.09, (double)9.0), Block.m_49796_((double)0.38, (double)8.41, (double)7.0, (double)1.88, (double)13.41, (double)9.0), Block.m_49796_((double)1.88, (double)11.91, (double)7.0, (double)4.38, (double)13.41, (double)9.0), Block.m_49796_((double)11.51, (double)7.59, (double)7.0, (double)15.51, (double)9.09, (double)9.0), Block.m_49796_((double)14.15, (double)8.41, (double)7.0, (double)15.65, (double)13.41, (double)9.0), Block.m_49796_((double)11.65, (double)11.91, (double)7.0, (double)14.15, (double)13.41, (double)9.0), Block.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)14.0, (double)6.0), Block.m_49796_((double)10.0, (double)8.0, (double)6.0, (double)12.0, (double)14.0, (double)10.0), Block.m_49796_((double)4.0, (double)8.0, (double)10.0, (double)12.0, (double)14.0, (double)12.0), Block.m_49796_((double)4.0, (double)8.0, (double)6.0, (double)6.0, (double)14.0, (double)10.0)).reduce(Shapes::m_83110_).get();
        SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)baseShape, (Object)Direction.EAST, (Object)TrophyBlock.rotateShape(baseShape, Direction.EAST), (Object)Direction.SOUTH, (Object)TrophyBlock.rotateShape(baseShape, Direction.SOUTH), (Object)Direction.WEST, (Object)TrophyBlock.rotateShape(baseShape, Direction.WEST)));
    }
}

