/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.block.entity;

import io.github.hikoma0000.advancementtrophies.block.TrophyCrateBlock;
import io.github.hikoma0000.advancementtrophies.init.ModBlockEntities;
import io.github.hikoma0000.advancementtrophies.init.ModItems;
import io.github.hikoma0000.advancementtrophies.inventory.TrophyCrateContainer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class TrophyCrateBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    public static final int CONTAINER_SIZE = 27;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private int openCount;
    private boolean initialized = false;

    public TrophyCrateBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.TROPHY_CRATE.get(), pos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)false);
        }
    }

    public void m_187476_(ItemStack stack) {
        if (!this.m_59634_(stack.m_41784_()) && !this.m_7983_()) {
            super.m_187476_(stack);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public Component m_5446_() {
        return this.m_8077_() ? this.m_7770_() : this.m_6820_();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.advancementtrophies.trophy_crate");
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory playerInventory) {
        return new TrophyCrateContainer(containerId, playerInventory, (BlockEntity)this);
    }

    public void m_5856_(Player player) {
        if (!this.m_58901_() && !player.m_5833_()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount == 1) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11725_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    public void m_5785_(Player player) {
        if (!this.m_58901_() && !player.m_5833_()) {
            --this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11724_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            boolean isOpen = this.openCount > 0;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)TrophyCrateBlock.OPEN, (Comparable)Boolean.valueOf(isOpen)), 3);
            return true;
        }
        return super.m_7531_(id, type);
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        return ModItems.isTrophy(stack) && super.m_7013_(index, stack);
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TrophyCrateBlockEntity blockEntity) {
        if (!blockEntity.initialized) {
            if (((Boolean)state.m_61143_((Property)TrophyCrateBlock.OPEN)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)TrophyCrateBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
            }
            blockEntity.initialized = true;
        }
    }
}

