/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.compat.carryon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.hikoma0000.advancementtrophies.block.TrophyBlock;
import io.github.hikoma0000.advancementtrophies.client.util.RenderUtils;
import io.github.hikoma0000.advancementtrophies.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.joml.Matrix4fc;
import tschipp.carryon.client.render.CarryRenderHelper;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;

public class CarryOnRenderer {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private static final float[] ICON_TRANSLATE = new float[]{0.0f, 0.75f, 0.0f};
    private static final float[] ICON_SCALE = new float[]{0.6f, 0.6f, 0.6f};
    private static final float[] LABEL_TRANSLATE = new float[]{0.0f, -0.4f, 0.2f};
    private static final float[] LABEL_SCALE = new float[]{0.01f, -0.01f, 0.01f};
    private static final float MAX_LABEL_WIDTH = 35.0f;

    public static void renderInWorld(PoseStack eventPoseStack, float partialTick) {
        if (CarryOnRenderer.MINECRAFT.f_91073_ == null || CarryOnRenderer.MINECRAFT.f_91074_ == null || CarryOnRenderer.MINECRAFT.f_91075_ == null) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = MINECRAFT.m_91269_().m_110104_();
        for (Player player : CarryOnRenderer.MINECRAFT.f_91073_.m_6907_()) {
            CompoundTag trophyData;
            BlockState carriedBlockState;
            CarryOnData carryData;
            if (CarryOnRenderer.MINECRAFT.f_91066_.m_92176_().m_90612_() && player == CarryOnRenderer.MINECRAFT.f_91074_ && !CarryOnRenderer.isFirstPersonModLoaded() || !(carryData = CarryOnDataManager.getCarryData((Player)player)).isCarrying(CarryOnData.CarryType.BLOCK) || !((carriedBlockState = carryData.getBlock()).m_60734_() instanceof TrophyBlock) || (trophyData = carryData.getNbt().m_128469_("tile").m_128469_("TrophyData")).m_128456_()) continue;
            PoseStack matrix = new PoseStack();
            matrix.m_85850_().m_252922_().mul((Matrix4fc)eventPoseStack.m_85850_().m_252922_());
            CarryRenderHelper.applyBlockTransformations((Player)player, (float)partialTick, (PoseStack)matrix, (Block)carriedBlockState.m_60734_());
            int packedLight = MINECRAFT.m_91290_().m_114394_((Entity)player, partialTick);
            boolean isViewFromBack = player != CarryOnRenderer.MINECRAFT.f_91074_ || CarryRenderHelper.getPerspective() != 0;
            matrix.m_85836_();
            if (isViewFromBack) {
                matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
            if (trophyData.m_128441_("icon")) {
                matrix.m_85836_();
                if (player == CarryOnRenderer.MINECRAFT.f_91074_) {
                    if (isViewFromBack) {
                        matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    }
                } else {
                    Vec3 playerPos = player.m_20318_(partialTick);
                    float angle = RenderUtils.getCameraPositionYRotationBillboard(playerPos, partialTick);
                    float playerBodyYaw = CarryRenderHelper.getExactBodyRotationDegrees((LivingEntity)player, (float)partialTick);
                    matrix.m_252781_(Axis.f_252436_.m_252977_(-angle - playerBodyYaw));
                }
                CarryOnRenderer.renderIcon(matrix, (MultiBufferSource)bufferSource, packedLight, trophyData);
                matrix.m_85849_();
            }
            if (((Boolean)ClientConfig.SHOW_ACHIEVER_LABEL.get()).booleanValue() && trophyData.m_128441_("achiever")) {
                matrix.m_85836_();
                matrix.m_252880_(LABEL_TRANSLATE[0], LABEL_TRANSLATE[1], LABEL_TRANSLATE[2]);
                RenderUtils.renderLabel(matrix, (MultiBufferSource)bufferSource, packedLight, (Component)Component.m_237113_((String)trophyData.m_128461_("achiever")), 35.0f, LABEL_SCALE);
                matrix.m_85849_();
            }
            matrix.m_85849_();
            matrix.m_85849_();
            matrix.m_85849_();
        }
        bufferSource.m_109911_();
    }

    private static void renderIcon(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, CompoundTag nbt) {
        ItemStack iconStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("icon"));
        if (iconStack.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = MINECRAFT.m_91291_();
        poseStack.m_85836_();
        poseStack.m_252880_(ICON_TRANSLATE[0], ICON_TRANSLATE[1], ICON_TRANSLATE[2]);
        poseStack.m_85841_(ICON_SCALE[0], ICON_SCALE[1], ICON_SCALE[2]);
        itemRenderer.m_269128_(iconStack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, bufferSource, (Level)CarryOnRenderer.MINECRAFT.f_91073_, 0);
        poseStack.m_85849_();
    }

    private static boolean isFirstPersonModLoaded() {
        return ModList.get().isLoaded("firstperson") || ModList.get().isLoaded("alien_first_person") || ModList.get().isLoaded("realcamera");
    }
}

