/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.event;

import io.github.hikoma0000.advancementtrophies.init.ModItems;
import io.github.hikoma0000.advancementtrophies.item.TrophyCrateItem;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="advancementtrophies")
public class AdvancementEventHandler {
    private static final Map<FrameType, RegistryObject<Item>> FRAME_TYPE_TO_TROPHY = Map.of(FrameType.TASK, ModItems.IRON_TROPHY, FrameType.GOAL, ModItems.GOLD_TROPHY, FrameType.CHALLENGE, ModItems.DIAMOND_TROPHY);

    @SubscribeEvent
    public static void onAdvancementGranted(AdvancementEvent.AdvancementEarnEvent event) {
        ItemStack inventoryStack;
        RegistryObject<Item> trophyItem;
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        DisplayInfo display = advancement.m_138320_();
        if (display == null || !display.m_14996_()) {
            return;
        }
        RegistryObject<Item> registryObject = trophyItem = display.m_14997_() ? ModItems.NETHERITE_TROPHY : FRAME_TYPE_TO_TROPHY.get(display.m_14992_());
        if (trophyItem == null) {
            return;
        }
        ItemStack trophyStack = new ItemStack((ItemLike)trophyItem.get());
        CompoundTag nbt = trophyStack.m_41784_();
        nbt.m_128359_("achiever", player.m_7755_().getString());
        CompoundTag dateTag = new CompoundTag();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        dateTag.m_128405_("year", cal.get(1));
        dateTag.m_128405_("month", cal.get(2) + 1);
        dateTag.m_128405_("day", cal.get(5));
        dateTag.m_128405_("hour", cal.get(11));
        dateTag.m_128405_("minute", cal.get(12));
        dateTag.m_128405_("second", cal.get(13));
        nbt.m_128365_("date", (Tag)dateTag);
        nbt.m_128359_("advancement_id", advancement.m_138327_().toString());
        Component advancementTitleComponent = display.m_14977_();
        ComponentContents componentContents = advancementTitleComponent.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            nbt.m_128359_("advancement_title", contents.m_237508_());
        } else {
            nbt.m_128359_("advancement_title_json", Component.Serializer.m_130703_((Component)advancementTitleComponent));
        }
        nbt.m_128359_("advancement_mod", advancement.m_138327_().m_135827_());
        CompoundTag iconTag = new CompoundTag();
        display.m_14990_().m_41739_(iconTag);
        nbt.m_128365_("icon", (Tag)iconTag);
        ItemStack trophyRemainder = trophyStack.m_41777_();
        for (int i = 0; !(i >= player.m_150109_().m_6643_() || (inventoryStack = player.m_150109_().m_8020_(i)).m_41720_() instanceof TrophyCrateItem && (trophyRemainder = TrophyCrateItem.addItemToCrate(inventoryStack, trophyRemainder)).m_41619_()); ++i) {
        }
        if (!trophyRemainder.m_41619_() && !player.m_150109_().m_36054_(trophyRemainder)) {
            player.m_36176_(trophyRemainder, false);
            player.m_213846_((Component)Component.m_264568_((String)"message.advancementtrophies.inventory_full", (String)"Your inventory is full! The trophy has been dropped nearby."));
        }
    }
}

