/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.item;

import io.github.hikoma0000.advancementtrophies.client.util.TooltipUtils;
import io.github.hikoma0000.advancementtrophies.config.client.input.KeyBindings;
import io.github.hikoma0000.advancementtrophies.init.ModItems;
import io.github.hikoma0000.advancementtrophies.item.TrophyCrateItemMenuProvider;
import io.github.hikoma0000.advancementtrophies.util.TrophyRarity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TrophyCrateItem
extends BlockItem {
    public TrophyCrateItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.isLocked(itemstack) && !this.canOpen(itemstack, pPlayer)) {
            pPlayer.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{itemstack.m_41786_()}), true);
            pPlayer.m_5496_(SoundEvents.f_11748_, 1.0f, 1.0f);
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!pLevel.m_5776_()) {
            TrophyCrateItemMenuProvider menuProvider = new TrophyCrateItemMenuProvider(itemstack, pHand);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)menuProvider, buf -> buf.m_130068_((Enum)pHand));
            pPlayer.m_36220_(Stats.f_12971_);
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11725_, SoundSource.PLAYERS, 0.5f, pLevel.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
    }

    private boolean isLocked(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41737_("BlockEntityTag");
        return compoundtag != null && compoundtag.m_128425_("Lock", 8) && !compoundtag.m_128461_("Lock").isEmpty();
    }

    private boolean canOpen(ItemStack pStack, Player pPlayer) {
        CompoundTag compoundtag = pStack.m_41737_("BlockEntityTag");
        if (compoundtag == null || !compoundtag.m_128425_("Lock", 8)) {
            return true;
        }
        String s = compoundtag.m_128461_("Lock");
        return s.isEmpty() || pPlayer.m_21093_(item -> item.m_41788_() && item.m_41786_().getString().equals(s));
    }

    public void m_142023_(ItemEntity pItemEntity) {
        CompoundTag blockEntityTag = pItemEntity.m_32055_().m_41737_("BlockEntityTag");
        if (blockEntityTag != null) {
            NonNullList items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)blockEntityTag, (NonNullList)items);
            for (ItemStack stackInSlot : items) {
                if (stackInSlot.m_41619_()) continue;
                pItemEntity.m_9236_().m_7967_((Entity)new ItemEntity(pItemEntity.m_9236_(), pItemEntity.m_20185_(), pItemEntity.m_20186_(), pItemEntity.m_20189_(), stackInSlot));
            }
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.advancementtrophies.trophy_crate.description").m_130940_(ChatFormatting.GRAY));
        if (KeyBindings.isDetailsKeyDown) {
            CompoundTag blockEntityTag = pStack.m_41737_("BlockEntityTag");
            if (blockEntityTag != null) {
                NonNullList items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)blockEntityTag, (NonNullList)items);
                if (items.stream().anyMatch(item -> !item.m_41619_())) {
                    pTooltipComponents.add((Component)Component.m_237113_((String)""));
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.advancementtrophies.trophy_crate.contents").m_130940_(ChatFormatting.GRAY));
                    int iron = 0;
                    int gold = 0;
                    int diamond = 0;
                    int netherite = 0;
                    for (ItemStack stackInSlot : items) {
                        if (stackInSlot.m_41720_() == ModItems.IRON_TROPHY.get()) {
                            ++iron;
                            continue;
                        }
                        if (stackInSlot.m_41720_() == ModItems.GOLD_TROPHY.get()) {
                            ++gold;
                            continue;
                        }
                        if (stackInSlot.m_41720_() == ModItems.DIAMOND_TROPHY.get()) {
                            ++diamond;
                            continue;
                        }
                        if (stackInSlot.m_41720_() != ModItems.NETHERITE_TROPHY.get()) continue;
                        ++netherite;
                    }
                    if (iron > 0) {
                        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"rarity.advancementtrophies.iron")).m_130946_(": " + iron).m_130940_(TrophyRarity.IRON.getItemRarity().f_43022_));
                    }
                    if (gold > 0) {
                        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"rarity.advancementtrophies.gold")).m_130946_(": " + gold).m_130940_(TrophyRarity.GOLD.getItemRarity().f_43022_));
                    }
                    if (diamond > 0) {
                        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"rarity.advancementtrophies.diamond")).m_130946_(": " + diamond).m_130940_(TrophyRarity.DIAMOND.getItemRarity().f_43022_));
                    }
                    if (netherite > 0) {
                        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"rarity.advancementtrophies.netherite")).m_130946_(": " + netherite).m_130940_(TrophyRarity.NETHERITE.getItemRarity().f_43022_));
                    }
                }
            }
        } else {
            TooltipUtils.addHoldForDetailsTooltip(pTooltipComponents);
        }
    }

    public static ItemStack addItemToCrate(ItemStack crateStack, ItemStack trophyStack) {
        if (!(crateStack.m_41720_() instanceof TrophyCrateItem) || !ModItems.isTrophy(trophyStack)) {
            return trophyStack;
        }
        CompoundTag blockEntityTag = crateStack.m_41698_("BlockEntityTag");
        NonNullList items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)blockEntityTag, (NonNullList)items);
        ItemStack remainder = trophyStack.m_41777_();
        for (int i = 0; i < items.size() && !remainder.m_41619_(); ++i) {
            ItemStack current = (ItemStack)items.get(i);
            if (current.m_41619_()) {
                items.set(i, (Object)remainder.m_41620_(remainder.m_41741_()));
                continue;
            }
            if (!ItemStack.m_150942_((ItemStack)current, (ItemStack)remainder) || current.m_41613_() >= current.m_41741_()) continue;
            int toAdd = Math.min(remainder.m_41613_(), current.m_41741_() - current.m_41613_());
            current.m_41769_(toAdd);
            remainder.m_41774_(toAdd);
        }
        ContainerHelper.m_18973_((CompoundTag)blockEntityTag, (NonNullList)items);
        return remainder;
    }
}

