/*
 * Decompiled with CFR 0.152.
 */
package io.github.hikoma0000.advancementtrophies.item;

import io.github.hikoma0000.advancementtrophies.block.entity.TrophyBlockEntity;
import io.github.hikoma0000.advancementtrophies.client.util.TooltipUtils;
import io.github.hikoma0000.advancementtrophies.config.ClientConfig;
import io.github.hikoma0000.advancementtrophies.config.client.input.KeyBindings;
import io.github.hikoma0000.advancementtrophies.util.TrophyUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TrophyItem
extends BlockItem {
    public TrophyItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    protected boolean m_7274_(BlockPos pPos, Level pLevel, @Nullable Player pPlayer, ItemStack pStack, BlockState pState) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyBlockEntity = (TrophyBlockEntity)blockEntity;
            CompoundTag nbt = pStack.m_41783_();
            if (nbt != null) {
                trophyBlockEntity.setTrophyData(nbt.m_6426_());
            }
        }
        return super.m_7274_(pPos, pLevel, pPlayer, pStack, pState);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        CompoundTag nbt = pStack.m_41783_();
        if (nbt == null) {
            pTooltipComponents.add((Component)Component.m_264568_((String)"tooltip.advancementtrophies.empty", (String)"Unclaimed Trophy").m_130940_(ChatFormatting.GRAY));
            return;
        }
        if (KeyBindings.isDetailsKeyDown) {
            Component advancementTitle;
            if (nbt.m_128425_("achiever", 8)) {
                pTooltipComponents.add((Component)Component.m_264642_((String)"tooltip.advancementtrophies.achiever", (String)"Achiever: %s", (Object[])new Object[]{nbt.m_128461_("achiever")}).m_130940_(ChatFormatting.GRAY));
            }
            if (nbt.m_128425_("date", 10)) {
                CompoundTag dateTag = nbt.m_128469_("date");
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.set(dateTag.m_128451_("year"), dateTag.m_128451_("month") - 1, dateTag.m_128451_("day"), dateTag.m_128451_("hour"), dateTag.m_128451_("minute"), dateTag.m_128451_("second"));
                    SimpleDateFormat sdf = new SimpleDateFormat((String)ClientConfig.DATE_FORMAT.get());
                    String formattedDate = sdf.format(cal.getTime());
                    pTooltipComponents.add((Component)Component.m_264642_((String)"tooltip.advancementtrophies.date.format", (String)"Date: %s", (Object[])new Object[]{formattedDate}).m_130940_(ChatFormatting.GRAY));
                }
                catch (Exception e) {
                    pTooltipComponents.add((Component)Component.m_237113_((String)"Date: Invalid Format").m_130940_(ChatFormatting.RED));
                }
            }
            if ((advancementTitle = TrophyUtils.getAdvancementTitleFromNBT(nbt)) != null) {
                pTooltipComponents.add((Component)Component.m_237113_((String)""));
                pTooltipComponents.add((Component)Component.m_264642_((String)"tooltip.advancementtrophies.advancement", (String)"Advancement: %s", (Object[])new Object[]{advancementTitle}).m_130940_(ChatFormatting.GOLD));
            }
            if (nbt.m_128425_("advancement_mod", 8)) {
                pTooltipComponents.add((Component)Component.m_264642_((String)"tooltip.advancementtrophies.mod", (String)"Mod: %s", (Object[])new Object[]{nbt.m_128461_("advancement_mod")}).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
            }
        } else {
            TooltipUtils.addHoldForDetailsTooltip(pTooltipComponents);
        }
    }

    public Component m_7626_(ItemStack pStack) {
        Component advancementTitle;
        CompoundTag nbt = pStack.m_41783_();
        if (nbt != null && (advancementTitle = TrophyUtils.getAdvancementTitleFromNBT(nbt)) != null) {
            return Component.m_264642_((String)"item.advancementtrophies.trophy.named", (String)"Trophy of %s", (Object[])new Object[]{advancementTitle});
        }
        return super.m_7626_(pStack);
    }
}

