/*
 * Decompiled with CFR 0.152.
 */
package net.mandalacreations.clean_tooltips.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.mandalacreations.clean_tooltips.CleanTooltips;
import net.mandalacreations.clean_tooltips.client.TooltipSection;
import net.mandalacreations.clean_tooltips.client.config.ClientConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class EnchantmentSection
extends TooltipSection {
    private static final Component ENCHANTMENTS = Component.translatable((String)"item.clean_tooltips.enchantments").withStyle(ChatFormatting.GRAY);
    private static final MutableComponent SPACE = Component.literal((String)" ");
    private final ItemEnchantments enchantments;
    private final List<Component> curses = new ArrayList<Component>();
    private final boolean isEnchantedBook;

    public EnchantmentSection(Consumer<Component> consumer, ItemEnchantments enchantments, boolean isEnchantedBook) {
        super(consumer, ClientConfig.INSTANCE.enchantmentSectionEnabled());
        this.enchantments = enchantments;
        this.isEnchantedBook = isEnchantedBook;
    }

    public static boolean create(Consumer<Component> consumer, ItemEnchantments enchantments, boolean isEnchantedBook) {
        EnchantmentSection section = new EnchantmentSection(consumer, enchantments, isEnchantedBook);
        section.create();
        return section.isEnabled();
    }

    @Override
    protected void buildSection() {
        this.enchantments.entrySet().forEach(entry -> this.handleEnchantment((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue()));
        this.curses.forEach(this::addComponent);
    }

    private void handleEnchantment(Holder<Enchantment> enchantment, int level) {
        ChatFormatting color = this.getColor(enchantment, level);
        MutableComponent component = SPACE.copy().append((Component)Enchantment.getFullname(enchantment, (int)level).copy().withStyle(color));
        if (enchantment.is(EnchantmentTags.CURSE)) {
            this.addComponent(enchantment, (Component)component, this.curses::add);
            return;
        }
        this.addComponent(enchantment, (Component)component, this::addComponent);
    }

    private void addComponent(Holder<Enchantment> enchantment, Component component, Consumer<Component> consumer) {
        consumer.accept(component);
        if (CleanTooltips.ENCHANTMENT_DESCRIPTIONS_LOADED && this.isEnchantedBook) {
            this.getDescriptionKey((Enchantment)enchantment.value()).ifPresent(key -> consumer.accept((Component)SPACE.copy().append((Component)Component.translatable((String)key).withStyle(ChatFormatting.DARK_GRAY))));
        }
    }

    private Optional<String> getDescriptionKey(Enchantment enchantment) {
        String key = enchantment.description().getString() + ".desc";
        if (!I18n.exists((String)key)) {
            if (!I18n.exists((String)(enchantment.description().getString() + ".description"))) {
                return Optional.empty();
            }
            key = enchantment.description().getString() + ".description";
        }
        return Optional.of(key);
    }

    private ChatFormatting getColor(Holder<Enchantment> enchantment, int level) {
        if (enchantment.is(EnchantmentTags.CURSE)) {
            return (ChatFormatting)ClientConfig.INSTANCE.curseEnchantmentColor().get();
        }
        int maxLevel = ((Enchantment)enchantment.value()).getMaxLevel();
        if (level >= maxLevel) {
            return maxLevel == level ? (ChatFormatting)ClientConfig.INSTANCE.maxLevelEnchantmentColor().get() : (ChatFormatting)ClientConfig.INSTANCE.aboveMaxLevelEnchantmentColor().get();
        }
        return (ChatFormatting)ClientConfig.INSTANCE.normalEnchantmentColor().get();
    }

    @Override
    public boolean shouldDisplay() {
        return !this.enchantments.isEmpty();
    }

    @Override
    @Nullable
    protected Component getHeader() {
        return ENCHANTMENTS;
    }
}

