/*
 * Decompiled with CFR 0.152.
 */
package net.mandalacreations.clean_tooltips.client.config;

import net.minecraft.ChatFormatting;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public record ClientConfig(ModConfigSpec.BooleanValue durabilitySectionEnabled, ModConfigSpec.BooleanValue enchantmentSectionEnabled, ModConfigSpec.EnumValue<ChatFormatting> curseEnchantmentColor, ModConfigSpec.EnumValue<ChatFormatting> normalEnchantmentColor, ModConfigSpec.EnumValue<ChatFormatting> maxLevelEnchantmentColor, ModConfigSpec.EnumValue<ChatFormatting> aboveMaxLevelEnchantmentColor, ModConfigSpec.BooleanValue colorSectionEnabled, ModConfigSpec.BooleanValue gapEnabled) {
    public static final IConfigSpec SPEC;
    public static final ClientConfig INSTANCE;

    public ClientConfig(ModConfigSpec.Builder build) {
        this(build.comment("Should the Durability section be enabled?").define("durability.enabled", true), build.comment("Should the fancied up Enchantment section be used?").define("enchantments.enabled", true), (ModConfigSpec.EnumValue<ChatFormatting>)build.comment("The color curses should have").defineEnum("enchantments.color.curse", (Enum)ChatFormatting.RED), (ModConfigSpec.EnumValue<ChatFormatting>)build.comment("The color normal enchantments should have").defineEnum("enchantments.color.normal", (Enum)ChatFormatting.GREEN), (ModConfigSpec.EnumValue<ChatFormatting>)build.comment("The color max level enchantments should have").defineEnum("enchantments.color.max_level", (Enum)ChatFormatting.GOLD), (ModConfigSpec.EnumValue<ChatFormatting>)build.comment("The color enchantments above the max level should have").defineEnum("enchantments.color.above_max_level", (Enum)ChatFormatting.YELLOW), build.comment("Should the fancied up Color section be used?").define("color.enabled", true), build.comment("Should sections of the tooltip have spacing between them?").define("gap.enabled", true));
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (IConfigSpec)specPair.getRight();
        INSTANCE = (ClientConfig)specPair.getLeft();
    }
}

