/*
 * Decompiled with CFR 0.152.
 */
package net.mandalacreations.clean_tooltips.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.mandalacreations.clean_tooltips.CleanTooltips;
import net.mandalacreations.clean_tooltips.client.TooltipSection;
import net.mandalacreations.clean_tooltips.client.config.ClientConfig;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class EnchantmentSection
extends TooltipSection {
    private static final class_2561 ENCHANTMENTS = class_2561.method_43471((String)"item.clean_tooltips.enchantments").method_27692(class_124.field_1080);
    private static final class_5250 SPACE = class_2561.method_43470((String)" ");
    private final class_9304 enchantments;
    private final List<class_2561> curses = new ArrayList<class_2561>();
    private final boolean isEnchantedBook;

    public EnchantmentSection(Consumer<class_2561> consumer, class_9304 enchantments, boolean isEnchantedBook) {
        super(consumer, ClientConfig.INSTANCE.enchantmentSectionEnabled());
        this.enchantments = enchantments;
        this.isEnchantedBook = isEnchantedBook;
    }

    public static boolean create(Consumer<class_2561> consumer, class_9304 enchantments, boolean isEnchantedBook) {
        EnchantmentSection section = new EnchantmentSection(consumer, enchantments, isEnchantedBook);
        section.create();
        return section.isEnabled();
    }

    @Override
    protected void buildSection() {
        this.enchantments.method_57539().forEach(entry -> this.handleEnchantment((class_6880<class_1887>)((class_6880)entry.getKey()), entry.getIntValue()));
        this.curses.forEach(this::addComponent);
    }

    private void handleEnchantment(class_6880<class_1887> enchantment, int level) {
        class_124 color = this.getColor(enchantment, level);
        class_5250 component = SPACE.method_27661().method_10852((class_2561)class_1887.method_8179(enchantment, (int)level).method_27661().method_27692(color));
        if (enchantment.method_40220(class_9636.field_51551)) {
            this.addComponent(enchantment, (class_2561)component, this.curses::add);
            return;
        }
        this.addComponent(enchantment, (class_2561)component, this::addComponent);
    }

    private void addComponent(class_6880<class_1887> enchantment, class_2561 component, Consumer<class_2561> consumer) {
        consumer.accept(component);
        if (CleanTooltips.ENCHANTMENT_DESCRIPTIONS_LOADED && this.isEnchantedBook) {
            this.getDescriptionKey((class_1887)enchantment.comp_349()).ifPresent(key -> consumer.accept((class_2561)SPACE.method_27661().method_10852((class_2561)class_2561.method_43471((String)key).method_27692(class_124.field_1063))));
        }
    }

    private Optional<String> getDescriptionKey(class_1887 enchantment) {
        String key = enchantment.comp_2686().getString() + ".desc";
        if (!class_1074.method_4663((String)key)) {
            if (!class_1074.method_4663((String)(enchantment.comp_2686().getString() + ".description"))) {
                return Optional.empty();
            }
            key = enchantment.comp_2686().getString() + ".description";
        }
        return Optional.of(key);
    }

    private class_124 getColor(class_6880<class_1887> enchantment, int level) {
        if (enchantment.method_40220(class_9636.field_51551)) {
            return (class_124)ClientConfig.INSTANCE.curseEnchantmentColor().get();
        }
        int maxLevel = ((class_1887)enchantment.comp_349()).method_8183();
        if (level >= maxLevel) {
            return maxLevel == level ? (class_124)ClientConfig.INSTANCE.maxLevelEnchantmentColor().get() : (class_124)ClientConfig.INSTANCE.aboveMaxLevelEnchantmentColor().get();
        }
        return (class_124)ClientConfig.INSTANCE.normalEnchantmentColor().get();
    }

    @Override
    public boolean shouldDisplay() {
        return !this.enchantments.method_57543();
    }

    @Override
    @Nullable
    protected class_2561 getHeader() {
        return ENCHANTMENTS;
    }
}

