/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.CNPC.Jutsus;

import net.minecraft.entity.Entity;
import noppes.npcs.api.entity.ICustomNpc;

public abstract class BaseProjectileJutsu {
    protected final String cooldownKey;
    protected final String percentBaseKey;
    protected final String percentKey;
    protected final int defaultCooldown;
    protected final double defaultDamage;

    protected BaseProjectileJutsu(String cooldownKey, String percentBaseKey, String percentKey, int defaultCooldown, double defaultDamage) {
        this.cooldownKey = cooldownKey;
        this.percentBaseKey = percentBaseKey;
        this.percentKey = percentKey;
        this.defaultCooldown = defaultCooldown;
        this.defaultDamage = defaultDamage;
    }

    protected abstract Entity createProjectile(ICustomNpc var1, double var2);

    protected boolean doCast(ICustomNpc npc) {
        return this.doCast(npc, this.defaultDamage, this.defaultCooldown);
    }

    protected boolean doCast(ICustomNpc npc, double damage) {
        return this.doCast(npc, damage, this.defaultCooldown);
    }

    protected boolean doCast(ICustomNpc npc, double damage, int cooldownTicks) {
        if (!npc.isAlive()) {
            return false;
        }
        if (npc.hasTempData(this.cooldownKey)) {
            long last = (Long)npc.getTempData(this.cooldownKey);
            long now = npc.getWorld().getMCWorld().func_82737_E();
            if (now - last < (long)cooldownTicks) {
                return false;
            }
        }
        npc.removeTempData(this.percentBaseKey);
        npc.removeTempData(this.percentKey);
        Entity projectile = this.createProjectile(npc, damage);
        if (projectile == null) {
            System.err.println("[BaseProjectileJutsu] Failed to create projectile for " + this.getClass().getSimpleName());
            return false;
        }
        npc.getWorld().getMCWorld().func_72838_d(projectile);
        npc.setTempData(this.cooldownKey, (Object)npc.getWorld().getMCWorld().func_82737_E());
        return true;
    }

    protected boolean doPercent(ICustomNpc npc, double baseDamage, double percentHP) {
        return this.doPercent(npc, baseDamage, percentHP, this.defaultCooldown);
    }

    protected boolean doPercent(ICustomNpc npc, double baseDamage, double percentHP, int cooldownTicks) {
        if (!npc.isAlive()) {
            return false;
        }
        if (npc.hasTempData(this.cooldownKey)) {
            long last = (Long)npc.getTempData(this.cooldownKey);
            long now = npc.getWorld().getMCWorld().func_82737_E();
            if (now - last < (long)cooldownTicks) {
                return false;
            }
        }
        npc.setTempData(this.percentBaseKey, (Object)baseDamage);
        npc.setTempData(this.percentKey, (Object)percentHP);
        Entity projectile = this.createProjectile(npc, baseDamage);
        if (projectile == null) {
            System.err.println("[BaseProjectileJutsu] Failed to create projectile for " + this.getClass().getSimpleName());
            return false;
        }
        npc.getWorld().getMCWorld().func_72838_d(projectile);
        npc.setTempData(this.cooldownKey, (Object)npc.getWorld().getMCWorld().func_82737_E());
        return true;
    }

    protected int doGetCooldown(ICustomNpc npc, int cooldownTicks) {
        if (npc.hasTempData(this.cooldownKey)) {
            long last = (Long)npc.getTempData(this.cooldownKey);
            long now = npc.getWorld().getMCWorld().func_82737_E();
            long elapsed = now - last;
            if (elapsed < (long)cooldownTicks) {
                return (int)((long)cooldownTicks - elapsed);
            }
        }
        return 0;
    }

    protected void doResetCooldown(ICustomNpc npc) {
        npc.removeTempData(this.cooldownKey);
    }

    public String getPercentBaseKey() {
        return this.percentBaseKey;
    }

    public String getPercentKey() {
        return this.percentKey;
    }
}

