/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.CNPC.Jutsus;

import noppes.npcs.api.entity.ICustomNpc;

public class SusanoJutsu {
    public static boolean activate(ICustomNpc npc, int stage) {
        if (!npc.isAlive() || stage < 1 || stage > 4) {
            return false;
        }
        npc.setStoredData("susanoActive", (Object)true);
        npc.setStoredData("susanoStage", (Object)stage);
        npc.setTitle("\u00a75[Susano'o " + SusanoJutsu.getStageName(stage) + "]");
        System.out.println("[Susano] Activated stage " + stage + " for NPC " + npc.getName() + " (ID: " + npc.getMCEntity().func_145782_y() + ")");
        return true;
    }

    public static void deactivate(ICustomNpc npc) {
        npc.removeStoredData("susanoActive");
        npc.removeStoredData("susanoStage");
        npc.setTitle("");
        System.out.println("[Susano] Deactivated for NPC " + npc.getName());
    }

    public static boolean upgrade(ICustomNpc npc) {
        int stage;
        if (!npc.hasStoredData("susanoActive")) {
            return false;
        }
        int n = stage = npc.hasStoredData("susanoStage") ? ((Number)npc.getStoredData("susanoStage")).intValue() : 1;
        if (stage >= 4) {
            return false;
        }
        return SusanoJutsu.activate(npc, stage + 1);
    }

    public static boolean downgrade(ICustomNpc npc) {
        int stage;
        if (!npc.hasStoredData("susanoActive")) {
            return false;
        }
        int n = stage = npc.hasStoredData("susanoStage") ? ((Number)npc.getStoredData("susanoStage")).intValue() : 1;
        if (stage <= 1) {
            return false;
        }
        return SusanoJutsu.activate(npc, stage - 1);
    }

    public static int getStage(ICustomNpc npc) {
        if (!npc.hasStoredData("susanoActive")) {
            return 0;
        }
        return ((Number)npc.getStoredData("susanoStage")).intValue();
    }

    public static boolean isActive(ICustomNpc npc) {
        return npc.hasStoredData("susanoActive") && (Boolean)npc.getStoredData("susanoActive") != false;
    }

    private static String getStageName(int stage) {
        switch (stage) {
            case 1: {
                return "Cage";
            }
            case 2: {
                return "Skeleton";
            }
            case 3: {
                return "Complete";
            }
            case 4: {
                return "Armor";
            }
        }
        return "Unknown";
    }
}

