/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.CNPC;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.entity.EntityCustomNpc;
import org.lwjgl.opengl.GL11;

public class NPCSusanoRenderer {
    private static final IModelCustom models1 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tm:models/susano/models1.obj"));
    private static final IModelCustom cagemodel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tm:models/susano/cage.obj"));
    private static final IModelCustom SasukeSkeletonModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tm:models/susano/sasuke.obj"));
    private static final IModelCustom ShisuiRebra3model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tm:models/susano/stage3.obj"));
    private static final ResourceLocation SusanoCageMadara = new ResourceLocation("tm:textures/susano/madara/cage.png");
    private static final ResourceLocation SusanoSkeletonMadara = new ResourceLocation("tm:textures/susano/madara/skeleton.png");
    private static final ResourceLocation SusanoCompleteMadara = new ResourceLocation("tm:textures/susano/madara/complete.png");
    private static final ResourceLocation SusanoArmorMadara = new ResourceLocation("tm:textures/susano/madara/armor.png");
    private final Map<Integer, SusanoAnimationData> animationData = new HashMap<Integer, SusanoAnimationData>();

    @SubscribeEvent
    public void onRenderNPC(RenderLivingEvent.Post event) {
        if (!(event.entity instanceof EntityCustomNpc)) {
            return;
        }
        EntityCustomNpc npc = (EntityCustomNpc)event.entity;
        ICustomNpc wrapped = npc.wrappedNPC;
        if (wrapped == null) {
            System.out.println("[Susano Renderer] ERROR: Wrapped NPC is null!");
            return;
        }
        System.out.println("[Susano Renderer] Checking NPC: " + wrapped.getName() + " (ID: " + npc.func_145782_y() + ")");
        System.out.println("[Susano Renderer] hasStoredData('susanoActive'): " + wrapped.hasStoredData("susanoActive"));
        if (wrapped.hasStoredData("susanoActive")) {
            Object activeValue = wrapped.getStoredData("susanoActive");
            Object stageValue = wrapped.getStoredData("susanoStage");
            System.out.println("[Susano Renderer] susanoActive = " + activeValue + " (type: " + (activeValue != null ? activeValue.getClass().getName() : "null") + ")");
            System.out.println("[Susano Renderer] susanoStage = " + stageValue);
        }
        if (!wrapped.hasStoredData("susanoActive") || !((Boolean)wrapped.getStoredData("susanoActive")).booleanValue()) {
            System.out.println("[Susano Renderer] Not rendering - Susano not active");
            this.animationData.remove(npc.func_145782_y());
            return;
        }
        int stage = ((Number)wrapped.getStoredData("susanoStage")).intValue();
        System.out.println("[Susano Renderer] *** RENDERING STAGE " + stage + " ***");
        int entityId = npc.func_145782_y();
        SusanoAnimationData data = this.animationData.get(entityId);
        if (data == null) {
            data = new SusanoAnimationData();
            this.animationData.put(entityId, data);
            System.out.println("[Susano Renderer] Created new animation data");
        }
        if (data.lastStage != stage) {
            data.cageOpacity = 0.0f;
            data.skeletonOpacity = 0.0f;
            data.completeOpacity = 0.0f;
            data.armorOpacity = 0.0f;
            data.lastStage = stage;
            System.out.println("[Susano Renderer] Stage changed, reset opacity");
        }
        System.out.println("[Susano Renderer] Current opacity: " + (stage == 1 ? data.cageOpacity : (stage == 2 ? data.skeletonOpacity : (stage == 3 ? data.completeOpacity : data.armorOpacity))));
        GL11.glPushMatrix();
        GL11.glTranslated((double)event.x, (double)event.y, (double)event.z);
        try {
            switch (stage) {
                case 1: {
                    System.out.println("[Susano Renderer] Calling renderSusanoCage");
                    this.renderSusanoCage(data);
                    break;
                }
                case 2: {
                    System.out.println("[Susano Renderer] Calling renderSusanoSkeleton");
                    this.renderSusanoSkeleton(data);
                    break;
                }
                case 3: {
                    System.out.println("[Susano Renderer] Calling renderCompleteSusano");
                    this.renderCompleteSusano(data);
                    break;
                }
                case 4: {
                    System.out.println("[Susano Renderer] Calling renderSusanoArmor");
                    this.renderSusanoArmor(data);
                }
            }
            System.out.println("[Susano Renderer] Render complete!");
        }
        catch (Exception e) {
            System.err.println("[Susano Renderer] ERROR during rendering:");
            e.printStackTrace();
        }
        GL11.glPopMatrix();
    }

    private void renderSusanoCage(SusanoAnimationData data) {
        if (data.cageOpacity < 0.75f) {
            data.cageOpacity += 0.008f;
            if (data.cageOpacity > 0.75f) {
                data.cageOpacity = 0.75f;
            }
        }
        if (data.scaled < 1.0f) {
            data.scaled = 1.0f;
        }
        if (data.nextScaled < 1.0f) {
            data.nextScaled = 1.0f;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)data.cageOpacity);
        GL11.glScaled((double)(data.nextScaled + 3.0f), (double)(data.nextScaled + 3.0f), (double)(data.nextScaled + 3.0f));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)0.15, (double)0.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SusanoCageMadara);
        cagemodel.renderAll();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void renderSusanoSkeleton(SusanoAnimationData data) {
        if (data.skeletonOpacity < 0.75f) {
            data.skeletonOpacity += 0.008f;
            if (data.skeletonOpacity > 0.75f) {
                data.skeletonOpacity = 0.75f;
            }
        }
        if (data.scaled < 1.0f) {
            data.scaled = 1.0f;
        }
        if (data.nextScaled < 1.0f) {
            data.nextScaled = 1.0f;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)data.skeletonOpacity);
        GL11.glScaled((double)(data.nextScaled + 3.0f), (double)(data.nextScaled + 3.0f), (double)(data.nextScaled + 3.0f));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)0.2, (double)-0.3);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SusanoSkeletonMadara);
        SasukeSkeletonModel.renderAll();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void renderCompleteSusano(SusanoAnimationData data) {
        if (data.completeOpacity < 0.75f) {
            data.completeOpacity += 0.008f;
            if (data.completeOpacity > 0.75f) {
                data.completeOpacity = 0.75f;
            }
        }
        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        if (data.nextScaled <= 1.0f) {
            data.nextScaled = (float)((double)data.nextScaled + (double)(data.scaled - data.nextScaled) * 0.1);
        }
        if (data.scaled < 1.0f) {
            data.scaled = (float)((double)data.scaled + 0.021);
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)data.completeOpacity);
        GL11.glScaled((double)(data.nextScaled + 4.0f), (double)(data.nextScaled + 4.0f), (double)(data.nextScaled + 4.0f));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)0.3, (double)-0.15);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SusanoCompleteMadara);
        ShisuiRebra3model.renderAll();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void renderSusanoArmor(SusanoAnimationData data) {
        if (data.armorOpacity < 0.75f) {
            data.armorOpacity += 0.008f;
            if (data.armorOpacity > 0.75f) {
                data.armorOpacity = 0.75f;
            }
        }
        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        if (data.rotate == 0 && data.time2 <= 180) {
            ++data.time2;
            if (data.time2 >= 180) {
                data.rotate = 1;
            }
        } else if (data.rotate == 1) {
            --data.time2;
            if (data.time2 == 0) {
                data.rotate = 0;
            }
        }
        if (data.nextScaled <= 1.0f) {
            data.nextScaled = (float)((double)data.nextScaled + (double)(data.scaled - data.nextScaled) * 0.1);
        }
        if (data.scaled < 1.0f) {
            data.scaled = (float)((double)data.scaled + 0.021);
        }
        GL11.glPushMatrix();
        GL11.glScaled((double)(data.nextScaled + 1.0f), (double)(data.nextScaled + 1.0f), (double)(data.nextScaled + 1.0f));
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)data.armorOpacity);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SusanoArmorMadara);
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslatef((float)0.0f, (float)-0.6f, (float)0.0f);
        models1.renderPart("body_susanoo_completo2");
        GL11.glPushMatrix();
        GL11.glRotatef((float)((float)data.time2 * 0.05f), (float)0.0f, (float)0.0f, (float)1.0f);
        models1.renderPart("larm_bone7.034");
        GL11.glPopMatrix();
        GL11.glRotatef((float)((float)data.time2 * -0.05f), (float)0.0f, (float)0.0f, (float)1.0f);
        models1.renderPart("rarm_bone7.077");
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private static class SusanoAnimationData {
        float cageOpacity = 0.0f;
        float skeletonOpacity = 0.0f;
        float completeOpacity = 0.0f;
        float armorOpacity = 0.0f;
        float scaled = 1.0f;
        float nextScaled = 1.0f;
        int time2 = 0;
        int rotate = 0;
        int lastStage = 0;

        private SusanoAnimationData() {
        }
    }
}

