/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncGenjutsuMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncKenjutsuMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncKinjutsuMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncNinjutsuMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncSenjutsuMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncShurikenjutsuMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncSkillPointsMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncSpeedMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncSummoningMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncTaijutsuMessage;
import narutodestination.Mathioks.PacketDispatcher;
import narutodestination.Mathioks.TransformationsRealPackage.SyncHealthMessage;
import narutodestination.Mathioks.TransformationsRealPackage.SyncMedicalMessage;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandInvestSP
extends CommandBase {
    private static final String[] STATS = new String[]{"ninjutsu", "taijutsu", "medical", "kenjutsu", "kinjutsu", "genjutsu", "senjutsu", "speed", "shurikenjutsu", "summoning"};

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "investsp";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/investsp <stat> <amount|all> [player] OR /investsp <percentages> <amount|all> [player]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayer senderPlayer;
        EntityPlayerMP possiblePlayer;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayer targetPlayer = null;
        int playerArgIndex = -1;
        if (args.length >= 3 && (possiblePlayer = CommandInvestSP.func_82359_c((ICommandSender)sender, (String)args[args.length - 1])) != null) {
            targetPlayer = possiblePlayer;
            playerArgIndex = args.length - 1;
        }
        if (targetPlayer == null) {
            if (sender instanceof EntityPlayer) {
                targetPlayer = (EntityPlayer)sender;
            } else {
                throw new WrongUsageException("You must specify a player when running from console.", new Object[0]);
            }
        }
        if (targetPlayer != sender && sender instanceof EntityPlayer && !this.canUseCommand(senderPlayer = (EntityPlayer)sender, this.func_82362_a(), this.func_71517_b()) && this.func_82362_a() > 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("You don't have permission to use this command on other players."));
            return;
        }
        ExtendedPlayer props = ExtendedPlayer.get(targetPlayer);
        String[] effectiveArgs = args;
        if (playerArgIndex != -1) {
            effectiveArgs = Arrays.copyOf(args, playerArgIndex);
        }
        if (effectiveArgs.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (effectiveArgs[0].contains("%")) {
            this.handlePercentageDistribution(sender, targetPlayer, props, effectiveArgs);
        } else {
            this.handleSimpleInvest(sender, targetPlayer, props, effectiveArgs);
        }
    }

    private void handlePercentageDistribution(ICommandSender sender, EntityPlayer player, ExtendedPlayer props, String[] args) {
        int totalPoints;
        String percentageString = args[0];
        String amountArg = args[1];
        if ("all".equalsIgnoreCase(amountArg)) {
            totalPoints = props.getSkillPoints();
        } else {
            try {
                totalPoints = Integer.parseInt(amountArg);
            }
            catch (NumberFormatException e) {
                throw new WrongUsageException("Amount must be a number or 'all'", new Object[0]);
            }
            if (totalPoints > props.getSkillPoints()) {
                String playerName = player == sender ? "You don't" : player.getDisplayName() + " doesn't";
                sender.func_145747_a((IChatComponent)new ChatComponentText(playerName + " have enough Skill Points. Available: " + props.getSkillPoints()));
                return;
            }
        }
        if (totalPoints <= 0) {
            String playerName = player == sender ? "You have" : player.getDisplayName() + " has";
            sender.func_145747_a((IChatComponent)new ChatComponentText(playerName + " no Skill Points to invest."));
            return;
        }
        String[] parts = percentageString.split(",");
        LinkedHashMap<String, Integer> percentages = new LinkedHashMap<String, Integer>();
        int totalPercentage = 0;
        for (String part : parts) {
            int percent;
            if (!(part = part.trim()).contains("%")) {
                throw new WrongUsageException("Invalid format. Use: 50%ninjutsu,30%taijutsu,20%medical", new Object[0]);
            }
            String[] splitPart = part.split("%");
            if (splitPart.length != 2) {
                throw new WrongUsageException("Invalid format. Use: 50%ninjutsu", new Object[0]);
            }
            try {
                percent = Integer.parseInt(splitPart[0]);
            }
            catch (NumberFormatException e) {
                throw new WrongUsageException("Percentage must be a number.", new Object[0]);
            }
            String stat = splitPart[1].toLowerCase();
            if (!Arrays.asList(STATS).contains(stat)) {
                throw new WrongUsageException("Unknown stat '" + stat + "'. Valid stats: " + String.join((CharSequence)", ", STATS), new Object[0]);
            }
            if (percent <= 0 || percent > 100) {
                throw new WrongUsageException("Percentages must be between 1 and 100.", new Object[0]);
            }
            percentages.put(stat, percent);
            totalPercentage += percent;
        }
        if (totalPercentage != 100) {
            throw new WrongUsageException("Percentages must add up to 100% (current: " + totalPercentage + "%)", new Object[0]);
        }
        int allocated = 0;
        Iterator it = percentages.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String stat = (String)entry.getKey();
            int percent = (Integer)entry.getValue();
            int amount = !it.hasNext() ? totalPoints - allocated : (int)Math.floor((double)(percent * totalPoints) / 100.0);
            if (amount <= 0) continue;
            this.applyStatIncrease(props, (EntityPlayerMP)player, stat, amount);
            allocated += amount;
        }
        props.setSkillPoints(props.getSkillPoints() - totalPoints);
        PacketDispatcher.sendTo(new SyncSkillPointsMessage(player), (EntityPlayerMP)player);
        String message = player == sender ? "Distributed " + totalPoints + " SP according to percentages." : "Distributed " + totalPoints + " SP for " + player.getDisplayName() + " according to percentages.";
        sender.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    private void handleSimpleInvest(ICommandSender sender, EntityPlayer player, ExtendedPlayer props, String[] args) {
        int amount;
        String stat = args[0].toLowerCase();
        String amountArg = args[1];
        if (!Arrays.asList(STATS).contains(stat)) {
            throw new WrongUsageException("Unknown stat '" + stat + "'. Valid stats: " + String.join((CharSequence)", ", STATS), new Object[0]);
        }
        int investablePoints = props.getSkillPoints();
        if (investablePoints <= 0) {
            String playerName = player == sender ? "You have" : player.getDisplayName() + " has";
            sender.func_145747_a((IChatComponent)new ChatComponentText(playerName + " no Skill Points to invest."));
            return;
        }
        if ("all".equalsIgnoreCase(amountArg)) {
            amount = investablePoints;
        } else {
            try {
                amount = Integer.parseInt(amountArg);
            }
            catch (NumberFormatException e) {
                throw new WrongUsageException("Amount must be a number or 'all'", new Object[0]);
            }
            if (amount > investablePoints) {
                String playerName = player == sender ? "You cannot" : player.getDisplayName() + " cannot";
                sender.func_145747_a((IChatComponent)new ChatComponentText(playerName + " invest more points than available. Available: " + investablePoints));
                return;
            }
        }
        if (amount <= 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Amount must be positive."));
            return;
        }
        this.applyStatIncrease(props, (EntityPlayerMP)player, stat, amount);
        props.setSkillPoints(investablePoints - amount);
        PacketDispatcher.sendTo(new SyncSkillPointsMessage(player), (EntityPlayerMP)player);
        String message = player == sender ? "Invested " + amount + " SP into " + stat : "Invested " + amount + " SP into " + stat + " for " + player.getDisplayName();
        sender.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    private void applyStatIncrease(ExtendedPlayer props, EntityPlayerMP player, String stat, int amount) {
        switch (stat) {
            case "ninjutsu": {
                props.setNinjutsu(props.getNinjutsu() + amount);
                PacketDispatcher.sendTo(new SyncNinjutsuMessage((EntityPlayer)player), player);
                props.setMaxChakra(props.getNinjutsu() * 5);
                props.setCurrentChakra(props.getCurrentChakra() + amount * 5);
                break;
            }
            case "taijutsu": {
                props.setTaijutsu(props.getTaijutsu() + amount);
                PacketDispatcher.sendTo(new SyncTaijutsuMessage((EntityPlayer)player), player);
                break;
            }
            case "medical": {
                props.setMedical(props.getMedical() + amount);
                int newHealth = Math.min(props.getHealthCap(), props.getHealth() + amount);
                props.setHealth(newHealth);
                PacketDispatcher.sendTo(new SyncHealthMessage((EntityPlayer)player), player);
                PacketDispatcher.sendTo(new SyncMedicalMessage((EntityPlayer)player), player);
                break;
            }
            case "kenjutsu": {
                props.setKenjutsu(props.getKenjutsu() + amount);
                PacketDispatcher.sendTo(new SyncKenjutsuMessage((EntityPlayer)player), player);
                break;
            }
            case "kinjutsu": {
                props.setKinjutsu(props.getKinjutsu() + amount);
                PacketDispatcher.sendTo(new SyncKinjutsuMessage((EntityPlayer)player), player);
                break;
            }
            case "genjutsu": {
                props.setGenjutsu(props.getGenjutsu() + amount);
                PacketDispatcher.sendTo(new SyncGenjutsuMessage((EntityPlayer)player), player);
                break;
            }
            case "senjutsu": {
                props.setSenjutsu(props.getSenjutsu() + amount);
                props.setMaxSenChakra(props.getSenjutsu() * 5);
                props.setCurrentSenChakra(props.getCurrentSenChakra() + amount * 5);
                PacketDispatcher.sendTo(new SyncSenjutsuMessage((EntityPlayer)player), player);
                break;
            }
            case "speed": {
                int currentSpeed = props.getSpeedPoints();
                int maxSpeed = 500;
                int actualAmount = Math.min(amount, maxSpeed - currentSpeed);
                if (actualAmount > 0) {
                    props.setSpeedPoints(currentSpeed + actualAmount);
                    PacketDispatcher.sendTo(new SyncSpeedMessage((EntityPlayer)player), player);
                    if (actualAmount >= amount) break;
                    player.func_145747_a((IChatComponent)new ChatComponentText("Speed capped at 500. Only invested " + actualAmount + " points."));
                    break;
                }
                player.func_145747_a((IChatComponent)new ChatComponentText("Speed is already at maximum (500)."));
                break;
            }
            case "shurikenjutsu": {
                props.setShurikenJutsu(props.getShurikenJutsu() + amount);
                PacketDispatcher.sendTo(new SyncShurikenjutsuMessage((EntityPlayer)player), player);
                break;
            }
            case "summoning": {
                props.setSummoning(props.getSummoning() + amount);
                PacketDispatcher.sendTo(new SyncSummoningMessage((EntityPlayer)player), player);
                break;
            }
            default: {
                throw new WrongUsageException("Unknown stat: " + stat, new Object[0]);
            }
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>(Arrays.asList(STATS));
            options.add("50%ninjutsu,50%taijutsu");
            options.add("33%ninjutsu,33%taijutsu,34%medical");
            return CommandInvestSP.func_71530_a((String[])args, (String[])options.toArray(new String[0]));
        }
        if (args.length == 2) {
            return CommandInvestSP.func_71530_a((String[])args, (String[])new String[]{"all", "10", "50", "100", "1000"});
        }
        if (args.length == 3) {
            return CommandInvestSP.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        return null;
    }

    private boolean canUseCommand(EntityPlayer player, int permLevel, String commandName) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(player.func_146103_bH());
    }
}

