/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Commands;

import java.util.List;
import java.util.function.IntConsumer;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncJutsuPointsMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncResetPointsMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncSkillPointsMessage;
import narutodestination.Mathioks.PacketDispatcher;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandPoints
extends CommandBase {
    public String func_71517_b() {
        return "points";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/points <skill/jutsu/reset> <give/set/take> <AMOUNT> [PLAYER]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        int amount;
        if (args.length < 3 || args.length > 4) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String type = args[0].toLowerCase();
        String action = args[1].toLowerCase();
        try {
            amount = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException(args[2] + " is not a number. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = args.length == 4 ? CommandPoints.func_82359_c((ICommandSender)sender, (String)args[3]) : CommandPoints.func_71521_c((ICommandSender)sender);
        ExtendedPlayer props = ExtendedPlayer.get((EntityPlayer)player);
        int oldValue = 0;
        int newValue = 0;
        String pointTypeName = "";
        switch (type) {
            case "skill": {
                oldValue = props.getSkillPoints();
                newValue = this.applyPoints(action, amount, oldValue, props::setSkillPoints);
                pointTypeName = "Skill Points";
                PacketDispatcher.sendTo(new SyncSkillPointsMessage((EntityPlayer)player), player);
                break;
            }
            case "jutsu": {
                oldValue = props.getJutsuPoints();
                newValue = this.applyPoints(action, amount, oldValue, props::setJutsuPoints);
                pointTypeName = "Jutsu Points";
                PacketDispatcher.sendTo(new SyncJutsuPointsMessage((EntityPlayer)player), player);
                break;
            }
            case "reset": {
                oldValue = props.getResetPoints();
                newValue = this.applyPoints(action, amount, oldValue, props::setResetPoints);
                pointTypeName = "Reset Points";
                PacketDispatcher.sendTo(new SyncResetPointsMessage((EntityPlayer)player), player);
                break;
            }
            default: {
                throw new WrongUsageException("Invalid type: use skill, jutsu, or reset.", new Object[0]);
            }
        }
        this.sendFeedbackMessages(sender, player, action, amount, oldValue, newValue, pointTypeName);
    }

    private int applyPoints(String action, int amount, int current, IntConsumer setter) {
        int newValue;
        switch (action) {
            case "give": {
                newValue = current + amount;
                setter.accept(newValue);
                break;
            }
            case "set": {
                newValue = amount;
                setter.accept(newValue);
                break;
            }
            case "take": {
                newValue = Math.max(0, current - amount);
                setter.accept(newValue);
                break;
            }
            default: {
                throw new WrongUsageException("Invalid action: use give, set, or take.", new Object[0]);
            }
        }
        return newValue;
    }

    private void sendFeedbackMessages(ICommandSender sender, EntityPlayerMP target, String action, int amount, int oldValue, int newValue, String pointType) {
        boolean isSelf = sender.equals(target);
        String targetMessage = "";
        EnumChatFormatting targetColor = EnumChatFormatting.GREEN;
        switch (action) {
            case "give": {
                targetMessage = String.format("You have received %s%+d %s%s (%d \u2192 %d)", EnumChatFormatting.GREEN, amount, pointType, EnumChatFormatting.GRAY, oldValue, newValue);
                targetColor = EnumChatFormatting.GREEN;
                break;
            }
            case "set": {
                targetMessage = String.format("Your %s have been set to %s%d%s (was %d)", pointType, EnumChatFormatting.AQUA, newValue, EnumChatFormatting.GRAY, oldValue);
                targetColor = EnumChatFormatting.AQUA;
                break;
            }
            case "take": {
                int actualTaken = oldValue - newValue;
                targetMessage = String.format("You have lost %s-%d %s%s (%d \u2192 %d)", EnumChatFormatting.RED, actualTaken, pointType, EnumChatFormatting.GRAY, oldValue, newValue);
                targetColor = EnumChatFormatting.RED;
            }
        }
        target.func_146105_b((IChatComponent)new ChatComponentText(targetMessage));
        if (!isSelf) {
            String senderMessage = "";
            switch (action) {
                case "give": {
                    senderMessage = String.format("%sGave %s%d %s %sto %s%s", EnumChatFormatting.GREEN, EnumChatFormatting.YELLOW, amount, pointType, EnumChatFormatting.GREEN, EnumChatFormatting.WHITE, target.getDisplayName());
                    break;
                }
                case "set": {
                    senderMessage = String.format("%sSet %s%s's %s %sto %s%d", EnumChatFormatting.AQUA, EnumChatFormatting.WHITE, target.getDisplayName(), pointType, EnumChatFormatting.AQUA, EnumChatFormatting.YELLOW, newValue);
                    break;
                }
                case "take": {
                    int actualTaken = oldValue - newValue;
                    senderMessage = String.format("%sTook %s%d %s %sfrom %s%s", EnumChatFormatting.RED, EnumChatFormatting.YELLOW, actualTaken, pointType, EnumChatFormatting.RED, EnumChatFormatting.WHITE, target.getDisplayName());
                }
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(senderMessage));
        }
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandPoints.func_71530_a((String[])args, (String[])new String[]{"skill", "jutsu", "reset"});
        }
        if (args.length == 2) {
            return CommandPoints.func_71530_a((String[])args, (String[])new String[]{"give", "set", "take"});
        }
        if (args.length == 4) {
            return CommandPoints.func_71530_a((String[])args, (String[])this.getPlayers());
        }
        return null;
    }

    public String[] getPlayers() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }
}

