/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class DNAConfig {
    public static Configuration configuration;
    public static int minimumIntelligenceToIdentify;
    public static int[] intelligenceThresholds;
    public static int[] identificationSuccessChances;
    public static int natureReleaseProbability;
    public static int kekkeiGenkaiProbability;
    public static int otsutsukiChanceWithinKekkeiGenkai;
    public static boolean enableFireRelease;
    public static boolean enableWaterRelease;
    public static boolean enableWindRelease;
    public static boolean enableLightningRelease;
    public static boolean enableEarthRelease;
    public static boolean enableYinRelease;
    public static boolean enableYangRelease;
    public static boolean enableWoodRelease;
    public static boolean enableIceRelease;
    public static boolean enableLavaRelease;
    public static boolean enableBoilRelease;
    public static boolean enableMagnetRelease;
    public static boolean enableStormRelease;
    public static boolean enableExplosionRelease;
    public static boolean enableScorchRelease;
    public static boolean enableDustRelease;
    public static boolean enableCrystalRelease;
    public static boolean enableSteelRelease;
    public static boolean enableKurama;
    public static boolean enableShikotsumyaku;
    public static boolean enableIburi;
    public static boolean enableSharingan;
    public static boolean enableByakugan;
    public static boolean enableKetsuryugan;
    public static boolean enableOtsutsukiDNA;
    public static int minimumMedicalForNatureImplant;
    public static int minimumMedicalForKKGImplant;
    public static int minimumMedicalForDojutsuImplant;
    public static int minimumMedicalForOtsutsuki;
    public static int[] medicalThresholds;
    public static int[] implantSuccessChances;
    public static int successEffectDuration;
    public static int failureEffectDuration;
    public static int successDigSlowLevel;
    public static int successConfusionLevel;
    public static int successMoveSlowLevel;
    public static int successWeaknessLevel;
    public static int failureDigSlowLevel;
    public static int failureConfusionLevel;
    public static int failureMoveSlowLevel;
    public static int failureWeaknessLevel;
    public static int failurePoisonLevel;
    private static Map<String, Boolean> dnaTypeRegistry;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        }
        try {
            configuration.load();
            DNAConfig.loadConfiguration();
        }
        catch (Exception e) {
            System.err.println("Error loading DNAConfig!");
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static void reload(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        } else {
            configuration.load();
        }
        DNAConfig.loadConfiguration();
    }

    private static void loadConfiguration() {
        minimumIntelligenceToIdentify = configuration.get("DNA Identification", "MinimumIntelligenceToIdentify", 20, "Minimum Intelligence stat required to identify DNA").getInt();
        int[] defaultIntelThresholds = new int[]{20, 40, 60, 80, 90, 100};
        intelligenceThresholds = configuration.get("DNA Identification", "IntelligenceThresholds", defaultIntelThresholds, "Intelligence thresholds for different identification success rates").getIntList();
        int[] defaultSuccessChances = new int[]{1, 5, 15, 25, 50, 70};
        identificationSuccessChances = configuration.get("DNA Identification", "IdentificationSuccessChances", defaultSuccessChances, "Success chances (%) for each intelligence threshold").getIntList();
        natureReleaseProbability = configuration.get("DNA Identification", "NatureReleaseProbability", 90, "Probability (%) of getting Nature Release DNA when identifying").getInt();
        otsutsukiChanceWithinKekkeiGenkai = configuration.get("DNA Identification", "OtsutsukiChanceWithinKekkeiGenkai", 5, "Chance (%) of getting Otsutsuki DNA within Kekkei Genkai results").getInt();
        enableFireRelease = configuration.get("DNA Type Toggles - Nature Releases", "EnableFireRelease", true, "Enable Fire Release DNA as a possible identification result").getBoolean();
        enableWaterRelease = configuration.get("DNA Type Toggles - Nature Releases", "EnableWaterRelease", true, "Enable Water Release DNA as a possible identification result").getBoolean();
        enableWindRelease = configuration.get("DNA Type Toggles - Nature Releases", "EnableWindRelease", true, "Enable Wind Release DNA as a possible identification result").getBoolean();
        enableLightningRelease = configuration.get("DNA Type Toggles - Nature Releases", "EnableLightningRelease", true, "Enable Lightning Release DNA as a possible identification result").getBoolean();
        enableEarthRelease = configuration.get("DNA Type Toggles - Nature Releases", "EnableEarthRelease", true, "Enable Earth Release DNA as a possible identification result").getBoolean();
        enableYinRelease = configuration.get("DNA Type Toggles - Nature Releases", "EnableYinRelease", true, "Enable Yin Release DNA as a possible identification result").getBoolean();
        enableYangRelease = configuration.get("DNA Type Toggles - Nature Releases", "EnableYangRelease", true, "Enable Yang Release DNA as a possible identification result").getBoolean();
        enableWoodRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableWoodRelease", true, "Enable Wood Release DNA as a possible identification result").getBoolean();
        enableIceRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableIceRelease", true, "Enable Ice Release DNA as a possible identification result").getBoolean();
        enableLavaRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableLavaRelease", true, "Enable Lava Release DNA as a possible identification result").getBoolean();
        enableBoilRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableBoilRelease", true, "Enable Boil Release DNA as a possible identification result").getBoolean();
        enableMagnetRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableMagnetRelease", true, "Enable Magnet Release DNA as a possible identification result").getBoolean();
        enableStormRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableStormRelease", true, "Enable Storm Release DNA as a possible identification result").getBoolean();
        enableExplosionRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableExplosionRelease", true, "Enable Explosion Release DNA as a possible identification result").getBoolean();
        enableScorchRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableScorchRelease", true, "Enable Scorch Release DNA as a possible identification result").getBoolean();
        enableDustRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableDustRelease", true, "Enable Dust Release DNA as a possible identification result").getBoolean();
        enableCrystalRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableCrystalRelease", true, "Enable Crystal Release DNA as a possible identification result").getBoolean();
        enableSteelRelease = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableSteelRelease", true, "Enable Steel Release DNA as a possible identification result").getBoolean();
        enableKurama = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableKurama", true, "Enable Kurama Clan DNA as a possible identification result").getBoolean();
        enableShikotsumyaku = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableShikotsumyaku", true, "Enable Shikotsumyaku DNA as a possible identification result").getBoolean();
        enableIburi = configuration.get("DNA Type Toggles - Kekkei Genkai", "EnableIburi", true, "Enable Iburi DNA as a possible identification result").getBoolean();
        enableSharingan = configuration.get("DNA Type Toggles - Dojutsu", "EnableSharingan", true, "Enable Sharingan DNA as a possible identification result").getBoolean();
        enableByakugan = configuration.get("DNA Type Toggles - Dojutsu", "EnableByakugan", true, "Enable Byakugan DNA as a possible identification result").getBoolean();
        enableKetsuryugan = configuration.get("DNA Type Toggles - Dojutsu", "EnableKetsuryugan", true, "Enable Ketsuryugan DNA as a possible identification result").getBoolean();
        enableOtsutsukiDNA = configuration.get("DNA Type Toggles - Otsutsuki", "EnableOtsutsukiDNA", true, "Enable Otsutsuki DNA as a possible identification result").getBoolean();
        minimumMedicalForNatureImplant = configuration.get("DNA Implantation", "MinimumMedicalForNatureImplant", 50, "Minimum Medical stat required to implant Nature DNA").getInt();
        minimumMedicalForKKGImplant = configuration.get("DNA Implantation", "MinimumMedicalForKekkeiGenkaiImplant", 300, "Minimum Medical stat required to implant Kekkei Genkai DNA").getInt();
        minimumMedicalForDojutsuImplant = configuration.get("DNA Implantation", "MinimumMedicalForDojutsuImplant", 500, "Minimum Medical stat required to implant Dojutsu DNA").getInt();
        minimumMedicalForOtsutsuki = configuration.get("DNA Implantation", "MinimumMedicalForOtsutsuki", 10000, "Minimum Medical stat required to implant Otsutsuki DNA").getInt();
        int[] defaultMedicalThresholds = new int[]{300, 400, 500};
        medicalThresholds = configuration.get("DNA Implantation", "MedicalThresholds", defaultMedicalThresholds, "Medical stat thresholds for different implant success rates").getIntList();
        int[] defaultImplantChances = new int[]{20, 40, 70};
        implantSuccessChances = configuration.get("DNA Implantation", "ImplantSuccessChances", defaultImplantChances, "Success chances (%) for each medical threshold").getIntList();
        successEffectDuration = configuration.get("Potion Effects", "SuccessEffectDuration", 200, "Duration (ticks) of potion effects on successful DNA implant").getInt();
        failureEffectDuration = configuration.get("Potion Effects", "FailureEffectDuration", 600, "Duration (ticks) of potion effects on failed DNA implant").getInt();
        successDigSlowLevel = configuration.get("Potion Effects", "SuccessDigSlowLevel", 5, "Mining Fatigue level for successful implant").getInt();
        successConfusionLevel = configuration.get("Potion Effects", "SuccessConfusionLevel", 50, "Nausea level for successful implant").getInt();
        successMoveSlowLevel = configuration.get("Potion Effects", "SuccessMoveSlowLevel", 5, "Slowness level for successful implant").getInt();
        successWeaknessLevel = configuration.get("Potion Effects", "SuccessWeaknessLevel", 50, "Weakness level for successful implant").getInt();
        failureDigSlowLevel = configuration.get("Potion Effects", "FailureDigSlowLevel", 5, "Mining Fatigue level for failed implant").getInt();
        failureConfusionLevel = configuration.get("Potion Effects", "FailureConfusionLevel", 50, "Nausea level for failed implant").getInt();
        failureMoveSlowLevel = configuration.get("Potion Effects", "FailureMoveSlowLevel", 5, "Slowness level for failed implant").getInt();
        failureWeaknessLevel = configuration.get("Potion Effects", "FailureWeaknessLevel", 50, "Weakness level for failed implant").getInt();
        failurePoisonLevel = configuration.get("Potion Effects", "FailurePoisonLevel", 1, "Poison level for failed implant").getInt();
        kekkeiGenkaiProbability = 100 - natureReleaseProbability;
        DNAConfig.buildDNARegistry();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private static void buildDNARegistry() {
        dnaTypeRegistry.clear();
        dnaTypeRegistry.put("fire", enableFireRelease);
        dnaTypeRegistry.put("water", enableWaterRelease);
        dnaTypeRegistry.put("wind", enableWindRelease);
        dnaTypeRegistry.put("lightning", enableLightningRelease);
        dnaTypeRegistry.put("earth", enableEarthRelease);
        dnaTypeRegistry.put("yin", enableYinRelease);
        dnaTypeRegistry.put("yang", enableYangRelease);
        dnaTypeRegistry.put("wood", enableWoodRelease);
        dnaTypeRegistry.put("ice", enableIceRelease);
        dnaTypeRegistry.put("lava", enableLavaRelease);
        dnaTypeRegistry.put("boil", enableBoilRelease);
        dnaTypeRegistry.put("magnet", enableMagnetRelease);
        dnaTypeRegistry.put("storm", enableStormRelease);
        dnaTypeRegistry.put("explosion", enableExplosionRelease);
        dnaTypeRegistry.put("scorch", enableScorchRelease);
        dnaTypeRegistry.put("dust", enableDustRelease);
        dnaTypeRegistry.put("crystal", enableCrystalRelease);
        dnaTypeRegistry.put("steel", enableSteelRelease);
        dnaTypeRegistry.put("shikotsumyaku", enableShikotsumyaku);
        dnaTypeRegistry.put("iburi", enableIburi);
        dnaTypeRegistry.put("kurama", enableKurama);
        dnaTypeRegistry.put("sharingan", enableSharingan);
        dnaTypeRegistry.put("byakugan", enableByakugan);
        dnaTypeRegistry.put("ketsuryugan", enableKetsuryugan);
        dnaTypeRegistry.put("otsutsuki", enableOtsutsukiDNA);
    }

    public static void reload() {
        if (configuration != null) {
            configuration.load();
            DNAConfig.loadConfiguration();
        }
    }

    public static boolean isDNATypeEnabled(String dnaType) {
        Boolean enabled = dnaTypeRegistry.get(dnaType.toLowerCase());
        return enabled != null && enabled != false;
    }

    public static int getEnabledNatureCount() {
        int count = 0;
        if (enableFireRelease) {
            ++count;
        }
        if (enableWaterRelease) {
            ++count;
        }
        if (enableWindRelease) {
            ++count;
        }
        if (enableLightningRelease) {
            ++count;
        }
        if (enableEarthRelease) {
            ++count;
        }
        if (enableYinRelease) {
            ++count;
        }
        if (enableYangRelease) {
            ++count;
        }
        return count;
    }

    public static int getEnabledKekkeiGenkaiCount() {
        int count = 0;
        if (enableWoodRelease) {
            ++count;
        }
        if (enableIceRelease) {
            ++count;
        }
        if (enableLavaRelease) {
            ++count;
        }
        if (enableBoilRelease) {
            ++count;
        }
        if (enableMagnetRelease) {
            ++count;
        }
        if (enableStormRelease) {
            ++count;
        }
        if (enableExplosionRelease) {
            ++count;
        }
        if (enableScorchRelease) {
            ++count;
        }
        if (enableDustRelease) {
            ++count;
        }
        if (enableCrystalRelease) {
            ++count;
        }
        if (enableSteelRelease) {
            ++count;
        }
        if (enableShikotsumyaku) {
            ++count;
        }
        if (enableIburi) {
            ++count;
        }
        if (enableKurama) {
            ++count;
        }
        return count;
    }

    public static int getEnabledDojutsuCount() {
        int count = 0;
        if (enableSharingan) {
            ++count;
        }
        if (enableByakugan) {
            ++count;
        }
        if (enableKetsuryugan) {
            ++count;
        }
        return count;
    }

    public static int getIdentificationChance(int intelligence) {
        for (int i = intelligenceThresholds.length - 1; i >= 0; --i) {
            if (intelligence < intelligenceThresholds[i]) continue;
            return identificationSuccessChances[i];
        }
        return 0;
    }

    public static int getImplantChance(int medical) {
        for (int i = medicalThresholds.length - 1; i >= 0; --i) {
            if (medical < medicalThresholds[i]) continue;
            return implantSuccessChances[i];
        }
        return 0;
    }

    static {
        minimumIntelligenceToIdentify = 20;
        intelligenceThresholds = new int[]{20, 40, 60, 80, 90, 100};
        identificationSuccessChances = new int[]{1, 5, 15, 25, 50, 70};
        natureReleaseProbability = 90;
        kekkeiGenkaiProbability = 10;
        otsutsukiChanceWithinKekkeiGenkai = 5;
        enableFireRelease = true;
        enableWaterRelease = true;
        enableWindRelease = true;
        enableLightningRelease = true;
        enableEarthRelease = true;
        enableYinRelease = true;
        enableYangRelease = true;
        enableWoodRelease = true;
        enableIceRelease = true;
        enableLavaRelease = true;
        enableBoilRelease = true;
        enableMagnetRelease = true;
        enableStormRelease = true;
        enableExplosionRelease = true;
        enableScorchRelease = true;
        enableDustRelease = true;
        enableCrystalRelease = true;
        enableSteelRelease = true;
        enableKurama = true;
        enableShikotsumyaku = true;
        enableIburi = true;
        enableSharingan = true;
        enableByakugan = true;
        enableKetsuryugan = true;
        enableOtsutsukiDNA = true;
        minimumMedicalForNatureImplant = 50;
        minimumMedicalForKKGImplant = 300;
        minimumMedicalForDojutsuImplant = 500;
        minimumMedicalForOtsutsuki = 10000;
        medicalThresholds = new int[]{300, 400, 500};
        implantSuccessChances = new int[]{20, 40, 70};
        successEffectDuration = 200;
        failureEffectDuration = 600;
        successDigSlowLevel = 5;
        successConfusionLevel = 50;
        successMoveSlowLevel = 5;
        successWeaknessLevel = 50;
        failureDigSlowLevel = 5;
        failureConfusionLevel = 50;
        failureMoveSlowLevel = 5;
        failureWeaknessLevel = 50;
        failurePoisonLevel = 1;
        dnaTypeRegistry = new HashMap<String, Boolean>();
    }
}

