/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Config;

import java.io.File;
import narutodestination.Mathioks.Config.FreebuildConfig;
import net.minecraftforge.common.config.Configuration;

public class EnemyConfig {
    public static Configuration configuration;
    private static boolean hasRunMigration;
    public static boolean geninSpawn;
    public static double geninHealth;
    public static double geninMeleeDamage;
    public static double geninMovementSpeed;
    public static double geninFollowRange;
    public static boolean chuninSpawn;
    public static double chuninHealth;
    public static double chuninMeleeDamage;
    public static double chuninMovementSpeed;
    public static double chuninFollowRange;
    public static boolean joninSpawn;
    public static double joninHealth;
    public static double joninMeleeDamage;
    public static double joninMovementSpeed;
    public static double joninFollowRange;
    public static boolean leeSpawn;
    public static double leeHealth;
    public static double leeMeleeDamage;
    public static double leeMovementSpeed;
    public static double leeFollowRange;
    public static boolean sakuraSpawn;
    public static double sakuraHealth;
    public static double sakuraMeleeDamage;
    public static double sakuraMovementSpeed;
    public static double sakuraFollowRange;
    public static boolean zabuzaSpawn;
    public static double zabuzaHealth;
    public static double zabuzaMeleeDamage;
    public static double zabuzaMovementSpeed;
    public static double zabuzaFollowRange;
    public static boolean masterSpawnToggle;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        }
        try {
            configuration.load();
            if (!hasRunMigration) {
                EnemyConfig.migrateFromFreebuildConfig();
                hasRunMigration = true;
            }
            EnemyConfig.loadConfiguration();
        }
        catch (Exception e) {
            System.err.println("Error loading EnemyConfig!");
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static void reload(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
        } else {
            configuration.load();
        }
        EnemyConfig.loadConfiguration();
    }

    private static void loadConfiguration() {
        masterSpawnToggle = configuration.get("A General", "MasterSpawnToggle", true, "Master switch for all enemy spawning. If false, no enemies will spawn.").getBoolean();
        geninSpawn = configuration.get("Genin", "Spawn", true, "Set to false to prevent Genin enemies from spawning").getBoolean();
        geninHealth = configuration.get("Genin", "Health", 30.0, "Maximum health for Genin enemies (default: 30.0)").getDouble();
        geninMeleeDamage = configuration.get("Genin", "MeleeDamage", 2.0, "Melee attack damage for Genin enemies (default: 2.0)").getDouble();
        geninMovementSpeed = configuration.get("Genin", "MovementSpeed", 0.4, "Movement speed for Genin enemies (default: 0.4)").getDouble();
        geninFollowRange = configuration.get("Genin", "AggroRange", 20.0, "Aggro/follow range for Genin enemies (default: 20.0)").getDouble();
        chuninSpawn = configuration.get("Chunin", "Spawn", true, "Set to false to prevent Chunin enemies from spawning").getBoolean();
        chuninHealth = configuration.get("Chunin", "Health", 80.0, "Maximum health for Chunin enemies (default: 80.0)").getDouble();
        chuninMeleeDamage = configuration.get("Chunin", "MeleeDamage", 10.0, "Melee attack damage for Chunin enemies (default: 10.0)").getDouble();
        chuninMovementSpeed = configuration.get("Chunin", "MovementSpeed", 0.45, "Movement speed for Chunin enemies (default: 0.45)").getDouble();
        chuninFollowRange = configuration.get("Chunin", "AggroRange", 30.0, "Aggro/follow range for Chunin enemies (default: 30.0)").getDouble();
        joninSpawn = configuration.get("Jonin", "Spawn", true, "Set to false to prevent Jonin enemies from spawning").getBoolean();
        joninHealth = configuration.get("Jonin", "Health", 200.0, "Maximum health for Jonin enemies (default: 200.0)").getDouble();
        joninMeleeDamage = configuration.get("Jonin", "MeleeDamage", 20.0, "Melee attack damage for Jonin enemies (default: 20.0)").getDouble();
        joninMovementSpeed = configuration.get("Jonin", "MovementSpeed", 0.5, "Movement speed for Jonin enemies (default: 0.5)").getDouble();
        joninFollowRange = configuration.get("Jonin", "AggroRange", 40.0, "Aggro/follow range for Jonin enemies (default: 40.0)").getDouble();
        leeSpawn = configuration.get("RockLee", "Spawn", true, "Set to false to prevent Rock Lee from spawning").getBoolean();
        leeHealth = configuration.get("RockLee", "Health", 500.0, "Maximum health for Rock Lee (default: 500.0)").getDouble();
        leeMeleeDamage = configuration.get("RockLee", "MeleeDamage", 50.0, "Melee attack damage for Rock Lee (default: 50.0)").getDouble();
        leeMovementSpeed = configuration.get("RockLee", "MovementSpeed", 0.7, "Movement speed for Rock Lee (default: 0.7)").getDouble();
        leeFollowRange = configuration.get("RockLee", "AggroRange", 40.0, "Aggro/follow range for Rock Lee (default: 40.0)").getDouble();
        sakuraSpawn = configuration.get("SakuraHaruno", "Spawn", true, "Set to false to prevent Sakura Haruno from spawning").getBoolean();
        sakuraHealth = configuration.get("SakuraHaruno", "Health", 400.0, "Maximum health for Sakura Haruno (default: 400.0)").getDouble();
        sakuraMeleeDamage = configuration.get("SakuraHaruno", "MeleeDamage", 30.0, "Melee attack damage for Sakura Haruno (default: 30.0)").getDouble();
        sakuraMovementSpeed = configuration.get("SakuraHaruno", "MovementSpeed", 0.5, "Movement speed for Sakura Haruno (default: 0.5)").getDouble();
        sakuraFollowRange = configuration.get("SakuraHaruno", "AggroRange", 40.0, "Aggro/follow range for Sakura Haruno (default: 40.0)").getDouble();
        zabuzaSpawn = configuration.get("ZabuzaMomochi", "Spawn", true, "Set to false to prevent Zabuza Momochi from spawning").getBoolean();
        zabuzaHealth = configuration.get("ZabuzaMomochi", "Health", 600.0, "Maximum health for Zabuza Momochi (default: 600.0)").getDouble();
        zabuzaMeleeDamage = configuration.get("ZabuzaMomochi", "MeleeDamage", 60.0, "Melee attack damage for Zabuza Momochi (default: 60.0)").getDouble();
        zabuzaMovementSpeed = configuration.get("ZabuzaMomochi", "MovementSpeed", 0.6, "Movement speed for Zabuza Momochi (default: 0.6)").getDouble();
        zabuzaFollowRange = configuration.get("ZabuzaMomochi", "AggroRange", 50.0, "Aggro/follow range for Zabuza Momochi (default: 50.0)").getDouble();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private static void migrateFromFreebuildConfig() {
        if (FreebuildConfig.configuration == null) {
            return;
        }
        boolean needsSave = false;
        Configuration fbConfig = FreebuildConfig.configuration;
        System.out.println("[EnemyConfig] Checking for migration from FreebuildConfig...");
        if (fbConfig.hasKey("enemyspawns", "A: DoEnemiesSpawn")) {
            masterSpawnToggle = fbConfig.get("enemyspawns", "A: DoEnemiesSpawn", true).getBoolean();
            fbConfig.getCategory("enemyspawns").remove((Object)"A: DoEnemiesSpawn");
            needsSave = true;
            System.out.println("[EnemyConfig] Migrated DoEnemiesSpawn to EnemyConfig (value: " + masterSpawnToggle + ")");
        }
        if (fbConfig.hasKey("enemyspawns", "B: DoGeninSpawn")) {
            geninSpawn = fbConfig.get("enemyspawns", "B: DoGeninSpawn", true).getBoolean();
            fbConfig.getCategory("enemyspawns").remove((Object)"B: DoGeninSpawn");
            needsSave = true;
            System.out.println("[EnemyConfig] Migrated DoGeninSpawn to EnemyConfig (value: " + geninSpawn + ")");
        }
        if (fbConfig.hasKey("enemyspawns", "C: DoChuninSpawn")) {
            chuninSpawn = fbConfig.get("enemyspawns", "C: DoChuninSpawn", true).getBoolean();
            fbConfig.getCategory("enemyspawns").remove((Object)"C: DoChuninSpawn");
            needsSave = true;
            System.out.println("[EnemyConfig] Migrated DoChuninSpawn to EnemyConfig (value: " + chuninSpawn + ")");
        }
        if (fbConfig.hasKey("enemyspawns", "D: DoJoninSpawn")) {
            joninSpawn = fbConfig.get("enemyspawns", "D: DoJoninSpawn", true).getBoolean();
            fbConfig.getCategory("enemyspawns").remove((Object)"D: DoJoninSpawn");
            needsSave = true;
            System.out.println("[EnemyConfig] Migrated DoJoninSpawn to EnemyConfig (value: " + joninSpawn + ")");
        }
        if (fbConfig.hasCategory("enemyspawns")) {
            if (fbConfig.getCategory("enemyspawns").isEmpty()) {
                fbConfig.removeCategory(fbConfig.getCategory("enemyspawns"));
                System.out.println("[EnemyConfig] Removed empty EnemySpawns category from FreebuildConfig");
                needsSave = true;
            } else {
                System.out.println("[EnemyConfig] Warning: EnemySpawns category still has entries: " + fbConfig.getCategory("enemyspawns").keySet());
            }
        }
        if (needsSave) {
            fbConfig.save();
            System.out.println("[EnemyConfig] Migration complete. FreebuildConfig.cfg updated and saved.");
        } else {
            System.out.println("[EnemyConfig] No migration needed - entries already removed or don't exist.");
        }
    }

    public static void reload() {
        if (configuration != null) {
            configuration.load();
            EnemyConfig.loadConfiguration();
        }
    }

    public static boolean shouldEnemySpawn(String enemyType) {
        if (!masterSpawnToggle) {
            return false;
        }
        if (enemyType == null) {
            return true;
        }
        switch (enemyType.toLowerCase()) {
            case "genin": {
                return geninSpawn;
            }
            case "chunin": {
                return chuninSpawn;
            }
            case "jonin": {
                return joninSpawn;
            }
            case "rocklee": 
            case "lee": {
                return leeSpawn;
            }
            case "sakura": 
            case "sakuraharuno": {
                return sakuraSpawn;
            }
            case "zabuza": 
            case "zabuzamomochi": {
                return zabuzaSpawn;
            }
        }
        return true;
    }

    static {
        hasRunMigration = false;
        geninSpawn = true;
        geninHealth = 30.0;
        geninMeleeDamage = 2.0;
        geninMovementSpeed = 0.4;
        geninFollowRange = 20.0;
        chuninSpawn = true;
        chuninHealth = 80.0;
        chuninMeleeDamage = 10.0;
        chuninMovementSpeed = 0.45;
        chuninFollowRange = 30.0;
        joninSpawn = true;
        joninHealth = 200.0;
        joninMeleeDamage = 20.0;
        joninMovementSpeed = 0.5;
        joninFollowRange = 40.0;
        leeSpawn = true;
        leeHealth = 500.0;
        leeMeleeDamage = 50.0;
        leeMovementSpeed = 0.7;
        leeFollowRange = 40.0;
        sakuraSpawn = true;
        sakuraHealth = 400.0;
        sakuraMeleeDamage = 30.0;
        sakuraMovementSpeed = 0.5;
        sakuraFollowRange = 40.0;
        zabuzaSpawn = true;
        zabuzaHealth = 600.0;
        zabuzaMeleeDamage = 60.0;
        zabuzaMovementSpeed = 0.6;
        zabuzaFollowRange = 50.0;
        masterSpawnToggle = true;
    }
}

