/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.ExtraFunctions;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import narutodestination.Mathioks.AbstractMessage;
import narutodestination.Mathioks.AddedItems;
import narutodestination.Mathioks.Config.GeneralConfig;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncKenjutsuMessage;
import narutodestination.Mathioks.PacketDispatcher;
import narutodestination.Mathioks.TransformationsRealPackage.Helper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class IncreaseKenjutsuMessage
extends AbstractMessage<IncreaseKenjutsuMessage> {
    private int increaseValue;

    public IncreaseKenjutsuMessage() {
    }

    public IncreaseKenjutsuMessage(int increaseValue) {
        this.increaseValue = increaseValue;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.increaseValue = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.increaseValue);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            return;
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.get(player);
        int skillPoints = extendedPlayer.getSkillPoints();
        if (skillPoints < this.increaseValue) {
            PacketDispatcher.sendTo(new SyncKenjutsuMessage(player), (EntityPlayerMP)player);
            System.out.println("Player " + player.getDisplayName() + " tried to increase kenjutsu by " + this.increaseValue + " but only has " + skillPoints + " skillpoints");
            return;
        }
        int oldKenjutsu = extendedPlayer.getKenjutsu();
        extendedPlayer.setKenjutsu(oldKenjutsu + this.increaseValue);
        extendedPlayer.setSkillPoints(extendedPlayer.getSkillPoints() - this.increaseValue);
        if (GeneralConfig.kenjutsuSkillLearnerThreshold != -1) {
            int newKenjutsu = extendedPlayer.getKenjutsu();
            if (!extendedPlayer.getSkillLearnerKenjutsu() && oldKenjutsu < GeneralConfig.kenjutsuSkillLearnerThreshold && newKenjutsu >= GeneralConfig.kenjutsuSkillLearnerThreshold) {
                ItemStack skillLearner = new ItemStack(AddedItems.SkillLearnerKenjutsu, 1);
                Helper.giveOrDropItem(player, skillLearner);
                extendedPlayer.setSkillLearnerKenjutsu(true, Side.SERVER);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Achievement Unlocked: " + EnumChatFormatting.YELLOW + "Skill Learner: Kenjutsu!"));
                System.out.println("Player " + player.getDisplayName() + " unlocked Skill Learner: Kenjutsu!");
            }
        }
    }
}

