/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.ExtraFunctions;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import narutodestination.Mathioks.AbstractMessage;
import narutodestination.Mathioks.AddedItems;
import narutodestination.Mathioks.Config.GeneralConfig;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncTaijutsuMessage;
import narutodestination.Mathioks.PacketDispatcher;
import narutodestination.Mathioks.TransformationsRealPackage.Helper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class IncreaseTaijutsuMessage
extends AbstractMessage<IncreaseTaijutsuMessage> {
    private int increaseValue;

    public IncreaseTaijutsuMessage() {
    }

    public IncreaseTaijutsuMessage(int increaseValue) {
        this.increaseValue = increaseValue;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.increaseValue = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.increaseValue);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            return;
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.get(player);
        int skillPoints = extendedPlayer.getSkillPoints();
        if (skillPoints < this.increaseValue) {
            PacketDispatcher.sendTo(new SyncTaijutsuMessage(player), (EntityPlayerMP)player);
            System.out.println("Player " + player.getDisplayName() + " tried to increase taijutsu by " + this.increaseValue + " but only has " + skillPoints + " skillpoints");
            return;
        }
        int oldTaijutsu = extendedPlayer.getTaijutsu();
        extendedPlayer.setTaijutsu(oldTaijutsu + this.increaseValue);
        extendedPlayer.setSkillPoints(extendedPlayer.getSkillPoints() - this.increaseValue);
        if (GeneralConfig.taijutsuSkillLearnerThreshold != -1) {
            int newTaijutsu = extendedPlayer.getTaijutsu();
            if (!extendedPlayer.getSkillLearnerTaijutsu() && oldTaijutsu < GeneralConfig.taijutsuSkillLearnerThreshold && newTaijutsu >= GeneralConfig.taijutsuSkillLearnerThreshold) {
                ItemStack skillLearner = new ItemStack(AddedItems.SkillLearnerTaijutsu, 1);
                Helper.giveOrDropItem(player, skillLearner);
                extendedPlayer.setSkillLearnerTaijutsu(true, Side.SERVER);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Achievement Unlocked: " + EnumChatFormatting.YELLOW + "Skill Learner: Taijutsu!"));
                System.out.println("Player " + player.getDisplayName() + " unlocked Skill Learner: Taijutsu!");
            }
        }
    }
}

