/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Final.CT.Menma;

import java.util.ArrayList;
import java.util.List;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.Final.CT.Menma.RasenShurikenEntity;
import narutodestination.Mathioks.Final.JutsuItem;
import narutodestination.Mathioks.Jutsu.NewJutsu.TailedBeast.TBRasenShurikenEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class RasenShurikenItem
extends JutsuItem {
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        ExtendedPlayer props = ExtendedPlayer.get(player);
        if (player.func_70093_af()) {
            this.switchRasenShurikenType(stack, props, player);
            return stack;
        }
        if (this.handleClick(stack, player, world)) {
            Vec3 look = player.func_70040_Z();
            int selectedType = this.getSelectedType(stack);
            double damage = this.getDamage(props, stack);
            if (selectedType == 0) {
                RasenShurikenEntity entity = new RasenShurikenEntity(world, (EntityLivingBase)player, (float)damage);
                entity.func_70107_b(player.field_70165_t + look.field_72450_a * 5.0, player.field_70163_u + 2.0 + look.field_72448_b * 6.0, player.field_70161_v + look.field_72449_c * 5.0);
                entity.field_70142_S = look.field_72450_a * 0.2;
                entity.field_70137_T = look.field_72448_b * 0.2;
                entity.field_70136_U = look.field_72449_c * 0.2;
                world.func_72838_d((Entity)entity);
            } else {
                TBRasenShurikenEntity entity = new TBRasenShurikenEntity(world, (EntityLivingBase)player, damage, selectedType);
                entity.func_70107_b(player.field_70165_t + look.field_72450_a * 5.0, player.field_70163_u + 2.0 + look.field_72448_b * 6.0, player.field_70161_v + look.field_72449_c * 5.0);
                entity.field_70142_S = look.field_72450_a * 0.2;
                entity.field_70137_T = look.field_72448_b * 0.2;
                entity.field_70136_U = look.field_72449_c * 0.2;
                world.func_72838_d((Entity)entity);
            }
        }
        return stack;
    }

    private int getSelectedType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74762_e("SelectedRasenShurikenType");
    }

    private void setSelectedType(ItemStack stack, int type) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("SelectedRasenShurikenType", type);
    }

    private void switchRasenShurikenType(ItemStack stack, ExtendedPlayer props, EntityPlayer player) {
        List<Integer> availableTypes = this.getAvailableTypes(props);
        if (availableTypes.isEmpty()) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "No Rasen Shuriken types available!"));
            return;
        }
        int currentType = this.getSelectedType(stack);
        int currentIndex = availableTypes.indexOf(currentType);
        if (currentIndex == -1) {
            currentIndex = -1;
        }
        int nextIndex = (currentIndex + 1) % availableTypes.size();
        int nextType = availableTypes.get(nextIndex);
        this.setSelectedType(stack, nextType);
        String typeName = this.getRasenShurikenTypeName(nextType);
        EnumChatFormatting color = this.getRasenShurikenTypeColor(nextType);
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + "Rasen Shuriken Type: " + color + typeName));
    }

    private List<Integer> getAvailableTypes(ExtendedPlayer props) {
        ArrayList<Integer> available = new ArrayList<Integer>();
        available.add(0);
        if (props.getTenTails() > 0) {
            for (int i = 1; i <= 9; ++i) {
                available.add(i);
            }
            return available;
        }
        if (props.getOneTail() > 0) {
            available.add(1);
        }
        if (props.getTwoTails() > 0) {
            available.add(2);
        }
        if (props.getThreeTails() > 0) {
            available.add(3);
        }
        if (props.getFourTails() > 0) {
            available.add(4);
        }
        if (props.getFiveTails() > 0) {
            available.add(5);
        }
        if (props.getSixTails() > 0) {
            available.add(6);
        }
        if (props.getSevenTails() > 0) {
            available.add(7);
        }
        if (props.getEightTails() > 0) {
            available.add(8);
        }
        if (props.getNineTails() > 0) {
            available.add(9);
        }
        return available;
    }

    private String getRasenShurikenTypeName(int type) {
        switch (type) {
            case 0: {
                return "Wind Style: Rasen Shuriken";
            }
            case 1: {
                return "One-Tail Rasen Shuriken (Shukaku)";
            }
            case 2: {
                return "Two-Tails Rasen Shuriken (Matatabi)";
            }
            case 3: {
                return "Three-Tails Rasen Shuriken (Isobu)";
            }
            case 4: {
                return "Four-Tails Rasen Shuriken (Son Goku)";
            }
            case 5: {
                return "Five-Tails Rasen Shuriken (Kokuo)";
            }
            case 6: {
                return "Six-Tails Rasen Shuriken (Saiken)";
            }
            case 7: {
                return "Seven-Tails Rasen Shuriken (Chomei)";
            }
            case 8: {
                return "Eight-Tails Rasen Shuriken (Gyuki)";
            }
            case 9: {
                return "Nine-Tails Rasen Shuriken (Kurama)";
            }
        }
        return "Unknown Rasen Shuriken";
    }

    private EnumChatFormatting getRasenShurikenTypeColor(int type) {
        switch (type) {
            case 0: {
                return EnumChatFormatting.WHITE;
            }
            case 1: {
                return EnumChatFormatting.GOLD;
            }
            case 2: {
                return EnumChatFormatting.BLUE;
            }
            case 3: {
                return EnumChatFormatting.DARK_AQUA;
            }
            case 4: {
                return EnumChatFormatting.RED;
            }
            case 5: {
                return EnumChatFormatting.YELLOW;
            }
            case 6: {
                return EnumChatFormatting.AQUA;
            }
            case 7: {
                return EnumChatFormatting.GREEN;
            }
            case 8: {
                return EnumChatFormatting.LIGHT_PURPLE;
            }
            case 9: {
                return EnumChatFormatting.GOLD;
            }
        }
        return EnumChatFormatting.GRAY;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        ExtendedPlayer props = ExtendedPlayer.get(player);
        int selectedType = this.getSelectedType(stack);
        String typeName = this.getRasenShurikenTypeName(selectedType);
        EnumChatFormatting color = this.getRasenShurikenTypeColor(selectedType);
        list.add(EnumChatFormatting.GOLD + "Current: " + color + typeName);
        List<Integer> availableTypes = this.getAvailableTypes(props);
        if (availableTypes.size() > 1) {
            list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "Sneak + Right-Click to switch");
            list.add(EnumChatFormatting.GRAY + "Available Types: " + EnumChatFormatting.YELLOW + availableTypes.size());
        }
        if (props.getTenTails() == 0 && availableTypes.size() < 10) {
            list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + "Unlock more by obtaining Tailed Beasts!");
        }
        if (props.getTenTails() > 0) {
            list.add(EnumChatFormatting.DARK_RED + "" + EnumChatFormatting.ITALIC + "Ten-Tails: All types unlocked!");
        }
    }
}

