/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Final;

import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.Final.JutsuItem;
import narutodestination.Mathioks.Jutsu.JutsuLogic;
import narutodestination.Mathioks.block.ModBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class WoodReleaseNativity
extends JutsuItem {
    private static final int SPAWN_RADIUS = 10;
    private static final int NUM_TREES = 15;
    private static final int MAX_NINJUTSU = 50000;
    private static final int MIN_HEIGHT = 4;
    private static final int MAX_HEIGHT = 10;

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(stack, world, par3Entity, par4, par5);
        if (par3Entity instanceof EntityPlayer && stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.handleClick(stack, player, world)) {
            this.spawnTreesAroundPlayer(world, player);
        }
        return stack;
    }

    private void spawnTreesAroundPlayer(World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)player.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
        for (int i = 0; i < 15; ++i) {
            int groundY;
            int offsetX = world.field_73012_v.nextInt(21) - 10;
            int offsetZ = world.field_73012_v.nextInt(21) - 10;
            int treeX = playerX + offsetX;
            int treeZ = playerZ + offsetZ;
            for (groundY = playerY; groundY > 0 && world.func_147437_c(treeX, groundY, treeZ); --groundY) {
            }
            this.spawnTree(world, treeX, ++groundY, treeZ, player);
        }
    }

    private void spawnTree(World world, int x, int y, int z, EntityPlayer player) {
        int centerZ;
        ExtendedPlayer props = ExtendedPlayer.get(player);
        int ninjutsu = props.getNinjutsu();
        int treeHeight = 4 + (int)(6.0 * (double)Math.min(ninjutsu, 50000) / 50000.0);
        boolean thickTrunk = treeHeight >= 9;
        for (int h = 0; h < treeHeight; ++h) {
            if (thickTrunk) {
                JutsuLogic.setBlockWithoutReplacing(world, x, y + h, z, ModBlocks.jutsuWood, 0, 2);
                JutsuLogic.setBlockWithoutReplacing(world, x + 1, y + h, z, ModBlocks.jutsuWood, 0, 2);
                JutsuLogic.setBlockWithoutReplacing(world, x, y + h, z + 1, ModBlocks.jutsuWood, 0, 2);
                JutsuLogic.setBlockWithoutReplacing(world, x + 1, y + h, z + 1, ModBlocks.jutsuWood, 0, 2);
                continue;
            }
            JutsuLogic.setBlockWithoutReplacing(world, x, y + h, z, ModBlocks.jutsuWood, 0, 2);
        }
        int topY = y + treeHeight - 1;
        int centerX = thickTrunk ? x : x;
        int n = centerZ = thickTrunk ? z : z;
        if (treeHeight <= 5) {
            this.buildSmallCanopy(world, centerX, topY, centerZ, thickTrunk);
        } else if (treeHeight <= 8) {
            this.buildMediumCanopy(world, centerX, topY, centerZ, thickTrunk);
        } else {
            this.buildLargeCanopy(world, centerX, topY, centerZ, thickTrunk);
        }
    }

    private void buildSmallCanopy(World world, int x, int y, int z, boolean thickTrunk) {
        int dz;
        int dx;
        for (dx = 0; dx <= 1; ++dx) {
            for (dz = 0; dz <= 1; ++dz) {
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y + 1, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
        for (dx = -1; dx <= 2; ++dx) {
            for (dz = -1; dz <= 2; ++dz) {
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
        for (dx = -1; dx <= 2; ++dx) {
            for (dz = -1; dz <= 2; ++dz) {
                if (thickTrunk && dx >= 0 && dx <= 1 && dz >= 0 && dz <= 1 || !thickTrunk && dx == 0 && dz == 0) continue;
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y - 1, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
    }

    private void buildMediumCanopy(World world, int x, int y, int z, boolean thickTrunk) {
        int dz;
        int dx;
        for (dx = -1; dx <= 2; ++dx) {
            for (dz = -1; dz <= 2; ++dz) {
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y + 1, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
        for (dx = -2; dx <= 3; ++dx) {
            for (dz = -2; dz <= 3; ++dz) {
                if (Math.abs((double)dx - 0.5) > 2.0 && Math.abs((double)dz - 0.5) > 2.0) continue;
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
        for (dx = -2; dx <= 3; ++dx) {
            for (dz = -2; dz <= 3; ++dz) {
                if (Math.abs((double)dx - 0.5) > 2.0 && Math.abs((double)dz - 0.5) > 2.0) continue;
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y - 1, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
        for (dx = -1; dx <= 2; ++dx) {
            for (dz = -1; dz <= 2; ++dz) {
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y - 2, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
    }

    private void buildLargeCanopy(World world, int x, int y, int z, boolean thickTrunk) {
        int dz;
        int dx;
        for (dx = -1; dx <= 2; ++dx) {
            for (dz = -1; dz <= 2; ++dz) {
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y + 2, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
        for (dx = -2; dx <= 3; ++dx) {
            for (dz = -2; dz <= 3; ++dz) {
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y + 1, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
        for (dx = -3; dx <= 4; ++dx) {
            for (dz = -3; dz <= 4; ++dz) {
                if (Math.abs((double)dx - 0.5) > 3.0 && Math.abs((double)dz - 0.5) > 3.0) continue;
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
        for (dx = -3; dx <= 4; ++dx) {
            for (dz = -3; dz <= 4; ++dz) {
                if (Math.abs((double)dx - 0.5) > 3.0 && Math.abs((double)dz - 0.5) > 3.0) continue;
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y - 1, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
        for (dx = -2; dx <= 3; ++dx) {
            for (dz = -2; dz <= 3; ++dz) {
                JutsuLogic.setBlockWithoutReplacing(world, x + dx, y - 2, z + dz, ModBlocks.jutsuLeaves, 0, 2);
            }
        }
    }
}

