/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.SkillLearners;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import narutodestination.Mathioks.AddedItems;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ExtraFunctions.SyncSharinganActiveMessage;
import narutodestination.Mathioks.ExtraFunctions.SyncSharinganSizeMessage;
import narutodestination.Mathioks.PacketDispatcher;
import narutodestination.Mathioks.TransformationsRealPackage.Helper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class RinneganUnlocker
extends Item {
    private static final int MAX_REQUIREMENTS = 10;

    public RinneganUnlocker() {
        this.field_77777_bU = 1;
        this.func_77656_e(10);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ExtendedPlayer props = ExtendedPlayer.get(player);
            int currentStep = this.getCurrentStep(stack);
            switch (currentStep) {
                case 0: {
                    this.checkSharinganSize(player, props, stack);
                    break;
                }
                case 1: {
                    this.checkMangekyouSharingan(player, props, stack);
                    break;
                }
                case 2: {
                    this.checkYinYangRelease(player, props, stack);
                    break;
                }
                case 3: {
                    this.checkFireRelease(player, props, stack);
                    break;
                }
                case 4: {
                    this.checkWindRelease(player, props, stack);
                    break;
                }
                case 5: {
                    this.checkLightningRelease(player, props, stack);
                    break;
                }
                case 6: {
                    this.checkWaterRelease(player, props, stack);
                    break;
                }
                case 7: {
                    this.checkEarthRelease(player, props, stack);
                    break;
                }
                case 8: {
                    this.checkWoodRelease(player, props, stack);
                    break;
                }
                case 9: {
                    this.checkLevelAndUnlockRinnegan(player, props, stack);
                    break;
                }
                default: {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "All requirements for the " + EnumChatFormatting.BOLD + "Rinnegan" + EnumChatFormatting.RESET + EnumChatFormatting.DARK_PURPLE + " have been met!"));
                }
            }
        }
        return stack;
    }

    private int getCurrentStep(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("CurrentStep", 0);
        }
        return stack.field_77990_d.func_74762_e("CurrentStep");
    }

    private void advanceStep(ItemStack stack) {
        int nextStep = this.getCurrentStep(stack) + 1;
        stack.field_77990_d.func_74768_a("CurrentStep", nextStep);
        stack.func_77964_b(nextStep);
        stack.func_77973_b().func_77656_e(10);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74778_a("OwnerUUID", "");
        }
        int currentStep = this.getCurrentStep(stack);
        list.add(EnumChatFormatting.DARK_AQUA + "Remaining Requirements for Rinnegan:");
        for (int i = currentStep; i < 10; ++i) {
            list.add(EnumChatFormatting.GRAY + "- " + EnumChatFormatting.GOLD + this.getRequirementName(i) + EnumChatFormatting.GRAY + " (" + EnumChatFormatting.LIGHT_PURPLE + this.getJPCost(i) + " JP" + EnumChatFormatting.GRAY + ")");
        }
        list.add(EnumChatFormatting.YELLOW + "Progress: " + EnumChatFormatting.GREEN + currentStep * 10 + "%");
        if (stack.field_77990_d.func_74764_b("OwnerUUID")) {
            String ownerUUID = stack.field_77990_d.func_74779_i("OwnerUUID");
            try {
                EntityPlayer owner = player.field_70170_p.func_152378_a(UUID.fromString(ownerUUID));
                if (owner != null) {
                    list.add(EnumChatFormatting.GRAY + "Owner: " + owner.getDisplayName());
                } else {
                    list.add(EnumChatFormatting.GRAY + "Owner: Unknown");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private String getRequirementName(int step) {
        switch (step) {
            case 0: {
                return "3-Tomoe Sharingan";
            }
            case 1: {
                return "Mangekyou Sharingan";
            }
            case 2: {
                return "Yin-Yang Release";
            }
            case 3: {
                return "Fire Release";
            }
            case 4: {
                return "Wind Release";
            }
            case 5: {
                return "Lightning Release";
            }
            case 6: {
                return "Water Release";
            }
            case 7: {
                return "Earth Release";
            }
            case 8: {
                return "Wood Release";
            }
            case 9: {
                return "Level 1000";
            }
        }
        return "Unknown Requirement";
    }

    private int getJPCost(int step) {
        return 5 + step * 5;
    }

    private String getNextRequirementMessage(int step) {
        String requirement;
        int jpCost = 5 + step * 5;
        switch (step) {
            case 0: {
                requirement = "3-Tomoe Sharingan";
                break;
            }
            case 1: {
                requirement = "Mangekyou Sharingan";
                break;
            }
            case 2: {
                requirement = "Yin-Yang Release";
                break;
            }
            case 3: {
                requirement = "Fire Release";
                break;
            }
            case 4: {
                requirement = "Wind Release";
                break;
            }
            case 5: {
                requirement = "Lightning Release";
                break;
            }
            case 6: {
                requirement = "Water Release";
                break;
            }
            case 7: {
                requirement = "Earth Release";
                break;
            }
            case 8: {
                requirement = "Wood Release";
                break;
            }
            case 9: {
                requirement = "Level 1000";
                break;
            }
            default: {
                return EnumChatFormatting.GREEN + "All requirements met!";
            }
        }
        return EnumChatFormatting.GOLD + "Next: " + EnumChatFormatting.LIGHT_PURPLE + requirement + EnumChatFormatting.GRAY + " (" + EnumChatFormatting.BLUE + jpCost + " JP" + EnumChatFormatting.GRAY + ")";
    }

    private void notifyNextRequirement(EntityPlayer player, int step) {
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Next Requirement: " + EnumChatFormatting.LIGHT_PURPLE + this.getNextRequirementMessage(step)));
    }

    private void checkSharinganSize(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (props.getSharinganSize() >= 3) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.DARK_RED + "3-Tomoe Sharingan"));
            this.advanceStep(stack);
            this.notifyNextRequirement(player, this.getCurrentStep(stack));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Your Sharingan must reach " + EnumChatFormatting.DARK_RED + "3-Tomoe" + EnumChatFormatting.RED + " to proceed."));
        }
    }

    private void checkMangekyouSharingan(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (!props.getmangekyouSharingan().equals("None")) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.DARK_RED + "Mangekyou Sharingan unlocked"));
            this.advanceStep(stack);
            this.notifyNextRequirement(player, this.getCurrentStep(stack));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You must unlock the " + EnumChatFormatting.DARK_RED + "Mangekyou Sharingan" + EnumChatFormatting.RED + " to proceed."));
        }
    }

    private void checkYinYangRelease(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (props.getYinyangRelease() == 1 || props.getYinRelease() == 1 && props.getYangRelease() == 1) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.DARK_PURPLE + "Yin-Yang Release"));
            this.advanceStep(stack);
            this.notifyNextRequirement(player, this.getCurrentStep(stack));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need " + EnumChatFormatting.DARK_PURPLE + "Yin-Yang Release" + EnumChatFormatting.RED + " or both " + EnumChatFormatting.BLACK + "Yin " + EnumChatFormatting.RED + "and " + EnumChatFormatting.WHITE + "Yang " + EnumChatFormatting.RED + "Releases."));
        }
    }

    private void checkFireRelease(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (props.getFireRelease() == 1) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.RED + "Fire Release"));
            this.advanceStep(stack);
            this.notifyNextRequirement(player, this.getCurrentStep(stack));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to unlock the " + EnumChatFormatting.DARK_RED + "Fire Release" + EnumChatFormatting.RED + " to proceed."));
        }
    }

    private void checkWindRelease(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (props.getWindRelease() == 1) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.DARK_GREEN + "Wind Release"));
            this.advanceStep(stack);
            this.notifyNextRequirement(player, this.getCurrentStep(stack));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to unlock the " + EnumChatFormatting.DARK_GREEN + "Wind Release" + EnumChatFormatting.RED + " to proceed."));
        }
    }

    private void checkLightningRelease(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (props.getLightningRelease() == 1) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.AQUA + "Lightning Release"));
            this.advanceStep(stack);
            this.notifyNextRequirement(player, this.getCurrentStep(stack));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to unlock the " + EnumChatFormatting.AQUA + "Lightning Release" + EnumChatFormatting.RED + " to proceed."));
        }
    }

    private void checkWaterRelease(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (props.getWaterRelease() == 1) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.BLUE + "Water Release"));
            this.advanceStep(stack);
            this.notifyNextRequirement(player, this.getCurrentStep(stack));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to unlock the " + EnumChatFormatting.BLUE + "Water Release" + EnumChatFormatting.RED + " to proceed."));
        }
    }

    private void checkEarthRelease(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (props.getEarthRelease() == 1) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.DARK_GRAY + "Earth Release"));
            this.advanceStep(stack);
            this.notifyNextRequirement(player, this.getCurrentStep(stack));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to unlock the " + EnumChatFormatting.DARK_GRAY + "Earth Release" + EnumChatFormatting.RED + " to proceed."));
        }
    }

    private void checkWoodRelease(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (props.getwoodRelease() == 1) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.DARK_GREEN + "Wood Release"));
            this.advanceStep(stack);
            this.notifyNextRequirement(player, this.getCurrentStep(stack));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to unlock the " + EnumChatFormatting.DARK_GREEN + "Wood Release" + EnumChatFormatting.RED + " to proceed."));
        }
    }

    private void checkLevelAndUnlockRinnegan(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        if (props.getLevel() >= 1000) {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Requirement met: " + EnumChatFormatting.AQUA + "Level 1000"));
            this.unlockRinnegan(player, props, stack);
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You must reach " + EnumChatFormatting.AQUA + "Level 1000" + EnumChatFormatting.RED + " to proceed."));
        }
    }

    private void unlockRinnegan(EntityPlayer player, ExtendedPlayer props, ItemStack stack) {
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.BOLD + "All requirements met! You have awakened the Rinnegan!"));
        Helper.giveOrDropItem(player, new ItemStack(AddedItems.SkillLearnerRinnegan));
        props.setSharinganSize(6);
        props.setSharinganActive(3);
        PacketDispatcher.sendTo(new SyncSharinganSizeMessage(player), (EntityPlayerMP)player);
        PacketDispatcher.sendTo(new SyncSharinganActiveMessage(player), (EntityPlayerMP)player);
        this.advanceStep(stack);
        --stack.field_77994_a;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return false;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (itemStack.field_77990_d == null) {
                itemStack.field_77990_d = new NBTTagCompound();
            }
            if (!itemStack.field_77990_d.func_74764_b("OwnerUUID")) {
                this.initializeItem(itemStack, player);
            }
        }
    }

    protected void initializeItem(ItemStack stack, EntityPlayer player) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.field_77990_d.func_74764_b("OwnerUUID")) {
            stack.field_77990_d.func_74778_a("OwnerUUID", player.func_110124_au().toString());
        }
    }
}

