/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.TransformationsRealPackage;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import narutodestination.Mathioks.AbstractMessage;
import narutodestination.Mathioks.AddedItems;
import narutodestination.Mathioks.Config.GeneralConfig;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.PacketDispatcher;
import narutodestination.Mathioks.TransformationsRealPackage.Helper;
import narutodestination.Mathioks.TransformationsRealPackage.SyncHealthMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class IncreaseMedicalMessage
extends AbstractMessage<IncreaseMedicalMessage> {
    private int increaseValue;

    public IncreaseMedicalMessage() {
    }

    public IncreaseMedicalMessage(int increaseValue) {
        this.increaseValue = increaseValue;
    }

    @Override
    protected void read(PacketBuffer var1) throws IOException {
        this.increaseValue = var1.readInt();
    }

    @Override
    protected void write(PacketBuffer var1) throws IOException {
        var1.writeInt(this.increaseValue);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            return;
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.get(player);
        int skillPoints = extendedPlayer.getSkillPoints();
        if (skillPoints < this.increaseValue) {
            PacketDispatcher.sendTo(new SyncHealthMessage(player), (EntityPlayerMP)player);
            System.out.println("Player " + player.getDisplayName() + " tried to increase medical by " + this.increaseValue + " but only has " + skillPoints + " skillpoints");
            return;
        }
        int oldMedical = extendedPlayer.getMedical();
        extendedPlayer.setHealth(Math.min(extendedPlayer.getHealthCap(), extendedPlayer.getHealth() + this.increaseValue));
        extendedPlayer.setSkillPoints(skillPoints - this.increaseValue);
        extendedPlayer.setMedical(oldMedical + this.increaseValue);
        player.func_70691_i((float)this.increaseValue);
        if (GeneralConfig.medicalSkillLearnerThreshold != -1) {
            int newMedical = extendedPlayer.getMedical();
            if (!extendedPlayer.getSkillLearnerMedical() && oldMedical < GeneralConfig.medicalSkillLearnerThreshold && newMedical >= GeneralConfig.medicalSkillLearnerThreshold) {
                ItemStack skillLearner = new ItemStack(AddedItems.SkillLearnerMedical, 1);
                Helper.giveOrDropItem(player, skillLearner);
                extendedPlayer.setSkillLearnerMedical(true, Side.SERVER);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "Achievement Unlocked: " + EnumChatFormatting.YELLOW + "Skill Learner: Medical!"));
                System.out.println("Player " + player.getDisplayName() + " unlocked Skill Learner: Medical!");
            }
        }
    }
}

