/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.Weapons;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import narutodestination.Mathioks.ExtendedPlayer;
import narutodestination.Mathioks.ModeMultiplierHandler;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class OtherSwordsConfig {
    private static Configuration configuration;
    private static final Map<String, OtherSwordStats> swordStatsMap;

    public static void init(File configFile) {
        configuration = new Configuration(configFile);
        OtherSwordsConfig.loadDefaultSwords();
        OtherSwordsConfig.loadConfig();
    }

    private static void loadDefaultSwords() {
        OtherSwordsConfig.registerSword("minecraft:wooden_sword", Items.field_151041_m);
        OtherSwordsConfig.registerSword("minecraft:stone_sword", Items.field_151052_q);
        OtherSwordsConfig.registerSword("minecraft:iron_sword", Items.field_151040_l);
        OtherSwordsConfig.registerSword("minecraft:golden_sword", Items.field_151010_B);
        OtherSwordsConfig.registerSword("minecraft:diamond_sword", Items.field_151048_u);
    }

    private static void registerSword(String itemId, Item item) {
        if (!swordStatsMap.containsKey(itemId)) {
            OtherSwordStats stats = new OtherSwordStats();
            stats.itemId = itemId;
            stats.item = item;
            swordStatsMap.put(itemId, stats);
        }
    }

    public static void loadConfig() {
        if (configuration == null) {
            return;
        }
        configuration.load();
        for (Map.Entry<String, OtherSwordStats> entry : swordStatsMap.entrySet()) {
            String itemId = entry.getKey();
            OtherSwordStats stats = entry.getValue();
            String configName = itemId.replace(":", "_");
            stats.baseDamage = configuration.get(configName, "A BaseDamage", OtherSwordsConfig.getDefaultBaseDamage(itemId)).getDouble();
            stats.kenScaling = configuration.get(configName, "B KenScaling", OtherSwordsConfig.getDefaultKenScaling(itemId)).getDouble();
            stats.shurikenScaling = configuration.get(configName, "C ShurikenScaling", 0.0).getDouble();
            stats.ninScaling = configuration.get(configName, "D NinScaling", 0.0).getDouble();
            stats.taiScaling = configuration.get(configName, "E TaiScaling", 0.0).getDouble();
            stats.genScaling = configuration.get(configName, "F GenScaling", 0.0).getDouble();
            stats.summonScaling = configuration.get(configName, "G SummonScaling", 0.0).getDouble();
            stats.kinScaling = configuration.get(configName, "H KinScaling", 0.0).getDouble();
            stats.senScaling = configuration.get(configName, "I SenScaling", 0.0).getDouble();
            stats.medicalScaling = configuration.get(configName, "J MedicalScaling", 0.0).getDouble();
            stats.requiredKenjutsu = configuration.get(configName, "K RequiredKenjutsu", 0).getInt();
            stats.requiredShurikenjutsu = configuration.get(configName, "L RequiredShurikenjutsu", 0).getInt();
            stats.damageCap = configuration.get(configName, "M DamageCap", -1.0).getDouble();
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private static double getDefaultBaseDamage(String itemId) {
        if (itemId.equals("minecraft:wooden_sword")) {
            return 3.0;
        }
        if (itemId.equals("minecraft:stone_sword")) {
            return 5.0;
        }
        if (itemId.equals("minecraft:iron_sword")) {
            return 4.0;
        }
        if (itemId.equals("minecraft:golden_sword")) {
            return 7.0;
        }
        if (itemId.equals("minecraft:diamond_sword")) {
            return 15.0;
        }
        return 3.0;
    }

    private static double getDefaultKenScaling(String itemId) {
        if (itemId.equals("minecraft:wooden_sword")) {
            return 0.05;
        }
        if (itemId.equals("minecraft:stone_sword")) {
            return 0.06;
        }
        if (itemId.equals("minecraft:iron_sword")) {
            return 0.07;
        }
        if (itemId.equals("minecraft:golden_sword")) {
            return 0.08;
        }
        if (itemId.equals("minecraft:diamond_sword")) {
            return 0.09;
        }
        return 0.05;
    }

    public static boolean addSword(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        String itemId = GameRegistry.findUniqueIdentifierFor((Item)item).toString();
        if (swordStatsMap.containsKey(itemId)) {
            return false;
        }
        OtherSwordsConfig.registerSword(itemId, item);
        OtherSwordsConfig.loadConfig();
        return true;
    }

    public static boolean isSwordRegistered(Item item) {
        if (item == null) {
            return false;
        }
        String itemId = GameRegistry.findUniqueIdentifierFor((Item)item).toString();
        return swordStatsMap.containsKey(itemId);
    }

    public static OtherSwordStats getSwordStats(Item item) {
        if (item == null) {
            return null;
        }
        String itemId = GameRegistry.findUniqueIdentifierFor((Item)item).toString();
        return swordStatsMap.get(itemId);
    }

    static {
        swordStatsMap = new HashMap<String, OtherSwordStats>();
    }

    public static class OtherSwordStats {
        public String itemId;
        public Item item;
        public double baseDamage;
        public double medicalScaling;
        public double kenScaling;
        public double ninScaling;
        public double taiScaling;
        public double genScaling;
        public double shurikenScaling;
        public double summonScaling;
        public double kinScaling;
        public double senScaling;
        public int requiredKenjutsu;
        public int requiredShurikenjutsu;
        public String description;
        public double damageCap;

        public double getDamage(ExtendedPlayer props) {
            double baseDamageTotal = this.baseDamage + (double)props.getNinjutsu() * this.ninScaling + (double)props.getTaijutsu() * this.taiScaling + (double)props.getGenjutsu() * this.genScaling + (double)props.getKenjutsu() * this.kenScaling + (double)props.getShurikenJutsu() * this.shurikenScaling + (double)props.getSummoning() * this.summonScaling + (double)props.getKinjutsu() * this.kinScaling + (double)props.getMedical() * this.medicalScaling + (double)props.getSenjutsu() * this.senScaling;
            double modeMultiplier = ModeMultiplierHandler.getModeMultiplier(props);
            double finalDamage = baseDamageTotal * modeMultiplier;
            if (this.damageCap > 0.0 && finalDamage > this.damageCap) {
                return this.damageCap;
            }
            return finalDamage;
        }
    }
}

