/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class JutsuBlock
extends Block {
    private final int lifespanTicks;
    private static Map<String, UUID> blockOwners = new HashMap<String, UUID>();
    private static Map<String, Float> blockDamage = new HashMap<String, Float>();

    private static String getKey(int x, int y, int z) {
        return x + "," + y + "," + z;
    }

    protected JutsuBlock(Material material, int lifespanTicks) {
        super(material);
        this.lifespanTicks = lifespanTicks;
        this.func_149675_a(false);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, this.lifespanTicks);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K) {
            JutsuBlock.removeBlockData(x, y, z);
            world.func_147468_f(x, y, z);
        }
    }

    public static void setOwner(int x, int y, int z, EntityPlayer owner) {
        if (owner != null) {
            blockOwners.put(JutsuBlock.getKey(x, y, z), owner.func_110124_au());
        }
    }

    public static void setCollisionDamage(int x, int y, int z, float damage) {
        if (damage > 0.0f) {
            blockDamage.put(JutsuBlock.getKey(x, y, z), Float.valueOf(damage));
        }
    }

    public static void setOwnerAndDamage(int x, int y, int z, EntityPlayer owner, float damage) {
        JutsuBlock.setOwner(x, y, z, owner);
        JutsuBlock.setCollisionDamage(x, y, z, damage);
    }

    public static void removeOwner(int x, int y, int z) {
        blockOwners.remove(JutsuBlock.getKey(x, y, z));
    }

    public static void removeDamage(int x, int y, int z) {
        blockDamage.remove(JutsuBlock.getKey(x, y, z));
    }

    public static void removeBlockData(int x, int y, int z) {
        JutsuBlock.removeOwner(x, y, z);
        JutsuBlock.removeDamage(x, y, z);
    }

    protected EntityPlayer getOwner(World world, int x, int y, int z) {
        UUID ownerUUID = blockOwners.get(JutsuBlock.getKey(x, y, z));
        if (ownerUUID != null) {
            for (Object obj : world.field_73010_i) {
                EntityPlayer player;
                if (!(obj instanceof EntityPlayer) || !(player = (EntityPlayer)obj).func_110124_au().equals(ownerUUID)) continue;
                return player;
            }
        }
        return null;
    }

    protected float getCollisionDamage(int x, int y, int z) {
        Float damage = blockDamage.get(JutsuBlock.getKey(x, y, z));
        return damage != null ? damage.floatValue() : 0.0f;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        JutsuBlock.removeBlockData(x, y, z);
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        float damage = this.getCollisionDamage(x, y, z);
        if (damage <= 0.0f) {
            return;
        }
        EntityPlayer owner = this.getOwner(world, x, y, z);
        if (entity == owner) {
            return;
        }
        if (owner != null) {
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)owner), damage);
        } else {
            entity.func_70097_a(DamageSource.field_76367_g, damage);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return null;
    }
}

