/*
 * Decompiled with CFR 0.152.
 */
package narutodestination.Mathioks;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CapeDataFetcher {
    private static final String CAPE_URL = "http://88.99.169.168/capes.json";

    public static Map<UUID, List<String>> fetchCapeData() {
        HashMap<UUID, List<String>> capeMap = new HashMap<UUID, List<String>>();
        try {
            URL url = new URL(CAPE_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() == 200) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder jsonBuilder = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    jsonBuilder.append(line);
                }
                in.close();
                String json = jsonBuilder.toString();
                System.out.println("[CapeFetcher] Raw response: " + json);
                if (!json.trim().startsWith("{")) {
                    System.err.println("[CapeFetcher] \u274c Ung\u00fcltiges JSON-Format erhalten!");
                    return capeMap;
                }
                Gson gson = new Gson();
                Type mapType = new TypeToken<Map<String, List<String>>>(){}.getType();
                Map rawMap = (Map)gson.fromJson(json, mapType);
                for (Map.Entry entry : rawMap.entrySet()) {
                    try {
                        UUID uuid = UUID.fromString((String)entry.getKey());
                        capeMap.put(uuid, (List<String>)entry.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("[CapeFetcher] \u26a0\ufe0f Ung\u00fcltige UUID: " + (String)entry.getKey());
                    }
                }
            } else {
                System.err.println("[CapeFetcher] \u274c HTTP Error: " + conn.getResponseCode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("[CapeFetcher] \u274c Fehler beim Laden der Cape-Daten: " + e.getMessage());
        }
        return capeMap;
    }
}

